/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.proxy;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import sun.rmi.transport.proxy.HttpInputStream;
import sun.rmi.transport.proxy.HttpOutputStream;
import sun.rmi.transport.proxy.RMISocketInfo;
import sun.rmi.transport.proxy.WrappedSocket;

public class HttpReceiveSocket
extends WrappedSocket
implements RMISocketInfo {
    private boolean headerSent = false;

    public HttpReceiveSocket(Socket socket, InputStream inputStream, OutputStream outputStream) throws IOException {
        super(socket, inputStream, outputStream);
        this.in = new HttpInputStream(inputStream != null ? inputStream : socket.getInputStream());
        this.out = outputStream != null ? outputStream : socket.getOutputStream();
    }

    public synchronized void close() throws IOException {
        this.getOutputStream().close();
        this.socket.close();
    }

    public InetAddress getInetAddress() {
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.headerSent) {
            DataOutputStream dataOutputStream = new DataOutputStream(this.out);
            dataOutputStream.writeBytes("HTTP/1.0 200 OK\r\n");
            dataOutputStream.flush();
            this.headerSent = true;
            this.out = new HttpOutputStream(this.out);
        }
        return this.out;
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public boolean isReusable() {
        return false;
    }

    public String toString() {
        return "HttpReceive" + this.socket.toString();
    }
}

