/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import sun.misc.HexDumpEncoder;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs.PKCS9Attributes;
import sun.security.pkcs.ParsingException;
import sun.security.util.BigInt;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X500Name;

public class SignerInfo
implements DerEncoder {
    BigInt version;
    X500Name issuerName;
    BigInt certificateSerialNumber;
    AlgorithmId digestAlgorithmId;
    AlgorithmId digestEncryptionAlgorithmId;
    byte[] encryptedDigest;
    PKCS9Attributes authenticatedAttributes;
    PKCS9Attributes unauthenticatedAttributes;

    public SignerInfo(DerInputStream derInputStream) throws IOException, ParsingException {
        this(derInputStream, false);
    }

    public SignerInfo(DerInputStream derInputStream, boolean bl) throws IOException, ParsingException {
        this.version = derInputStream.getInteger();
        DerValue[] derValueArray = derInputStream.getSequence(2);
        byte[] byArray = derValueArray[0].toByteArray();
        this.issuerName = new X500Name(new DerValue(48, byArray));
        this.certificateSerialNumber = derValueArray[1].getInteger();
        DerValue derValue = derInputStream.getDerValue();
        this.digestAlgorithmId = AlgorithmId.parse(derValue);
        if (bl) {
            derInputStream.getSet(0);
        } else if ((byte)derInputStream.peekByte() == -96) {
            this.authenticatedAttributes = new PKCS9Attributes(derInputStream);
        }
        derValue = derInputStream.getDerValue();
        this.digestEncryptionAlgorithmId = AlgorithmId.parse(derValue);
        this.encryptedDigest = derInputStream.getOctetString();
        if (bl) {
            derInputStream.getSet(0);
        } else if (derInputStream.available() != 0 && (byte)derInputStream.peekByte() == -95) {
            this.unauthenticatedAttributes = new PKCS9Attributes(derInputStream);
        }
        if (derInputStream.available() != 0) {
            throw new ParsingException("extra data at the end");
        }
    }

    public SignerInfo(X500Name x500Name, BigInt bigInt, AlgorithmId algorithmId, PKCS9Attributes pKCS9Attributes, AlgorithmId algorithmId2, byte[] byArray, PKCS9Attributes pKCS9Attributes2) {
        this.version = new BigInt(1);
        this.issuerName = x500Name;
        this.certificateSerialNumber = bigInt;
        this.digestAlgorithmId = algorithmId;
        this.authenticatedAttributes = pKCS9Attributes;
        this.digestEncryptionAlgorithmId = algorithmId2;
        this.encryptedDigest = byArray;
        this.unauthenticatedAttributes = pKCS9Attributes2;
    }

    public SignerInfo(X500Name x500Name, BigInt bigInt, AlgorithmId algorithmId, AlgorithmId algorithmId2, byte[] byArray) {
        this.version = new BigInt(1);
        this.issuerName = x500Name;
        this.certificateSerialNumber = bigInt;
        this.digestAlgorithmId = algorithmId;
        this.digestEncryptionAlgorithmId = algorithmId2;
        this.encryptedDigest = byArray;
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(this.version);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.issuerName.encode(derOutputStream2);
        derOutputStream2.putInteger(this.certificateSerialNumber);
        derOutputStream.write((byte)48, derOutputStream2);
        this.digestAlgorithmId.encode(derOutputStream);
        if (this.authenticatedAttributes != null) {
            this.authenticatedAttributes.encode((byte)-96, derOutputStream);
        }
        this.digestEncryptionAlgorithmId.encode(derOutputStream);
        derOutputStream.putOctetString(this.encryptedDigest);
        if (this.unauthenticatedAttributes != null) {
            this.unauthenticatedAttributes.encode((byte)-95, derOutputStream);
        }
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream3.toByteArray());
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        this.derEncode(derOutputStream);
    }

    public PKCS9Attributes getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public X509Certificate getCertificate(PKCS7 pKCS7) throws IOException {
        return pKCS7.getCertificate(this.certificateSerialNumber, this.issuerName);
    }

    public ArrayList getCertificateChain(PKCS7 pKCS7) throws IOException {
        boolean bl;
        X509Certificate x509Certificate = pKCS7.getCertificate(this.certificateSerialNumber, this.issuerName);
        if (x509Certificate == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(x509Certificate);
        X509Certificate[] x509CertificateArray = pKCS7.getCertificates();
        if (x509CertificateArray == null || x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN())) {
            return arrayList;
        }
        Principal principal = x509Certificate.getIssuerDN();
        int n = 0;
        block0: do {
            bl = false;
            int n2 = n;
            while (n2 < x509CertificateArray.length) {
                if (principal.equals(x509CertificateArray[n2].getSubjectDN())) {
                    arrayList.add(x509CertificateArray[n2]);
                    if (x509CertificateArray[n2].getSubjectDN().equals(x509CertificateArray[n2].getIssuerDN())) {
                        n = x509CertificateArray.length;
                    } else {
                        principal = x509CertificateArray[n2].getIssuerDN();
                        X509Certificate x509Certificate2 = x509CertificateArray[n];
                        x509CertificateArray[n] = x509CertificateArray[n2];
                        x509CertificateArray[n2] = x509Certificate2;
                        ++n;
                    }
                    bl = true;
                    continue block0;
                }
                ++n2;
            }
        } while (bl);
        return arrayList;
    }

    public BigInt getCertificateSerialNumber() {
        return this.certificateSerialNumber;
    }

    public AlgorithmId getDigestAlgorithmId() {
        return this.digestAlgorithmId;
    }

    public AlgorithmId getDigestEncryptionAlgorithmId() {
        return this.digestEncryptionAlgorithmId;
    }

    public byte[] getEncryptedDigest() {
        return this.encryptedDigest;
    }

    public X500Name getIssuerName() {
        return this.issuerName;
    }

    public PKCS9Attributes getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes;
    }

    public BigInt getVersion() {
        return this.version;
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string = "";
        string = String.valueOf(string) + "Signer Info for (issuer): " + this.issuerName + "\n";
        string = String.valueOf(string) + "\tversion: " + this.version + "\n";
        string = String.valueOf(string) + "\tcertificateSerialNumber: " + this.certificateSerialNumber + "\n";
        string = String.valueOf(string) + "\tdigestAlgorithmId: " + this.digestAlgorithmId + "\n";
        if (this.authenticatedAttributes != null) {
            string = String.valueOf(string) + "\tauthenticatedAttributes: " + this.authenticatedAttributes + "\n";
        }
        string = String.valueOf(string) + "\tdigestEncryptionAlgorithmId: " + this.digestEncryptionAlgorithmId + "\n";
        string = String.valueOf(string) + "\tencryptedDigest: \n" + hexDumpEncoder.encodeBuffer(this.encryptedDigest) + "\n";
        if (this.unauthenticatedAttributes != null) {
            string = String.valueOf(string) + "\tunauthenticatedAttributes: " + this.unauthenticatedAttributes + "\n";
        }
        return string;
    }

    SignerInfo verify(PKCS7 pKCS7) throws NoSuchAlgorithmException, SignatureException {
        return this.verify(pKCS7, null);
    }

    SignerInfo verify(PKCS7 pKCS7, byte[] byArray) throws NoSuchAlgorithmException, SignatureException {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            byte[] byArray2;
            String string;
            ContentInfo contentInfo = pKCS7.getContentInfo();
            if (byArray == null) {
                byArray = contentInfo.getContentBytes();
            }
            if ((string = this.getDigestAlgorithmId().getName()).equalsIgnoreCase("SHA")) {
                string = "SHA1";
            }
            if (this.authenticatedAttributes == null) {
                byArray2 = byArray;
            } else {
                object5 = (ObjectIdentifier)this.authenticatedAttributes.getAttributeValue(PKCS9Attribute.CONTENT_TYPE_OID);
                if (object5 == null || !((ObjectIdentifier)object5).equals(contentInfo.contentType)) {
                    return null;
                }
                object4 = (byte[])this.authenticatedAttributes.getAttributeValue(PKCS9Attribute.MESSAGE_DIGEST_OID);
                if (object4 == null) {
                    return null;
                }
                object3 = MessageDigest.getInstance(string);
                object2 = ((MessageDigest)object3).digest(byArray);
                if (((byte[])object4).length != ((byte[])object2).length) {
                    return null;
                }
                int n = 0;
                while (n < ((byte[])object4).length) {
                    if (object4[n] != object2[n]) {
                        return null;
                    }
                    ++n;
                }
                byArray2 = this.authenticatedAttributes.getDerEncoding();
            }
            object5 = this.getDigestEncryptionAlgorithmId().getName();
            if (((String)object5).equalsIgnoreCase("SHA1withDSA")) {
                object5 = "DSA";
            }
            object4 = String.valueOf(string) + "with" + (String)object5;
            object3 = Signature.getInstance((String)object4);
            object2 = this.getCertificate(pKCS7);
            if (object2 == null) {
                return null;
            }
            if (object2.hasUnsupportedCriticalExtension()) {
                throw new SignatureException("Certificate has unsupported critical extension(s)");
            }
            byte[] byArray3 = object2.getExtensionValue(PKIXExtensions.KeyUsage_Id.toString());
            if (byArray3 != null) {
                try {
                    object = new KeyUsageExtension(new Boolean(true), byArray3);
                }
                catch (IOException iOException) {
                    throw new SignatureException("Failed to parse keyUsage extension");
                }
                boolean bl = (Boolean)((KeyUsageExtension)object).get("digital_signature");
                if (!bl) {
                    throw new SignatureException("Key usage restricted: cannot be used for digital signatures");
                }
            }
            object = object2.getPublicKey();
            ((Signature)object3).initVerify((PublicKey)object);
            ((Signature)object3).update(byArray2);
            if (((Signature)object3).verify(this.encryptedDigest)) {
                return this;
            }
        }
        catch (IOException iOException) {
            throw new SignatureException("IO error verifying signature:\n" + iOException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException("InvalidKey: " + invalidKeyException.getMessage());
        }
        return null;
    }
}

