/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.UniqueIdentity;

public class CertificateIssuerUniqueIdentity
implements CertAttrSet {
    private UniqueIdentity id;
    public static final String IDENT = "x509.info.issuerID";
    public static final String NAME = "issuerID";
    public static final String ID = "id";

    public CertificateIssuerUniqueIdentity(InputStream inputStream) throws IOException {
        DerValue derValue = new DerValue(inputStream);
        this.id = new UniqueIdentity(derValue);
    }

    public CertificateIssuerUniqueIdentity(DerInputStream derInputStream) throws IOException {
        this.id = new UniqueIdentity(derInputStream);
    }

    public CertificateIssuerUniqueIdentity(DerValue derValue) throws IOException {
        this.id = new UniqueIdentity(derValue);
    }

    public CertificateIssuerUniqueIdentity(UniqueIdentity uniqueIdentity) {
        this.id = uniqueIdentity;
    }

    public void decode(InputStream inputStream) throws IOException {
        DerValue derValue = new DerValue(inputStream);
        this.id = new UniqueIdentity(derValue);
    }

    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(ID)) {
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateIssuerUniqueIdentity.");
        }
        this.id = null;
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.id.encode(derOutputStream, DerValue.createTag((byte)-128, false, (byte)1));
        outputStream.write(derOutputStream.toByteArray());
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(ID)) {
            return this.id;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet: CertificateIssuerUniqueIdentity.");
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(ID);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }

    public void set(String string, Object object) throws IOException {
        if (!(object instanceof UniqueIdentity)) {
            throw new IOException("Attribute must be of type UniqueIdentity.");
        }
        if (!string.equalsIgnoreCase(ID)) {
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateIssuerUniqueIdentity.");
        }
        this.id = (UniqueIdentity)object;
    }

    public String toString() {
        if (this.id == null) {
            return "";
        }
        return this.id.toString();
    }
}

