/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.util.Vector;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.CertificatePolicyId;

public class CertificatePolicySet {
    private Vector ids;

    public CertificatePolicySet(Vector vector) {
        this.ids = vector;
    }

    public CertificatePolicySet(DerInputStream derInputStream) throws IOException {
        this.ids = new Vector(1, 1);
        DerValue[] derValueArray = derInputStream.getSequence(5);
        int n = 0;
        while (n < derValueArray.length) {
            CertificatePolicyId certificatePolicyId = new CertificatePolicyId(derValueArray[n]);
            this.ids.addElement(certificatePolicyId);
            ++n;
        }
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        int n = 0;
        while (n < this.ids.size()) {
            ((CertificatePolicyId)this.ids.elementAt(n)).encode(derOutputStream2);
            ++n;
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public String toString() {
        String string = "CertificatePolicySet:[\n" + this.ids.toString() + "]\n";
        return string;
    }
}

