/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;

class ComponentOrientationChanger
extends JMenu
implements ItemListener {
    JRadioButtonMenuItem ltrRb;
    JRadioButtonMenuItem rtlRb;

    public ComponentOrientationChanger() {
        super("Component Orientation");
        this.getAccessibleContext().setAccessibleDescription("Sub-menu containing options for changing the orientation of the Swing Components.");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.ltrRb = (JRadioButtonMenuItem)this.add(new JRadioButtonMenuItem("Left To Right"));
        this.ltrRb.getAccessibleContext().setAccessibleDescription("Orient Components for left to right languages.");
        this.ltrRb.setSelected(true);
        this.ltrRb.addItemListener(this);
        buttonGroup.add(this.ltrRb);
        this.rtlRb = (JRadioButtonMenuItem)this.add(new JRadioButtonMenuItem("Right To Left"));
        this.rtlRb.getAccessibleContext().setAccessibleDescription("Orient Components for left to right languages.");
        this.rtlRb.addItemListener(this);
        buttonGroup.add(this.rtlRb);
    }

    private void applyOrientation(Component component, ComponentOrientation componentOrientation) {
        block3: {
            block2: {
                component.setComponentOrientation(componentOrientation);
                if (!(component instanceof JMenu)) break block2;
                JMenu jMenu = (JMenu)component;
                int n = jMenu.getMenuComponentCount();
                int n2 = 0;
                while (n2 < n) {
                    this.applyOrientation(jMenu.getMenuComponent(n2), componentOrientation);
                    ++n2;
                }
                break block3;
            }
            if (!(component instanceof Container)) break block3;
            Container container = (Container)component;
            int n = container.getComponentCount();
            int n3 = 0;
            while (n3 < n) {
                this.applyOrientation(container.getComponent(n3), componentOrientation);
                ++n3;
            }
        }
    }

    static ComponentOrientationChanger create() {
        return new ComponentOrientationChanger();
    }

    private void dumpOrientation(Component component, int n) {
        ComponentOrientation componentOrientation = component.getComponentOrientation();
        int n2 = 0;
        while (n2 < n) {
            System.out.print("\t");
            ++n2;
        }
        System.out.println(String.valueOf(String.valueOf(component)) + " isLTR=" + componentOrientation.isLeftToRight());
        if (component instanceof Container) {
            Container container = (Container)component;
            int n3 = container.getComponentCount();
            int n4 = 0;
            while (n4 < n3) {
                this.dumpOrientation(container.getComponent(n4), n + 1);
                ++n4;
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)itemEvent.getSource();
        if (jRadioButtonMenuItem.isSelected()) {
            String string = jRadioButtonMenuItem.getText();
            ComponentOrientation componentOrientation = string.equals("Left To Right") ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT;
            Container container = SwingSet.sharedInstance().getRootComponent();
            this.applyOrientation(container, componentOrientation);
            this.fireActionPerformed(new ActionEvent(this, 0, "OrientationChanged"));
            container.validate();
            container.repaint();
        }
    }
}

