/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

public class ExampleFileFilter
extends FileFilter {
    private static String TYPE_UNKNOWN = "Type Unknown";
    private static String HIDDEN_FILE = "Hidden File";
    private Hashtable filters = null;
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public ExampleFileFilter() {
        this((String)null, (String)null);
    }

    public ExampleFileFilter(String string) {
        this(string, null);
    }

    public ExampleFileFilter(String string, String string2) {
        this(new String[]{string}, string2);
    }

    public ExampleFileFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public ExampleFileFilter(String[] stringArray, String string) {
        this.filters = new Hashtable(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            this.addExtension(stringArray[n]);
            ++n;
        }
        this.setDescription(string);
    }

    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null && this.filters.get(this.getExtension(file)) != null) {
                return true;
            }
        }
        return false;
    }

    public void addExtension(String string) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(string.toLowerCase(), this);
        this.fullDescription = null;
    }

    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                if (this.description != null) {
                    this.fullDescription = this.description;
                }
                this.fullDescription = String.valueOf(this.fullDescription) + " (";
                Enumeration enumeration = this.filters.keys();
                if (enumeration != null) {
                    this.fullDescription = String.valueOf(this.fullDescription) + "." + (String)enumeration.nextElement();
                    while (enumeration.hasMoreElements()) {
                        this.fullDescription = String.valueOf(this.fullDescription) + ", " + (String)enumeration.nextElement();
                    }
                }
                this.fullDescription = String.valueOf(this.fullDescription) + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public String getExtension(File file) {
        String string;
        int n;
        if (file != null && (n = (string = file.getName()).lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public void setDescription(String string) {
        this.description = string;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean bl) {
        this.useExtensionsInDescription = bl;
        this.fullDescription = null;
    }
}

