/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

class GridComponent
extends Component {
    protected int gridCount;
    protected int gridSize;
    protected Color currentColor;
    protected int preferredSize;

    public GridComponent(int n) {
        this.gridCount = n;
        this.gridSize = 10;
        this.currentColor = Color.lightGray;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredSize, this.preferredSize);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (this.gridSize > 0) {
            graphics.setColor(this.currentColor);
            int n = rectangle.y + rectangle.height;
            int n2 = rectangle.x + rectangle.width;
            int n3 = rectangle.y / this.gridSize * this.gridSize;
            int n4 = n / this.gridSize * this.gridSize;
            int n5 = rectangle.x / this.gridSize * this.gridSize;
            int n6 = n2 / this.gridSize * this.gridSize;
            int n7 = n5;
            while (n7 <= n6) {
                graphics.drawLine(n7, rectangle.y, n7, n);
                n7 += this.gridSize;
            }
            n7 = n3;
            while (n7 <= n4) {
                graphics.drawLine(rectangle.x, n7, n2, n7);
                n7 += this.gridSize;
            }
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = Math.min(n3, n4);
        this.currentColor = n5 < 100 ? Color.red : (n5 < 200 ? Color.blue : (n5 < 300 ? Color.yellow : Color.white));
        this.gridSize = Math.max(1, n5 / this.gridCount);
        super.setBounds(n, n2, n3, n4);
    }

    public void setPreferredSize(int n) {
        this.preferredSize = n;
    }
}

