/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

class HtmlPane
extends JScrollPane
implements HyperlinkListener {
    JEditorPane html;

    public HtmlPane() {
        try {
            File file = new File("HelpFiles/toc.html");
            String string = file.getAbsolutePath();
            string = "file:" + string;
            URL uRL = new URL(string);
            this.html = new JEditorPane(string);
            this.html.setEditable(false);
            this.html.addHyperlinkListener(this);
            JViewport jViewport = this.getViewport();
            jViewport.add(this.html);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Malformed URL: " + malformedURLException);
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(hyperlinkEvent.getURL());
        }
    }

    protected void linkActivated(URL uRL) {
        Cursor cursor = this.html.getCursor();
        Cursor cursor2 = Cursor.getPredefinedCursor(3);
        this.html.setCursor(cursor2);
        SwingUtilities.invokeLater(new PageLoader(uRL, cursor));
    }

    class PageLoader
    implements Runnable {
        URL url;
        Cursor cursor;

        PageLoader(URL uRL, Cursor cursor) {
            this.url = uRL;
            this.cursor = cursor;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            if (this.url == null) {
                HtmlPane.this.html.setCursor(this.cursor);
                Container container = HtmlPane.this.html.getParent();
                container.repaint();
                return;
            }
            Document document = HtmlPane.this.html.getDocument();
            try {
                try {
                    HtmlPane.this.html.setPage(this.url);
                }
                catch (IOException iOException) {
                    HtmlPane.this.html.setDocument(document);
                    HtmlPane.this.getToolkit().beep();
                }
                Object var3_3 = null;
                this.url = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.url = null;
                SwingUtilities.invokeLater(this);
                throw throwable;
            }
            SwingUtilities.invokeLater(this);
        }
    }
}

