/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalTheme;

public class MetalworksFrame
extends JFrame {
    JMenuBar menuBar;
    JDesktopPane desktop;
    JInternalFrame toolPalette;
    JCheckBoxMenuItem showToolPaletteMenuItem;
    static final Integer DOCLAYER = new Integer(5);
    static final Integer TOOLLAYER = new Integer(6);
    static final Integer HELPLAYER = new Integer(7);
    static final String ABOUTMSG = "Metalworks \n \nAn application written to show off the Java Look & Feel. \n \nWritten by the JavaSoft Look & Feel Team \n  Michael Albers\n  Tom Santos\n  Jeff Shapiro\n  Steve Wilson";

    public MetalworksFrame() {
        super("Metalworks");
        int n = 50;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setBounds(50, 50, dimension.width - 100, dimension.height - 100);
        this.buildContent();
        this.buildMenus();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MetalworksFrame.this.quit();
            }
        });
        UIManager.addPropertyChangeListener(new UISwitchListener(this.getRootPane()));
    }

    protected void buildContent() {
        this.desktop = new JDesktopPane();
        this.getContentPane().add(this.desktop);
    }

    protected JMenu buildEditMenu() {
        JMenu jMenu = new JMenu("Edit");
        JMenuItem jMenuItem = new JMenuItem("Undo");
        JMenuItem jMenuItem2 = new JMenuItem("Copy");
        JMenuItem jMenuItem3 = new JMenuItem("Cut");
        JMenuItem jMenuItem4 = new JMenuItem("Paste");
        JMenuItem jMenuItem5 = new JMenuItem("Preferences...");
        jMenuItem.setEnabled(false);
        jMenuItem2.setEnabled(false);
        jMenuItem3.setEnabled(false);
        jMenuItem4.setEnabled(false);
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetalworksFrame.this.openPrefsWindow();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenu.add(jMenuItem3);
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem4);
        jMenu.addSeparator();
        jMenu.add(jMenuItem5);
        return jMenu;
    }

    protected JMenu buildFileMenu() {
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("New");
        JMenuItem jMenuItem2 = new JMenuItem("Open");
        JMenuItem jMenuItem3 = new JMenuItem("Quit");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetalworksFrame.this.newDocument();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetalworksFrame.this.openDocument();
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetalworksFrame.this.quit();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        jMenu.add(jMenuItem3);
        return jMenu;
    }

    protected JMenu buildHelpMenu() {
        JMenu jMenu = new JMenu("Help");
        JMenuItem jMenuItem = new JMenuItem("About Metalworks...");
        JMenuItem jMenuItem2 = new JMenuItem("Open Help Window");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetalworksFrame.this.showAboutBox();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetalworksFrame.this.openHelpWindow();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        return jMenu;
    }

    protected void buildMenus() {
        this.menuBar = new JMenuBar();
        this.menuBar.setOpaque(true);
        JMenu jMenu = this.buildFileMenu();
        JMenu jMenu2 = this.buildEditMenu();
        JMenu jMenu3 = this.buildViewsMenu();
        JMenu jMenu4 = this.buildSpeedMenu();
        JMenu jMenu5 = this.buildHelpMenu();
        PropertiesMetalTheme propertiesMetalTheme = null;
        try {
            propertiesMetalTheme = new PropertiesMetalTheme(new FileInputStream("MyTheme.theme"));
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        MetalTheme[] metalThemeArray = new MetalTheme[]{new DefaultMetalTheme(), new GreenMetalTheme(), new AquaMetalTheme(), new KhakiMetalTheme(), new DemoMetalTheme(), new ContrastMetalTheme(), new BigContrastMetalTheme(), propertiesMetalTheme};
        MetalThemeMenu metalThemeMenu = new MetalThemeMenu("Theme", metalThemeArray);
        this.menuBar.add(jMenu);
        this.menuBar.add(jMenu2);
        this.menuBar.add(jMenu3);
        this.menuBar.add(metalThemeMenu);
        this.menuBar.add(jMenu4);
        this.menuBar.add(jMenu5);
        this.setJMenuBar(this.menuBar);
    }

    protected JMenu buildSpeedMenu() {
        JMenu jMenu = new JMenu("Drag");
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Normal");
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("Fast");
        JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem("Outline");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem2);
        buttonGroup.add(jRadioButtonMenuItem3);
        jRadioButtonMenuItem.setSelected(true);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetalworksFrame.this.desktop.putClientProperty("JDesktopPane.dragMode", null);
            }
        });
        jRadioButtonMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetalworksFrame.this.desktop.putClientProperty("JDesktopPane.dragMode", "faster");
            }
        });
        jRadioButtonMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetalworksFrame.this.desktop.putClientProperty("JDesktopPane.dragMode", "outline");
            }
        });
        jMenu.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem2);
        jMenu.add(jRadioButtonMenuItem3);
        return jMenu;
    }

    protected JMenu buildViewsMenu() {
        JMenu jMenu = new JMenu("Views");
        JMenuItem jMenuItem = new JMenuItem("Open In-Box");
        JMenuItem jMenuItem2 = new JMenuItem("Open Out-Box");
        jMenuItem2.setEnabled(false);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetalworksFrame.this.openInBox();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        return jMenu;
    }

    public void newDocument() {
        MetalworksDocumentFrame metalworksDocumentFrame = new MetalworksDocumentFrame();
        this.desktop.add((Component)metalworksDocumentFrame, DOCLAYER);
        try {
            metalworksDocumentFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public void openDocument() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.showOpenDialog(this);
    }

    public void openHelpWindow() {
        MetalworksHelp metalworksHelp = new MetalworksHelp();
        this.desktop.add((Component)metalworksHelp, HELPLAYER);
        try {
            metalworksHelp.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public void openInBox() {
        MetalworksInBox metalworksInBox = new MetalworksInBox();
        this.desktop.add((Component)metalworksInBox, DOCLAYER);
        try {
            metalworksInBox.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public void openPrefsWindow() {
        MetalworksPrefs metalworksPrefs = new MetalworksPrefs(this);
        metalworksPrefs.show();
    }

    public void quit() {
        System.exit(0);
    }

    public void showAboutBox() {
        JOptionPane.showMessageDialog(this, ABOUTMSG);
    }
}

