/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.oneone;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.oneone.SubWriterHolder11Writer;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public abstract class Abstract11SubWriter {
    protected final SubWriterHolder11Writer writer;
    protected int displayLength;

    Abstract11SubWriter(SubWriterHolder11Writer subWriterHolder11Writer) {
        this.writer = subWriterHolder11Writer;
    }

    protected void bold(String string) {
        this.writer.bold(string);
        this.displayLength += string.length();
    }

    protected String makeSpace(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(' ');
            ++n2;
        }
        return stringBuffer.toString();
    }

    public abstract ProgramElementDoc[] members(ClassDoc var1);

    protected String modifierString(MemberDoc memberDoc) {
        int n = memberDoc.modifierSpecifier();
        int n2 = 288;
        return Modifier.toString(n & ~n2);
    }

    protected String name(ProgramElementDoc programElementDoc) {
        return programElementDoc.name();
    }

    protected void print(char c) {
        this.writer.print(c);
        ++this.displayLength;
    }

    protected void print(String string) {
        this.writer.print(string);
        this.displayLength += string.length();
    }

    protected void printClassLink(ClassDoc classDoc) {
        this.writer.printClassLink(classDoc);
        this.displayLength += classDoc.name().length();
    }

    protected void printComment(ProgramElementDoc programElementDoc) {
        String string = programElementDoc.commentText();
        if (string.length() > 0) {
            this.writer.printNbsps();
            this.print(string);
        }
    }

    protected void printDeprecated(ProgramElementDoc programElementDoc) {
        Tag[] tagArray = programElementDoc.tags("deprecated");
        if (tagArray.length > 0) {
            String string = tagArray[0].text();
            this.writer.dd();
            this.writer.boldText("doclet.Note_0_is_deprecated", this.name(programElementDoc));
            if (string.length() > 0) {
                this.writer.italics(string);
            }
            this.writer.p();
        }
    }

    protected abstract void printDeprecatedLink(ProgramElementDoc var1);

    protected abstract void printFooter(ClassDoc var1);

    protected void printFullComment(ProgramElementDoc programElementDoc) {
        this.writer.dl();
        this.printDeprecated(programElementDoc);
        this.printComment(programElementDoc);
        this.printTags(programElementDoc);
        this.writer.dlEnd();
    }

    protected void printHead(MemberDoc memberDoc) {
        this.writer.h3();
        this.writer.print(memberDoc.name());
        this.writer.h3End();
    }

    protected abstract void printHeader(ClassDoc var1);

    protected abstract void printMember(ClassDoc var1, ProgramElementDoc var2);

    public void printMembers(ClassDoc classDoc) {
        ProgramElementDoc[] programElementDocArray = this.members(classDoc);
        if (programElementDocArray.length > 0) {
            this.printHeader(classDoc);
            int n = 0;
            while (n < programElementDocArray.length) {
                if (n > 0) {
                    this.writer.printMemberHeader();
                }
                this.printMember(classDoc, programElementDocArray[n]);
                this.writer.printMemberFooter();
                ++n;
            }
            this.printFooter(classDoc);
        }
    }

    public void printMembersSummary(ClassDoc classDoc) {
        Object[] objectArray = this.members(classDoc);
        if (objectArray.length > 0) {
            Arrays.sort(objectArray);
            this.printSummaryHeader(classDoc);
            int n = 0;
            while (n < objectArray.length) {
                this.printSummaryMember(classDoc, (ProgramElementDoc)objectArray[n]);
                ++n;
            }
            this.printSummaryFooter(classDoc);
        }
    }

    protected void printModifiers(MemberDoc memberDoc) {
        String string = this.modifierString(memberDoc);
        if (string.length() > 0) {
            this.print(string);
            this.print(' ');
        }
    }

    protected void printStaticAndType(boolean bl, Type type) {
        this.writer.printTypeSummaryHeader();
        if (bl) {
            this.print("static&nbsp;");
        }
        if (type != null) {
            this.printTypeLink(type);
        }
        this.writer.printTypeSummaryFooter();
    }

    public void printSummaryFooter(ClassDoc classDoc) {
        this.writer.printSummaryFooter(this, classDoc);
    }

    public void printSummaryHeader(ClassDoc classDoc) {
        this.writer.printSummaryHeader(this, classDoc);
    }

    public abstract void printSummaryLabel(ClassDoc var1);

    protected abstract void printSummaryLink(ClassDoc var1, ProgramElementDoc var2);

    public void printSummaryMember(ClassDoc classDoc, ProgramElementDoc programElementDoc) {
        this.writer.printSummaryMember(this, classDoc, programElementDoc);
    }

    protected abstract void printSummaryType(ProgramElementDoc var1);

    protected void printTags(ProgramElementDoc programElementDoc) {
        if (programElementDoc.seeTags().length > 0) {
            this.writer.dd();
            this.writer.dl();
            this.writer.printSeeTags(programElementDoc);
            this.writer.dlEnd();
            this.writer.ddEnd();
        }
    }

    protected void printTypeLink(Type type) {
        this.printTypeLinkNoDimension(type);
        this.print(type.dimension());
    }

    protected void printTypeLinkNoDimension(Type type) {
        ClassDoc classDoc = type.asClassDoc();
        if (classDoc == null) {
            this.print(type.typeName());
        } else {
            this.printClassLink(classDoc);
        }
    }

    protected void printTypedName(Type type, String string) {
        if (type != null) {
            this.printTypeLinkNoDimension(type);
        }
        if (string.length() > 0) {
            this.writer.print(' ');
            this.writer.print(string);
        }
        if (type != null) {
            this.writer.print(type.dimension());
        }
    }
}

