/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.standard;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.ClassTree;
import com.sun.tools.doclets.DirectoryManager;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.standard.ClassSubWriter;
import com.sun.tools.doclets.standard.ConfigurationStandard;
import com.sun.tools.doclets.standard.ConstructorSubWriter;
import com.sun.tools.doclets.standard.FieldSubWriter;
import com.sun.tools.doclets.standard.HtmlStandardWriter;
import com.sun.tools.doclets.standard.MethodSubWriter;
import com.sun.tools.doclets.standard.Standard;
import com.sun.tools.doclets.standard.SubWriterHolderWriter;
import java.io.IOException;
import java.util.List;

public class ClassWriter
extends SubWriterHolderWriter {
    protected ClassDoc classdoc;
    protected ClassTree classtree;
    protected ClassDoc prev;
    protected ClassDoc next;
    protected boolean nopackage;
    protected MethodSubWriter methodSubWriter;
    protected ConstructorSubWriter constrSubWriter;
    protected FieldSubWriter fieldSubWriter;
    protected ClassSubWriter innerSubWriter;

    public ClassWriter(String string, String string2, ClassDoc classDoc, ClassDoc classDoc2, ClassDoc classDoc3, ClassTree classTree, boolean bl) throws IOException, DocletAbortException {
        super(string, string2, DirectoryManager.getRelativePath(classDoc.containingPackage().name()));
        this.classdoc = classDoc;
        HtmlStandardWriter.currentcd = classDoc;
        this.classtree = classTree;
        this.prev = classDoc2;
        this.next = classDoc3;
        this.nopackage = bl;
        this.methodSubWriter = new MethodSubWriter(this);
        this.constrSubWriter = new ConstructorSubWriter(this);
        this.fieldSubWriter = new FieldSubWriter(this);
        this.innerSubWriter = new ClassSubWriter(this);
    }

    public static void generate(ClassDoc classDoc, ClassDoc classDoc2, ClassDoc classDoc3, ClassTree classTree, boolean bl) throws DocletAbortException {
        String string = DirectoryManager.getDirectoryPath(classDoc.containingPackage());
        String string2 = String.valueOf(classDoc.name()) + ".html";
        try {
            ClassWriter classWriter = new ClassWriter(string, string2, classDoc, classDoc2, classDoc3, classTree, bl);
            classWriter.generateClassFile();
            classWriter.close();
        }
        catch (IOException iOException) {
            Standard.configuration();
            ConfigurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string2);
            throw new DocletAbortException();
        }
    }

    public void generateClassFile() {
        String string = String.valueOf(this.getText(this.classdoc.isInterface() ? "doclet.Interface" : "doclet.Class")) + " ";
        PackageDoc packageDoc = this.classdoc.containingPackage();
        String string2 = packageDoc != null ? packageDoc.name() : "";
        String string3 = this.classdoc.name();
        String string4 = String.valueOf(string) + ' ' + string3;
        this.printHeader(this.getText("doclet.Window_ClassFile_label", Standard.configuration().windowtitle, string4));
        this.navLinks(true);
        this.hr();
        this.println("<!-- ======== START OF CLASS DATA ======== -->");
        this.h2();
        if (string2.length() > 0) {
            this.font("-1");
            this.print(string2);
            this.fontEnd();
            this.br();
        }
        this.print(string4);
        this.h2End();
        if (!this.classdoc.isInterface()) {
            this.pre();
            this.printTreeForClass(this.classdoc);
            this.preEnd();
        }
        this.printSubClassInterfaceInfo();
        if (this.classdoc.isInterface()) {
            this.printImplementingClasses();
        }
        this.printEnclosingClassInfo();
        this.hr();
        this.printDeprecated();
        this.printClassDescription();
        this.p();
        if (this.classdoc.inlineTags().length > 0) {
            this.printInlineComment(this.classdoc);
            this.p();
        }
        this.generateTagInfo(this.classdoc);
        this.hr();
        this.p();
        this.printAllMembers();
        this.println("<!-- ========= END OF CLASS DATA ========= -->");
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void navDetailLinks() {
        this.printText("doclet.Detail");
        this.print("&nbsp;");
        this.fieldSubWriter.navDetailLink(this.classdoc);
        this.navGap();
        this.constrSubWriter.navDetailLink(this.classdoc);
        this.navGap();
        this.methodSubWriter.navDetailLink(this.classdoc);
    }

    protected void navGap() {
        this.space();
        this.print('|');
        this.space();
    }

    protected void navLinkClass() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.Class");
        this.fontEnd();
        this.navCellEnd();
    }

    protected void navLinkClassUse() {
        this.navCellStart();
        this.printHyperLink("class-use/" + this.filename, "", this.getText("doclet.navClassUse"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkNext() {
        if (this.next == null) {
            this.printText("doclet.Next_Class");
        } else {
            this.printClassLink(this.next, this.getText("doclet.Next_Class"), true);
        }
    }

    protected void navLinkPackage() {
        this.navCellStart();
        this.printHyperLink("package-summary.html", "", this.getText("doclet.Package"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkPrevious() {
        if (this.prev == null) {
            this.printText("doclet.Prev_Class");
        } else {
            this.printClassLink(this.prev, this.getText("doclet.Prev_Class"), true);
        }
    }

    protected void navLinkTree() {
        this.navCellStart();
        if (this.nopackage) {
            this.printHyperLink(String.valueOf(this.relativepath) + "overview-tree.html", "", this.getText("doclet.Tree"), true, "NavBarFont1");
        } else {
            this.printHyperLink("package-tree.html", "", this.getText("doclet.Tree"), true, "NavBarFont1");
        }
        this.navCellEnd();
    }

    protected void navSummaryLinks() {
        this.printText("doclet.Summary");
        this.print("&nbsp;");
        this.innerSubWriter.navSummaryLink(this.classdoc);
        this.navGap();
        this.fieldSubWriter.navSummaryLink(this.classdoc);
        this.navGap();
        this.constrSubWriter.navSummaryLink(this.classdoc);
        this.navGap();
        this.methodSubWriter.navSummaryLink(this.classdoc);
    }

    protected void printAllMembers() {
        this.println("<!-- ======== INNER CLASS SUMMARY ======== -->");
        this.println();
        this.innerSubWriter.printMembersSummary(this.classdoc);
        this.innerSubWriter.printInheritedMembersSummary(this.classdoc);
        this.println();
        this.println("<!-- =========== FIELD SUMMARY =========== -->");
        this.println();
        this.fieldSubWriter.printMembersSummary(this.classdoc);
        this.fieldSubWriter.printInheritedMembersSummary(this.classdoc);
        this.println();
        this.println("<!-- ======== CONSTRUCTOR SUMMARY ======== -->");
        this.println();
        this.constrSubWriter.printMembersSummary(this.classdoc);
        this.println();
        this.println("<!-- ========== METHOD SUMMARY =========== -->");
        this.println();
        this.methodSubWriter.printMembersSummary(this.classdoc);
        this.methodSubWriter.printInheritedMembersSummary(this.classdoc);
        this.p();
        this.println();
        this.println("<!-- ============ FIELD DETAIL =========== -->");
        this.println();
        this.fieldSubWriter.printMembers(this.classdoc);
        this.println();
        this.println("<!-- ========= CONSTRUCTOR DETAIL ======== -->");
        this.println();
        this.constrSubWriter.printMembers(this.classdoc);
        this.println();
        this.println("<!-- ============ METHOD DETAIL ========== -->");
        this.println();
        this.methodSubWriter.printMembers(this.classdoc);
    }

    protected void printClassDescription() {
        ClassDoc[] classDocArray;
        boolean bl = this.classdoc.isInterface();
        this.dl();
        this.dt();
        this.print(String.valueOf(this.classdoc.modifiers()) + " ");
        if (!bl) {
            this.print("class ");
        }
        this.bold(this.classdoc.name());
        if (!bl && (classDocArray = this.classdoc.superclass()) != null) {
            this.dt();
            this.print("extends ");
            this.printClassLink((ClassDoc)classDocArray);
        }
        if ((classDocArray = this.classdoc.interfaces()) != null && classDocArray.length > 0) {
            this.dt();
            this.print(bl ? "extends " : "implements ");
            this.printClassLink(classDocArray[0]);
            int n = 1;
            while (n < classDocArray.length) {
                this.print(", ");
                this.printClassLink(classDocArray[n]);
                ++n;
            }
        }
        this.dlEnd();
    }

    protected void printDeprecated() {
        Tag[] tagArray = this.classdoc.tags("deprecated");
        if (tagArray.length > 0) {
            Tag[] tagArray2 = tagArray[0].inlineTags();
            if (tagArray2.length > 0) {
                this.boldText("doclet.Deprecated");
                this.space();
                this.printInlineDeprecatedComment(tagArray[0]);
            }
            this.p();
        }
    }

    protected void printEnclosingClassInfo() {
        ClassDoc classDoc = this.classdoc.containingClass();
        if (classDoc != null) {
            this.printInfoHeader();
            this.boldText("doclet.Enclosing_Class");
            this.dd();
            this.printClassLink(classDoc);
            this.ddEnd();
            this.dlEnd();
        }
    }

    protected void printImplementingClasses() {
        if (this.classdoc.qualifiedName().equals("java.lang.Cloneable") || this.classdoc.qualifiedName().equals("java.io.Serializable")) {
            return;
        }
        List list = this.classtree.implementingclasses(this.classdoc);
        if (list.size() > 0) {
            this.printInfoHeader();
            this.boldText("doclet.Implementing_Classes");
            this.printSubClassLinkInfo(list);
        }
    }

    protected void printInfoHeader() {
        this.dl();
        this.dt();
    }

    protected void printStep(int n) {
        String string = this.spaces(6 * n - 4);
        this.print(string);
        this.println("|");
        this.print(string);
        this.print("+--");
    }

    protected void printSubClassInterfaceInfo() {
        List list;
        if (this.classdoc.qualifiedName().equals("java.lang.Object") || this.classdoc.qualifiedName().equals("org.omg.CORBA.Object")) {
            return;
        }
        List list2 = list = this.classdoc.isClass() ? this.classtree.subs(this.classdoc) : this.classtree.allSubs(this.classdoc);
        if (list.size() > 0) {
            this.printInfoHeader();
            if (this.classdoc.isClass()) {
                this.boldText("doclet.Subclasses");
            } else {
                this.boldText("doclet.Subinterfaces");
            }
            this.printSubClassLinkInfo(list);
        }
    }

    protected void printSubClassLinkInfo(List list) {
        int n = 0;
        this.print(' ');
        this.dd();
        while (n < list.size() - 1) {
            this.printClassLink((ClassDoc)list.get(n));
            this.print(", ");
            ++n;
        }
        this.printClassLink((ClassDoc)list.get(n));
        this.ddEnd();
        this.dlEnd();
    }

    protected void printSummaryDetailLinks() {
        this.tr();
        this.tdVAlignClass("top", "NavBarCell3");
        this.font("-2");
        this.print("  ");
        this.navSummaryLinks();
        this.fontEnd();
        this.tdEnd();
        this.tdVAlignClass("top", "NavBarCell3");
        this.font("-2");
        this.navDetailLinks();
        this.fontEnd();
        this.tdEnd();
        this.trEnd();
    }

    protected int printTreeForClass(ClassDoc classDoc) {
        ClassDoc classDoc2 = classDoc.superclass();
        int n = 0;
        if (classDoc2 != null) {
            n = this.printTreeForClass(classDoc2);
            this.printStep(n);
        }
        if (classDoc.equals(this.classdoc)) {
            this.bold(classDoc.qualifiedName());
        } else {
            this.printQualifiedClassLink(classDoc);
        }
        this.println();
        return n + 1;
    }
}

