/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.standard;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.standard.ExecutableMemberSubWriter;
import com.sun.tools.doclets.standard.Group;
import com.sun.tools.doclets.standard.SubWriterHolderWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MethodSubWriter
extends ExecutableMemberSubWriter {
    protected MethodSubWriter(SubWriterHolderWriter subWriterHolderWriter) {
        super(subWriterHolderWriter);
    }

    protected void composeInheritedMethodMap(ClassDoc classDoc, List list, Map map, List list2) {
        MethodDoc[] methodDocArray = classDoc.methods();
        ArrayList<MethodDoc> arrayList = new ArrayList<MethodDoc>();
        int n = 0;
        while (n < methodDocArray.length) {
            if (!this.contains(list, methodDocArray[n])) {
                arrayList.add(methodDocArray[n]);
                list.add(methodDocArray[n]);
            }
            ++n;
        }
        map.put(classDoc, arrayList);
        list2.add(classDoc);
    }

    protected boolean contains(List list, MethodDoc methodDoc) {
        int n = 0;
        while (n < list.size()) {
            MethodDoc methodDoc2 = (MethodDoc)list.get(n);
            if (methodDoc2.name().equals(methodDoc.name()) && methodDoc2.signature().equals(methodDoc.signature())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected Map getInheritedMethodMapForClass(ClassDoc classDoc, List list, Map map, List list2) {
        ClassDoc classDoc2 = classDoc.superclass();
        while (classDoc2 != null) {
            this.composeInheritedMethodMap(classDoc2, list, map, list2);
            classDoc2 = classDoc2.superclass();
        }
        return map;
    }

    protected Map getInheritedMethodMapForInterface(ClassDoc classDoc, List list, Map map, List list2) {
        ClassDoc[] classDocArray = classDoc.interfaces();
        int n = 0;
        while (n < classDocArray.length) {
            this.composeInheritedMethodMap(classDocArray[n], list, map, list2);
            ++n;
        }
        int n2 = 0;
        while (n2 < classDocArray.length) {
            this.getInheritedMethodMapForInterface(classDocArray[n2], list, map, list2);
            ++n2;
        }
        return map;
    }

    protected MethodDoc implementedMethod(MethodDoc methodDoc, ClassDoc[] classDocArray) {
        int n = 0;
        while (n < classDocArray.length) {
            MethodDoc methodDoc2 = this.findMethod(classDocArray[n], methodDoc);
            if (methodDoc2 != null) {
                return methodDoc2;
            }
            ++n;
        }
        return null;
    }

    public ProgramElementDoc[] members(ClassDoc classDoc) {
        return this.eligibleMembers(classDoc.methods());
    }

    protected void printComment(ProgramElementDoc programElementDoc) {
        if (programElementDoc.inlineTags().length > 0) {
            this.writer.dd();
            this.writer.printInlineComment(programElementDoc);
        } else {
            MethodDoc methodDoc = new CommentedMethodFinder().search(programElementDoc.containingClass(), (MethodDoc)programElementDoc);
            this.printCommentFromCommentedMethod(methodDoc);
        }
    }

    protected void printCommentFromCommentedMethod(MethodDoc methodDoc) {
        if (methodDoc == null) {
            return;
        }
        ClassDoc classDoc = methodDoc.containingClass();
        String string = this.writer.getClassLink(classDoc);
        this.writer.dd();
        this.writer.boldText(classDoc.isClass() ? "doclet.Description_From_Class" : "doclet.Description_From_Interface", string);
        this.writer.ddEnd();
        this.writer.dd();
        this.writer.printInlineComment(methodDoc);
    }

    protected void printHeader(ClassDoc classDoc) {
        this.writer.anchor("method_detail");
        this.writer.printTableHeadingBackground(this.writer.getText("doclet.Method_Detail"));
    }

    protected void printImplementsInfo(MethodDoc methodDoc) {
        MethodDoc methodDoc2;
        ClassDoc[] classDocArray = methodDoc.containingClass().interfaces();
        if (classDocArray.length > 0 && (methodDoc2 = this.implementedMethod(methodDoc, classDocArray)) != null) {
            ClassDoc classDoc = methodDoc2.containingClass();
            String string = "";
            String string2 = this.writer.getClassLink(classDoc);
            this.writer.dt();
            this.writer.boldText("doclet.Specified_By");
            this.writer.dd();
            string = this.writer.getDocLink(methodDoc2, methodDoc2.name());
            this.writer.printText("doclet.in_interface", string, string2);
        }
    }

    protected void printInheritedMembersInfo(ClassDoc classDoc, List list) {
        if (list.size() > 0) {
            Collections.sort(list);
            this.printInheritedSummaryHeader(classDoc);
            this.printInheritedSummaryMember(classDoc, (ProgramElementDoc)list.get(0));
            int n = 1;
            while (n < list.size()) {
                this.writer.println(", ");
                this.printInheritedSummaryMember(classDoc, (ProgramElementDoc)list.get(n));
                ++n;
            }
            this.printInheritedSummaryFooter(classDoc);
        }
    }

    public void printInheritedMembersSummary(ClassDoc classDoc) {
        List list = Group.asList(classDoc.methods());
        Map map = new HashMap();
        ArrayList arrayList = new ArrayList();
        map = classDoc.isClass() ? this.getInheritedMethodMapForClass(classDoc, list, map, arrayList) : this.getInheritedMethodMapForInterface(classDoc, list, map, arrayList);
        if (arrayList.size() > 0) {
            int n = 0;
            while (n < arrayList.size()) {
                ClassDoc classDoc2 = (ClassDoc)arrayList.get(n);
                List list2 = (List)map.get(classDoc2);
                this.printInheritedMembersInfo(classDoc2, list2);
                ++n;
            }
        }
    }

    public void printInheritedSummaryAnchor(ClassDoc classDoc) {
        this.writer.anchor("methods_inherited_from_class_" + classDoc.qualifiedName());
    }

    public void printInheritedSummaryLabel(ClassDoc classDoc) {
        String string = this.writer.getPreQualifiedClassLink(classDoc);
        this.writer.bold();
        this.writer.printText(classDoc.isClass() ? "doclet.Methods_Inherited_From_Class" : "doclet.Methods_Inherited_From_Interface", string);
        this.writer.boldEnd();
    }

    public void printMembersSummary(ClassDoc classDoc) {
        Object[] objectArray = this.members(classDoc);
        if (objectArray.length > 0) {
            Arrays.sort(objectArray);
            this.printSummaryHeader(classDoc);
            int n = 0;
            while (n < objectArray.length) {
                MethodDoc methodDoc = (MethodDoc)objectArray[n];
                boolean bl = false;
                String string = "";
                Tag[] tagArray = methodDoc.inlineTags();
                if (tagArray.length == 0) {
                    string = methodDoc.getRawCommentText();
                    MethodDoc methodDoc2 = new CommentedMethodFinder().search(classDoc, methodDoc);
                    if (methodDoc2 != null) {
                        methodDoc.setRawCommentText(methodDoc2.commentText());
                        bl = true;
                    }
                }
                this.printSummaryMember(classDoc, methodDoc);
                if (bl) {
                    methodDoc.setRawCommentText(string);
                }
                ++n;
            }
            this.printSummaryFooter(classDoc);
        }
    }

    protected void printNavDetailLink(boolean bl) {
        if (bl) {
            this.writer.printHyperLink("", "method_detail", this.writer.getText("doclet.navMethod"));
        } else {
            this.writer.printText("doclet.navMethod");
        }
    }

    protected void printNavSummaryLink(ClassDoc classDoc, boolean bl) {
        if (bl) {
            this.writer.printHyperLink("", classDoc == null ? "method_summary" : "methods_inherited_from_class_" + classDoc.qualifiedName(), this.writer.getText("doclet.navMethod"));
        } else {
            this.writer.printText("doclet.navMethod");
        }
    }

    protected void printOverridden(ClassDoc classDoc, MethodDoc methodDoc) {
        if (classDoc != null) {
            String string = this.writer.getClassLink(classDoc);
            String string2 = "";
            String string3 = methodDoc.name();
            this.writer.dt();
            this.writer.boldText("doclet.Overrides");
            this.writer.dd();
            string2 = this.writer.getClassLink(classDoc, String.valueOf(string3) + methodDoc.signature(), string3, false);
            this.writer.printText("doclet.in_class", string2, string);
        }
    }

    protected void printReturnTag(Tag[] tagArray) {
        if (tagArray.length > 0) {
            this.writer.dt();
            this.writer.boldText("doclet.Returns");
            this.writer.dd();
            this.writer.printInlineComment(tagArray[0]);
        }
    }

    protected void printReturnType(MethodDoc methodDoc) {
        Type type = methodDoc.returnType();
        if (type != null) {
            this.printTypeLink(type);
            this.print(' ');
        }
    }

    protected void printSignature(ExecutableMemberDoc executableMemberDoc) {
        this.writer.displayLength = 0;
        this.writer.pre();
        this.printModifiers(executableMemberDoc);
        this.printReturnType((MethodDoc)executableMemberDoc);
        this.bold(executableMemberDoc.name());
        this.printParameters(executableMemberDoc);
        this.printExceptions(executableMemberDoc);
        this.writer.preEnd();
    }

    public void printSummaryAnchor(ClassDoc classDoc) {
        this.writer.anchor("method_summary");
    }

    public void printSummaryLabel(ClassDoc classDoc) {
        this.writer.boldText("doclet.Method_Summary");
    }

    protected void printSummaryType(ProgramElementDoc programElementDoc) {
        MethodDoc methodDoc = (MethodDoc)programElementDoc;
        this.printModifierAndType(methodDoc, methodDoc.returnType());
    }

    protected void printTags(ProgramElementDoc programElementDoc) {
        MethodDoc methodDoc = (MethodDoc)programElementDoc;
        ParamTag[] paramTagArray = methodDoc.paramTags();
        Tag[] tagArray = methodDoc.tags("return");
        Tag[] tagArray2 = methodDoc.tags("since");
        ThrowsTag[] throwsTagArray = methodDoc.throwsTags();
        SeeTag[] seeTagArray = methodDoc.seeTags();
        ClassDoc[] classDocArray = programElementDoc.containingClass().interfaces();
        ClassDoc classDoc = methodDoc.overriddenClass();
        if (classDocArray.length > 0 || classDoc != null) {
            this.printTagsInfoHeader();
            this.printImplementsInfo(methodDoc);
            this.printOverridden(classDoc, methodDoc);
            this.printTagsInfoFooter();
        }
        if (paramTagArray.length + tagArray.length + throwsTagArray.length + tagArray2.length + seeTagArray.length > 0) {
            this.printTagsInfoHeader();
            this.printParamTags(paramTagArray);
            this.printReturnTag(tagArray);
            this.printThrowsTags(throwsTagArray);
            this.writer.printSinceTag(methodDoc);
            this.writer.printSeeTags(methodDoc);
            this.printTagsInfoFooter();
        } else {
            MethodDoc methodDoc2 = new TaggedMethodFinder().search(methodDoc.containingClass(), methodDoc);
            if (methodDoc2 != null) {
                this.printTagsFromTaggedMethod(methodDoc2);
            }
        }
    }

    protected void printTagsFromTaggedMethod(MethodDoc methodDoc) {
        ParamTag[] paramTagArray = methodDoc.paramTags();
        Tag[] tagArray = methodDoc.tags("return");
        ThrowsTag[] throwsTagArray = methodDoc.throwsTags();
        SeeTag[] seeTagArray = methodDoc.seeTags();
        ClassDoc classDoc = methodDoc.containingClass();
        String string = this.writer.getClassLink(classDoc);
        this.writer.dd();
        this.writer.boldText(classDoc.isClass() ? "doclet.Tags_From_Class" : "doclet.Tags_From_Interface", string);
        this.writer.ddEnd();
        this.printTagsInfoHeader();
        this.printParamTags(paramTagArray);
        this.printReturnTag(tagArray);
        this.printThrowsTags(throwsTagArray);
        this.writer.printSeeTags(methodDoc);
        this.printTagsInfoFooter();
    }

    protected void printTagsInfoFooter() {
        this.writer.dlEnd();
        this.writer.ddEnd();
    }

    protected void printTagsInfoHeader() {
        this.writer.dd();
        this.writer.dl();
    }

    abstract class MethodFinder {
        MethodFinder() {
        }

        abstract boolean isCorrectMethod(MethodDoc var1);

        MethodDoc search(ClassDoc classDoc, MethodDoc methodDoc) {
            MethodDoc methodDoc2 = this.searchInterfaces(classDoc, methodDoc);
            if (methodDoc2 != null) {
                return methodDoc2;
            }
            ClassDoc classDoc2 = classDoc.superclass();
            if (classDoc2 != null) {
                methodDoc2 = MethodSubWriter.this.findMethod(classDoc2, methodDoc);
                if (methodDoc2 != null && this.isCorrectMethod(methodDoc2)) {
                    return methodDoc2;
                }
                return this.search(classDoc2, methodDoc);
            }
            return null;
        }

        MethodDoc searchInterfaces(ClassDoc classDoc, MethodDoc methodDoc) {
            ClassDoc[] classDocArray = classDoc.interfaces();
            int n = 0;
            while (n < classDocArray.length) {
                MethodDoc methodDoc2 = MethodSubWriter.this.findMethod(classDocArray[n], methodDoc);
                if (methodDoc2 != null && this.isCorrectMethod(methodDoc2)) {
                    return methodDoc2;
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < classDocArray.length) {
                MethodDoc methodDoc3 = this.searchInterfaces(classDocArray[n2], methodDoc);
                if (methodDoc3 != null) {
                    return methodDoc3;
                }
                ++n2;
            }
            return null;
        }
    }

    class TaggedMethodFinder
    extends MethodFinder {
        TaggedMethodFinder() {
        }

        boolean isCorrectMethod(MethodDoc methodDoc) {
            return methodDoc.paramTags().length + methodDoc.tags("return").length + methodDoc.throwsTags().length + methodDoc.seeTags().length > 0;
        }
    }

    class CommentedMethodFinder
    extends MethodFinder {
        CommentedMethodFinder() {
        }

        boolean isCorrectMethod(MethodDoc methodDoc) {
            return methodDoc.inlineTags().length > 0;
        }
    }
}

