/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.SerialFieldTag;
import com.sun.javadoc.Tag;
import com.sun.tools.javadoc.ClassDocImpl;
import com.sun.tools.javadoc.Env;
import com.sun.tools.javadoc.FieldDocImpl;
import com.sun.tools.javadoc.MethodDocImpl;
import com.sun.tools.javadoc.SerialFieldTagImpl;
import java.util.ArrayList;
import java.util.List;
import sun.tools.java.ClassDefinition;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;

class SerializedForm {
    private final List methods = new ArrayList();
    private final List fields = new ArrayList();
    private boolean definesSerializableFields = false;
    private static final String SERIALIZABLE_FIELDS = "serialPersistentFields";
    private static final String READOBJECT = "readObject";
    private static final String WRITEOBJECT = "writeObject";

    SerializedForm(Env env, ClassDefinition classDefinition, ClassDocImpl classDocImpl) {
        if (classDocImpl.isExternalizable()) {
            String[] stringArray = new String[]{"java.io.ObjectInput"};
            String[] stringArray2 = new String[]{"java.io.ObjectOutput"};
            MethodDoc methodDoc = classDocImpl.findMethod("readExternal", stringArray);
            if (methodDoc != null) {
                this.methods.add(methodDoc);
            }
            if ((methodDoc = classDocImpl.findMethod("writeExternal", stringArray2)) != null) {
                this.methods.add(methodDoc);
                Tag[] tagArray = methodDoc.tags("serialData");
            }
        } else {
            MemberDefinition memberDefinition = this.getDefinedSerializableFields(classDefinition);
            if (memberDefinition != null) {
                this.definesSerializableFields = true;
                FieldDocImpl fieldDocImpl = FieldDocImpl.getFieldDocImpl(env, memberDefinition);
                this.fields.add(fieldDocImpl);
                this.mapSerialFieldTagImplsToFieldDocImpls(fieldDocImpl, env, classDefinition);
            } else {
                this.computeDefaultSerializableFields(env, classDefinition, classDocImpl);
            }
            this.addMethodIfExist(env, classDefinition, READOBJECT);
            this.addMethodIfExist(env, classDefinition, WRITEOBJECT);
        }
    }

    private void addMethodIfExist(Env env, ClassDefinition classDefinition, String string) {
        MemberDefinition memberDefinition = null;
        memberDefinition = classDefinition.getFirstMatch(Identifier.lookup(string));
        while (memberDefinition != null) {
            if (memberDefinition.isMethod() && memberDefinition.isPrivate() && !memberDefinition.isStatic()) break;
            memberDefinition = memberDefinition.getNextMember();
        }
        if (memberDefinition != null) {
            this.methods.add(MethodDocImpl.getMethodDocImpl(env, memberDefinition));
        }
    }

    private void computeDefaultSerializableFields(Env env, ClassDefinition classDefinition, ClassDocImpl classDocImpl) {
        MemberDefinition memberDefinition = classDefinition.getFirstMember();
        while (memberDefinition != null) {
            if (memberDefinition.isVariable() && !memberDefinition.isTransient() && !memberDefinition.isStatic()) {
                FieldDocImpl fieldDocImpl = FieldDocImpl.getFieldDocImpl(env, memberDefinition);
                this.fields.add(fieldDocImpl);
            }
            memberDefinition = memberDefinition.getNextMember();
        }
    }

    boolean definesSerializableFields() {
        return this.definesSerializableFields;
    }

    FieldDoc[] fields() {
        return this.fields.toArray(new FieldDoc[this.fields.size()]);
    }

    private MemberDefinition getDefinedSerializableFields(ClassDefinition classDefinition) {
        MemberDefinition memberDefinition = classDefinition.getFirstMatch(Identifier.lookup(SERIALIZABLE_FIELDS));
        while (memberDefinition != null) {
            if (memberDefinition != null && memberDefinition.isStatic() && memberDefinition.isVariable() && memberDefinition.isPrivate()) break;
            memberDefinition = memberDefinition.getNextMember();
        }
        return memberDefinition;
    }

    private void mapSerialFieldTagImplsToFieldDocImpls(FieldDocImpl fieldDocImpl, Env env, ClassDefinition classDefinition) {
        SerialFieldTag[] serialFieldTagArray = fieldDocImpl.serialFieldTags();
        int n = 0;
        while (n < serialFieldTagArray.length) {
            Identifier identifier = Identifier.lookup(serialFieldTagArray[n].fieldName());
            MemberDefinition memberDefinition = classDefinition.getFirstMatch(identifier);
            while (memberDefinition != null) {
                if (memberDefinition.isVariable()) {
                    ((SerialFieldTagImpl)serialFieldTagArray[n]).mapToFieldDocImpl(FieldDocImpl.getFieldDocImpl(env, memberDefinition));
                    break;
                }
                memberDefinition = memberDefinition.getNextMember();
            }
            ++n;
        }
    }

    MethodDoc[] methods() {
        return this.methods.toArray(new MethodDoc[this.methods.size()]);
    }
}

