/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import sun.rmi.rmic.BatchEnvironment;
import sun.rmi.rmic.Constants;
import sun.rmi.rmic.Generator;
import sun.rmi.rmic.Names;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Identifier;
import sun.tools.javac.SourceClass;
import sun.tools.util.CommandLine;

public class Main
implements Constants {
    String sourcePathArg;
    String classPathArg;
    String sysClassPathArg;
    String extDirsArg;
    File destDir;
    int flags;
    long tm;
    Vector v;
    boolean nowrite;
    String props;
    boolean keepGenerated;
    int stubVersion;
    String program;
    OutputStream out;
    private static boolean resourcesInitialized = false;
    private static ResourceBundle resources;

    public Main(OutputStream outputStream, String string) {
        this.out = outputStream;
        this.program = string;
    }

    public synchronized boolean compile(String[] stringArray) {
        if (!this.parseArgs(stringArray)) {
            return false;
        }
        if (this.v.size() == 0) {
            this.usage();
            return false;
        }
        return this.doCompile();
    }

    public boolean doCompile() {
        Object object;
        BatchEnvironment batchEnvironment;
        block37: {
            batchEnvironment = BatchEnvironment.create(this.out, this.sourcePathArg, this.classPathArg, this.sysClassPathArg, this.extDirsArg);
            batchEnvironment.flags |= this.flags;
            switch (this.stubVersion) {
                case 1: 
                case 2: {
                    batchEnvironment.majorVersion = (short)45;
                    batchEnvironment.minorVersion = (short)3;
                    break;
                }
                default: {
                    batchEnvironment.majorVersion = (short)45;
                    batchEnvironment.minorVersion = (short)3;
                }
            }
            String string = Main.getText("rmic.no.memory");
            String string2 = Main.getText("rmic.stack.overflow");
            try {
                boolean bl;
                Object object2;
                int n = this.v.size() - 1;
                while (n >= 0) {
                    object = Identifier.lookup((String)this.v.elementAt(n));
                    object = batchEnvironment.resolvePackageQualifiedName((Identifier)object);
                    object = Names.mangleClass((Identifier)object);
                    ClassDeclaration classDeclaration = batchEnvironment.getClassDeclaration((Identifier)object);
                    try {
                        object2 = classDeclaration.getClassDefinition(batchEnvironment);
                        Generator.generate(batchEnvironment, (ClassDefinition)object2, this.destDir, this.stubVersion);
                    }
                    catch (ClassNotFound classNotFound) {
                        batchEnvironment.error(0L, "rmic.class.not.found", object);
                    }
                    --n;
                }
                object = new ByteArrayOutputStream(4096);
                do {
                    bl = true;
                    batchEnvironment.flushErrors();
                    object2 = batchEnvironment.getClasses();
                    block20: while (object2.hasMoreElements()) {
                        ClassDeclaration classDeclaration = (ClassDeclaration)object2.nextElement();
                        switch (classDeclaration.getStatus()) {
                            case 0: {
                                if (!batchEnvironment.dependencies()) continue block20;
                            }
                            case 3: {
                                bl = false;
                                batchEnvironment.loadDefinition(classDeclaration);
                                if (classDeclaration.getStatus() != 4) continue block20;
                            }
                            case 4: {
                                if (classDeclaration.getClassDefinition().isInsideLocal()) break;
                                bl = false;
                                SourceClass sourceClass = (SourceClass)classDeclaration.getClassDefinition(batchEnvironment);
                                sourceClass.check(batchEnvironment);
                                classDeclaration.setDefinition(sourceClass, 5);
                            }
                            case 5: {
                                Object object3;
                                File file;
                                SourceClass sourceClass = (SourceClass)classDeclaration.getClassDefinition(batchEnvironment);
                                if (sourceClass.getError()) {
                                    classDeclaration.setDefinition(sourceClass, 6);
                                    break;
                                }
                                bl = false;
                                ((ByteArrayOutputStream)object).reset();
                                sourceClass.compile((OutputStream)object);
                                classDeclaration.setDefinition(sourceClass, 6);
                                sourceClass.cleanup(batchEnvironment);
                                if (sourceClass.getError() || this.nowrite) continue block20;
                                String string3 = classDeclaration.getName().getQualifier().toString().replace('.', File.separatorChar);
                                String string4 = String.valueOf(classDeclaration.getName().getFlatName().toString().replace('.', '$')) + ".class";
                                if (this.destDir != null) {
                                    if (string3.length() > 0) {
                                        file = new File(this.destDir, string3);
                                        if (!file.exists()) {
                                            file.mkdirs();
                                        }
                                        file = new File(file, string4);
                                    } else {
                                        file = new File(this.destDir, string4);
                                    }
                                } else {
                                    object3 = (ClassFile)sourceClass.getSource();
                                    if (((ClassFile)object3).isZipped()) {
                                        batchEnvironment.error(0L, "cant.write", ((ClassFile)object3).getPath());
                                        break;
                                    }
                                    file = new File(((ClassFile)object3).getPath());
                                    file = new File(file.getParent(), string4);
                                }
                                try {
                                    object3 = new FileOutputStream(file.getPath());
                                    ((ByteArrayOutputStream)object).writeTo((OutputStream)object3);
                                    ((FileOutputStream)object3).close();
                                    if (!batchEnvironment.verbose()) break;
                                    this.output(Main.getText("rmic.wrote", file.getPath()));
                                }
                                catch (IOException iOException) {
                                    batchEnvironment.error(0L, "cant.write", file.getPath());
                                }
                                continue block20;
                            }
                        }
                    }
                } while (!bl);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                batchEnvironment.output(string);
                return false;
            }
            catch (StackOverflowError stackOverflowError) {
                batchEnvironment.output(string2);
                return false;
            }
            catch (Error error) {
                if (batchEnvironment.nerrors == 0 || batchEnvironment.dump()) {
                    error.printStackTrace();
                    batchEnvironment.error(0L, "fatal.error");
                }
            }
            catch (Exception exception) {
                if (batchEnvironment.nerrors != 0 && !batchEnvironment.dump()) break block37;
                exception.printStackTrace();
                batchEnvironment.error(0L, "fatal.exception");
            }
        }
        batchEnvironment.flushErrors();
        batchEnvironment.shutdown();
        boolean bl = true;
        if (batchEnvironment.nerrors > 0) {
            object = "";
            object = batchEnvironment.nerrors > 1 ? Main.getText("rmic.errors", batchEnvironment.nerrors) : Main.getText("rmic.1error");
            if (batchEnvironment.nwarnings > 0) {
                object = batchEnvironment.nwarnings > 1 ? String.valueOf(object) + ", " + Main.getText("rmic.warnings", batchEnvironment.nwarnings) : String.valueOf(object) + ", " + Main.getText("rmic.1warning");
            }
            this.output((String)object);
            bl = false;
        } else if (batchEnvironment.nwarnings > 0) {
            if (batchEnvironment.nwarnings > 1) {
                this.output(Main.getText("rmic.warnings", batchEnvironment.nwarnings));
            } else {
                this.output(Main.getText("rmic.1warning"));
            }
        }
        if (!this.keepGenerated) {
            batchEnvironment.deleteGeneratedFiles();
        }
        if (batchEnvironment.verbose()) {
            this.tm = System.currentTimeMillis() - this.tm;
            this.output(Main.getText("rmic.done_in", Long.toString(this.tm)));
        }
        return bl;
    }

    private void error(String string) {
        this.output(Main.getText(string));
    }

    private void error(String string, String string2) {
        this.output(Main.getText(string, string2));
    }

    private void error(String string, String string2, String string3) {
        this.output(Main.getText(string, string2, string3));
    }

    public static String getString(String string) {
        if (!resourcesInitialized) {
            Main.initResources();
        }
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static String getText(String string) {
        String string2 = Main.getString(string);
        if (string2 == null) {
            string2 = "no text found: \"" + string + "\"";
        }
        return string2;
    }

    public static String getText(String string, int n) {
        return Main.getText(string, Integer.toString(n), null, null);
    }

    public static String getText(String string, String string2) {
        return Main.getText(string, string2, null, null);
    }

    public static String getText(String string, String string2, String string3) {
        return Main.getText(string, string2, string3, null);
    }

    public static String getText(String string, String string2, String string3, String string4) {
        String string5 = Main.getString(string);
        if (string5 == null) {
            string5 = "no text found: key = \"" + string + "\", " + "arguments = \"{0}\", \"{1}\", \"{2}\"";
        }
        Object[] objectArray = new String[]{string2 != null ? string2.toString() : "null", string3 != null ? string3.toString() : "null", string4 != null ? string4.toString() : "null"};
        return MessageFormat.format(string5, objectArray);
    }

    private static void initResources() {
        try {
            resources = ResourceBundle.getBundle("sun.rmi.rmic.resources.rmic");
            resourcesInitialized = true;
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("fatal: missing resource bundle: " + missingResourceException.getClassName());
        }
    }

    public static void main(String[] stringArray) {
        Main main = new Main(System.out, "rmic");
        System.exit(main.compile(stringArray) ? 0 : 1);
    }

    public void output(String string) {
        PrintStream printStream = this.out instanceof PrintStream ? (PrintStream)this.out : new PrintStream(this.out, true);
        printStream.println(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean parseArgs(String[] stringArray) {
        this.sourcePathArg = null;
        this.classPathArg = null;
        this.sysClassPathArg = null;
        this.extDirsArg = null;
        this.destDir = null;
        this.flags = 4;
        this.tm = System.currentTimeMillis();
        this.v = new Vector();
        this.nowrite = false;
        this.props = null;
        this.keepGenerated = false;
        this.stubVersion = 2;
        try {
            stringArray = CommandLine.parse(stringArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.error("rmic.cant.read", fileNotFoundException.getMessage());
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-g")) {
                this.flags &= 0xFFFFBFFF;
                this.flags |= 0x3000;
            } else if (stringArray[n].equals("-O")) {
                this.flags &= 0xFFFFEFFF;
                this.flags &= 0xFFFFDFFF;
                this.flags |= 0x4020;
            } else if (stringArray[n].equals("-nowarn")) {
                this.flags &= 0xFFFFFFFB;
            } else if (stringArray[n].equals("-debug")) {
                this.flags |= 2;
            } else if (stringArray[n].equals("-depend")) {
                this.flags |= 0x20;
            } else if (stringArray[n].equals("-verbose")) {
                this.flags |= 1;
            } else if (stringArray[n].equals("-nowrite")) {
                this.nowrite = true;
            } else if (stringArray[n].equals("-keep") || stringArray[n].equals("-keepgenerated")) {
                this.keepGenerated = true;
            } else {
                if (stringArray[n].equals("-show")) {
                    this.error("rmic.option.unsupported", "-show");
                    this.usage();
                    return false;
                }
                if (stringArray[n].equals("-classpath")) {
                    if (n + 1 >= stringArray.length) {
                        this.error("rmic.option.requires.argument", "-classpath");
                        this.usage();
                        return false;
                    }
                    if (this.classPathArg != null) {
                        this.error("rmic.option.already.seen", "-classpath");
                        this.usage();
                        return false;
                    }
                    this.classPathArg = stringArray[++n];
                } else if (stringArray[n].equals("-sourcepath")) {
                    if (n + 1 >= stringArray.length) {
                        this.error("rmic.option.requires.argument", "-sourcepath");
                        this.usage();
                        return false;
                    }
                    if (this.sourcePathArg != null) {
                        this.error("rmic.option.already.seen", "-sourcepath");
                        this.usage();
                        return false;
                    }
                    this.sourcePathArg = stringArray[++n];
                } else if (stringArray[n].equals("-bootclasspath")) {
                    if (n + 1 >= stringArray.length) {
                        this.error("rmic.option.requires.argument", "-bootclasspath");
                        this.usage();
                        return false;
                    }
                    if (this.sysClassPathArg != null) {
                        this.error("rmic.option.already.seen", "-bootclasspath");
                        this.usage();
                        return false;
                    }
                    this.sysClassPathArg = stringArray[++n];
                } else if (stringArray[n].equals("-extdirs")) {
                    if (n + 1 >= stringArray.length) {
                        this.error("rmic.option.requires.argument", "-extdirs");
                        this.usage();
                        return false;
                    }
                    if (this.extDirsArg != null) {
                        this.error("rmic.option.already.seen", "-extdirs");
                        this.usage();
                        return false;
                    }
                    this.extDirsArg = stringArray[++n];
                } else if (stringArray[n].equals("-d")) {
                    if (n + 1 >= stringArray.length) {
                        this.error("rmic.option.requires.argument", "-d");
                        this.usage();
                        return false;
                    }
                    if (this.destDir != null) {
                        this.error("rmic.option.already.seen", "-d");
                        this.usage();
                        return false;
                    }
                    this.destDir = new File(stringArray[++n]);
                    if (!this.destDir.exists()) {
                        this.error("rmic.no.such.directory", this.destDir.getPath());
                        this.usage();
                        return false;
                    }
                } else if (stringArray[n].equals("-v1.1")) {
                    this.stubVersion = 1;
                } else if (stringArray[n].equals("-vcompat")) {
                    this.stubVersion = 2;
                } else if (stringArray[n].equals("-v1.2")) {
                    this.stubVersion = 3;
                } else {
                    if (stringArray[n].startsWith("-")) {
                        this.error("rmic.no.such.option", stringArray[n]);
                        this.usage();
                        return false;
                    }
                    this.v.addElement(stringArray[n]);
                }
            }
            ++n;
        }
        return true;
    }

    public void usage() {
        this.error("rmic.usage", this.program);
    }
}

