/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.asm;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import sun.tools.asm.ArrayData;
import sun.tools.asm.CatchData;
import sun.tools.asm.ConstantPool;
import sun.tools.asm.Label;
import sun.tools.asm.LocalVariable;
import sun.tools.asm.SwitchData;
import sun.tools.asm.TryData;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.MemberDefinition;
import sun.tools.java.RuntimeConstants;

public class Instruction
implements Constants {
    long where;
    int pc;
    int opc;
    Object value;
    Instruction next;
    boolean flagCondInverted;
    boolean flagNoCovered = false;
    public static final double SWITCHRATIO;

    static {
        double d = 1.5;
        String string = System.getProperty("javac.switchratio");
        if (string != null) {
            try {
                double d2 = Double.valueOf(string);
                if (!Double.isNaN(d2) && !(d2 < 0.0)) {
                    d = d2;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        SWITCHRATIO = d;
    }

    public Instruction(long l, int n, Object object) {
        this.where = l;
        this.opc = n;
        this.value = object;
    }

    public Instruction(long l, int n, Object object, boolean bl) {
        this.where = l;
        this.opc = n;
        this.value = object;
        this.flagCondInverted = bl;
    }

    public Instruction(long l, int n, boolean bl) {
        this.where = l;
        this.opc = n;
        this.flagNoCovered = bl;
    }

    public Instruction(boolean bl, long l, int n, Object object) {
        this.where = l;
        this.opc = n;
        this.value = object;
        this.flagNoCovered = bl;
    }

    int balance() {
        switch (this.opc) {
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 47: 
            case 49: 
            case 95: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 132: 
            case 134: 
            case 138: 
            case 139: 
            case 143: 
            case 145: 
            case 146: 
            case 147: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 188: 
            case 189: 
            case 190: 
            case 192: 
            case 193: 
            case 200: 
            case 201: {
                return 0;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 89: 
            case 90: 
            case 91: 
            case 133: 
            case 135: 
            case 140: 
            case 141: 
            case 187: {
                return 1;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 24: 
            case 92: 
            case 93: 
            case 94: {
                return 2;
            }
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 87: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 114: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 130: 
            case 136: 
            case 137: 
            case 142: 
            case 144: 
            case 149: 
            case 150: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 174: 
            case 176: 
            case 191: 
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                return -1;
            }
            case 55: 
            case 57: 
            case 88: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 127: 
            case 129: 
            case 131: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 173: 
            case 175: {
                return -2;
            }
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 148: 
            case 151: 
            case 152: {
                return -3;
            }
            case 80: 
            case 82: {
                return -4;
            }
            case 197: {
                return 1 - ((ArrayData)this.value).nargs;
            }
            case 180: {
                return ((MemberDefinition)this.value).getType().stackSize() - 1;
            }
            case 181: {
                return -1 - ((MemberDefinition)this.value).getType().stackSize();
            }
            case 178: {
                return ((MemberDefinition)this.value).getType().stackSize();
            }
            case 179: {
                return -((MemberDefinition)this.value).getType().stackSize();
            }
            case 182: 
            case 183: 
            case 185: {
                return ((MemberDefinition)this.value).getType().getReturnType().stackSize() - (((MemberDefinition)this.value).getType().stackSize() + 1);
            }
            case 184: {
                return ((MemberDefinition)this.value).getType().getReturnType().stackSize() - ((MemberDefinition)this.value).getType().stackSize();
            }
        }
        throw new CompilerError("invalid opcode: " + this.toString());
    }

    void collect(ConstantPool constantPool) {
        switch (this.opc) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                if (this.value instanceof LocalVariable) {
                    MemberDefinition memberDefinition = ((LocalVariable)this.value).field;
                    constantPool.put(memberDefinition.getName().toString());
                    constantPool.put(memberDefinition.getType().getTypeSignature());
                }
                return;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 187: 
            case 192: 
            case 193: {
                constantPool.put(this.value);
                return;
            }
            case 189: {
                constantPool.put(this.value);
                return;
            }
            case 197: {
                constantPool.put(((ArrayData)this.value).type);
                return;
            }
            case 18: 
            case 19: {
                if (this.value instanceof Integer) {
                    int n = (Integer)this.value;
                    if (n >= -1 && n <= 5) {
                        this.opc = 3 + n;
                        return;
                    }
                    if (n >= -128 && n < 128) {
                        this.opc = 16;
                        return;
                    }
                    if (n >= Short.MIN_VALUE && n < 32768) {
                        this.opc = 17;
                        return;
                    }
                } else if (this.value instanceof Float) {
                    float f = ((Float)this.value).floatValue();
                    if (f == 0.0f) {
                        if (Float.floatToIntBits(f) == 0) {
                            this.opc = 11;
                            return;
                        }
                    } else {
                        if (f == 1.0f) {
                            this.opc = 12;
                            return;
                        }
                        if (f == 2.0f) {
                            this.opc = 13;
                            return;
                        }
                    }
                }
                constantPool.put(this.value);
                return;
            }
            case 20: {
                if (this.value instanceof Long) {
                    long l = (Long)this.value;
                    if (l == 0L) {
                        this.opc = 9;
                        return;
                    }
                    if (l == 1L) {
                        this.opc = 10;
                        return;
                    }
                } else if (this.value instanceof Double) {
                    double d = (Double)this.value;
                    if (d == 0.0) {
                        if (Double.doubleToLongBits(d) == 0L) {
                            this.opc = 14;
                            return;
                        }
                    } else if (d == 1.0) {
                        this.opc = 15;
                        return;
                    }
                }
                constantPool.put(this.value);
                return;
            }
            case -3: {
                Enumeration enumeration = ((TryData)this.value).catches.elements();
                while (enumeration.hasMoreElements()) {
                    CatchData catchData = (CatchData)enumeration.nextElement();
                    if (catchData.getType() == null) continue;
                    constantPool.put(catchData.getType());
                }
                return;
            }
            case 0: {
                if (this.value != null && this.value instanceof ClassDeclaration) {
                    constantPool.put(this.value);
                }
                return;
            }
        }
    }

    public int getOpcode() {
        return this.pc;
    }

    public Object getValue() {
        return this.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void optimize(Environment environment) {
        switch (this.opc) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                if (!(this.value instanceof LocalVariable) || environment.debug_vars()) return;
                this.value = new Integer(((LocalVariable)this.value).slot);
                return;
            }
            case 167: {
                Label label = (Label)this.value;
                label = label.getDestination();
                this.value = label;
                if (label == this.next) {
                    this.opc = -2;
                    return;
                }
                if (label.next == null || !environment.opt()) return;
                switch (label.next.opc) {
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: {
                        this.opc = label.next.opc;
                        this.value = label.next.value;
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                this.value = ((Label)this.value).getDestination();
                if (this.value == this.next) {
                    this.opc = 87;
                    return;
                }
                if (this.next.opc != 167 || this.value != this.next.next) return;
                switch (this.opc) {
                    case 153: {
                        this.opc = 154;
                        break;
                    }
                    case 154: {
                        this.opc = 153;
                        break;
                    }
                    case 155: {
                        this.opc = 156;
                        break;
                    }
                    case 158: {
                        this.opc = 157;
                        break;
                    }
                    case 157: {
                        this.opc = 158;
                        break;
                    }
                    case 156: {
                        this.opc = 155;
                        break;
                    }
                    case 198: {
                        this.opc = 199;
                        break;
                    }
                    case 199: {
                        this.opc = 198;
                        break;
                    }
                }
                this.flagCondInverted ^= true;
                this.value = this.next.value;
                this.next.opc = -2;
                return;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.value = ((Label)this.value).getDestination();
                if (this.value == this.next) {
                    this.opc = 88;
                    return;
                }
                if (this.next.opc != 167 || this.value != this.next.next) return;
                switch (this.opc) {
                    case 165: {
                        this.opc = 166;
                        break;
                    }
                    case 166: {
                        this.opc = 165;
                        break;
                    }
                    case 159: {
                        this.opc = 160;
                        break;
                    }
                    case 160: {
                        this.opc = 159;
                        break;
                    }
                    case 163: {
                        this.opc = 164;
                        break;
                    }
                    case 162: {
                        this.opc = 161;
                        break;
                    }
                    case 161: {
                        this.opc = 162;
                        break;
                    }
                    case 164: {
                        this.opc = 163;
                        break;
                    }
                }
                this.flagCondInverted ^= true;
                this.value = this.next.value;
                this.next.opc = -2;
                return;
            }
            case 170: 
            case 171: {
                SwitchData switchData = (SwitchData)this.value;
                switchData.defaultLabel = switchData.defaultLabel.getDestination();
                Enumeration enumeration = switchData.tab.keys();
                while (enumeration.hasMoreElements()) {
                    Integer n = (Integer)enumeration.nextElement();
                    Label label = (Label)switchData.tab.get(n);
                    switchData.tab.put(n, label.getDestination());
                }
                long l = (long)switchData.maxValue - (long)switchData.minValue + 1L;
                long l2 = 4L + l;
                long l3 = switchData.tab.size();
                long l4 = 3L + 2L * l3;
                if ((double)l2 <= (double)l4 * SWITCHRATIO) {
                    this.opc = 170;
                    return;
                }
                this.opc = 171;
                return;
            }
        }
    }

    public void setValue(Object object) {
        this.value = object;
    }

    int size(ConstantPool constantPool) {
        switch (this.opc) {
            case -3: 
            case -2: 
            case -1: {
                return 0;
            }
            case 16: 
            case 188: {
                return 2;
            }
            case 17: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                return 3;
            }
            case 18: 
            case 19: {
                if (constantPool.index(this.value) < 256) {
                    this.opc = 18;
                    return 2;
                }
                this.opc = 19;
                return 3;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                int n = ((Number)this.value).intValue();
                if (n < 4) {
                    if (n < 0) {
                        throw new CompilerError("invalid slot: " + this.toString() + "\nThis error possibly resulted from poorly constructed class paths.");
                    }
                    this.opc = 26 + (this.opc - 21) * 4 + n;
                    return 1;
                }
                if (n <= 255) {
                    return 2;
                }
                this.opc += 256;
                return 4;
            }
            case 132: {
                int n = ((int[])this.value)[0];
                int n2 = ((int[])this.value)[1];
                if (n < 0) {
                    throw new CompilerError("invalid slot: " + this.toString());
                }
                if (n <= 255 && (byte)n2 == n2) {
                    return 3;
                }
                this.opc += 256;
                return 6;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                int n;
                int n3 = n = this.value instanceof Number ? ((Number)this.value).intValue() : ((LocalVariable)this.value).slot;
                if (n < 4) {
                    if (n < 0) {
                        throw new CompilerError("invalid slot: " + this.toString());
                    }
                    this.opc = 59 + (this.opc - 54) * 4 + n;
                    return 1;
                }
                if (n <= 255) {
                    return 2;
                }
                this.opc += 256;
                return 4;
            }
            case 169: {
                int n = ((Number)this.value).intValue();
                if (n <= 255) {
                    if (n < 0) {
                        throw new CompilerError("invalid slot: " + this.toString());
                    }
                    return 2;
                }
                this.opc += 256;
                return 4;
            }
            case 20: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 187: 
            case 189: 
            case 192: 
            case 193: {
                return 3;
            }
            case 197: {
                return 4;
            }
            case 185: 
            case 200: 
            case 201: {
                return 5;
            }
            case 170: {
                SwitchData switchData = (SwitchData)this.value;
                int n = 1;
                while ((this.pc + n) % 4 != 0) {
                    ++n;
                }
                return n + 16 + (switchData.maxValue - switchData.minValue) * 4;
            }
            case 171: {
                SwitchData switchData = (SwitchData)this.value;
                int n = 1;
                while ((this.pc + n) % 4 != 0) {
                    ++n;
                }
                return n + 8 + switchData.tab.size() * 8;
            }
            case 0: {
                if (this.value != null && !(this.value instanceof Integer)) {
                    return 2;
                }
                return 1;
            }
        }
        return 1;
    }

    public String toString() {
        String string = String.valueOf(this.where >> 32) + ":\t";
        switch (this.opc) {
            case -3: {
                return String.valueOf(string) + "try " + ((TryData)this.value).getEndLabel().hashCode();
            }
            case -2: {
                return String.valueOf(string) + "dead";
            }
            case 132: {
                int n = ((int[])this.value)[0];
                int n2 = ((int[])this.value)[1];
                return String.valueOf(string) + RuntimeConstants.opcNames[this.opc] + " " + n + ", " + n2;
            }
        }
        if (this.value != null) {
            if (this.value instanceof Label) {
                return String.valueOf(string) + RuntimeConstants.opcNames[this.opc] + " " + this.value.toString();
            }
            if (this.value instanceof Instruction) {
                return String.valueOf(string) + RuntimeConstants.opcNames[this.opc] + " " + this.value.hashCode();
            }
            if (this.value instanceof String) {
                return String.valueOf(string) + RuntimeConstants.opcNames[this.opc] + " \"" + this.value + "\"";
            }
            return String.valueOf(string) + RuntimeConstants.opcNames[this.opc] + " " + this.value;
        }
        return String.valueOf(string) + RuntimeConstants.opcNames[this.opc];
    }

    void write(DataOutputStream dataOutputStream, ConstantPool constantPool) throws IOException {
        switch (this.opc) {
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 169: 
            case 188: {
                dataOutputStream.writeByte(this.opc);
                dataOutputStream.writeByte(((Number)this.value).intValue());
                break;
            }
            case 277: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 425: {
                dataOutputStream.writeByte(196);
                dataOutputStream.writeByte(this.opc - 256);
                dataOutputStream.writeShort(((Number)this.value).intValue());
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                dataOutputStream.writeByte(this.opc);
                dataOutputStream.writeByte(this.value instanceof Number ? ((Number)this.value).intValue() : ((LocalVariable)this.value).slot);
                break;
            }
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: {
                dataOutputStream.writeByte(196);
                dataOutputStream.writeByte(this.opc - 256);
                dataOutputStream.writeShort(this.value instanceof Number ? ((Number)this.value).intValue() : ((LocalVariable)this.value).slot);
                break;
            }
            case 17: {
                dataOutputStream.writeByte(this.opc);
                dataOutputStream.writeShort(((Number)this.value).intValue());
                break;
            }
            case 18: {
                dataOutputStream.writeByte(this.opc);
                dataOutputStream.writeByte(constantPool.index(this.value));
                break;
            }
            case 19: 
            case 20: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 187: 
            case 192: 
            case 193: {
                dataOutputStream.writeByte(this.opc);
                dataOutputStream.writeShort(constantPool.index(this.value));
                break;
            }
            case 132: {
                dataOutputStream.writeByte(this.opc);
                dataOutputStream.writeByte(((int[])this.value)[0]);
                dataOutputStream.writeByte(((int[])this.value)[1]);
                break;
            }
            case 388: {
                dataOutputStream.writeByte(196);
                dataOutputStream.writeByte(this.opc - 256);
                dataOutputStream.writeShort(((int[])this.value)[0]);
                dataOutputStream.writeShort(((int[])this.value)[1]);
                break;
            }
            case 189: {
                dataOutputStream.writeByte(this.opc);
                dataOutputStream.writeShort(constantPool.index(this.value));
                break;
            }
            case 197: {
                dataOutputStream.writeByte(this.opc);
                dataOutputStream.writeShort(constantPool.index(((ArrayData)this.value).type));
                dataOutputStream.writeByte(((ArrayData)this.value).nargs);
                break;
            }
            case 185: {
                dataOutputStream.writeByte(this.opc);
                dataOutputStream.writeShort(constantPool.index(this.value));
                dataOutputStream.writeByte(((MemberDefinition)this.value).getType().stackSize() + 1);
                dataOutputStream.writeByte(0);
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                dataOutputStream.writeByte(this.opc);
                dataOutputStream.writeShort(((Instruction)this.value).pc - this.pc);
                break;
            }
            case 200: 
            case 201: {
                dataOutputStream.writeByte(this.opc);
                dataOutputStream.writeLong(((Instruction)this.value).pc - this.pc);
                break;
            }
            case 170: {
                SwitchData switchData = (SwitchData)this.value;
                dataOutputStream.writeByte(this.opc);
                int n = 1;
                while ((this.pc + n) % 4 != 0) {
                    dataOutputStream.writeByte(0);
                    ++n;
                }
                dataOutputStream.writeInt(switchData.defaultLabel.pc - this.pc);
                dataOutputStream.writeInt(switchData.minValue);
                dataOutputStream.writeInt(switchData.maxValue);
                int n2 = switchData.minValue;
                while (n2 <= switchData.maxValue) {
                    Label label = switchData.get(n2);
                    int n3 = label != null ? label.pc : switchData.defaultLabel.pc;
                    dataOutputStream.writeInt(n3 - this.pc);
                    ++n2;
                }
                break;
            }
            case 171: {
                SwitchData switchData = (SwitchData)this.value;
                dataOutputStream.writeByte(this.opc);
                int n = this.pc + 1;
                while (n % 4 != 0) {
                    dataOutputStream.writeByte(0);
                    ++n;
                }
                dataOutputStream.writeInt(switchData.defaultLabel.pc - this.pc);
                dataOutputStream.writeInt(switchData.tab.size());
                Enumeration enumeration = switchData.sortedKeys();
                while (enumeration.hasMoreElements()) {
                    Integer n4 = (Integer)enumeration.nextElement();
                    dataOutputStream.writeInt(n4);
                    dataOutputStream.writeInt(switchData.get((Integer)n4).pc - this.pc);
                }
                break;
            }
            case 0: {
                if (this.value != null) {
                    if (this.value instanceof Integer) {
                        dataOutputStream.writeByte((Integer)this.value);
                    } else {
                        dataOutputStream.writeShort(constantPool.index(this.value));
                    }
                    return;
                }
            }
            default: {
                dataOutputStream.writeByte(this.opc);
            }
            case -3: 
            case -2: 
            case -1: 
        }
    }
}

