/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPath;
import sun.tools.java.Identifier;
import sun.tools.java.Type;

public class Package {
    ClassPath sourcePath;
    ClassPath binaryPath;
    String pkg;

    public Package(ClassPath classPath, ClassPath classPath2, Identifier identifier) throws IOException {
        if (identifier.isInner()) {
            identifier = Identifier.lookup(identifier.getQualifier(), identifier.getFlatName());
        }
        this.sourcePath = classPath;
        this.binaryPath = classPath2;
        this.pkg = identifier.toString().replace('.', File.separatorChar);
    }

    public Package(ClassPath classPath, Identifier identifier) throws IOException {
        this(classPath, classPath, identifier);
    }

    public boolean classExists(Identifier identifier) {
        return this.getBinaryFile(identifier) != null || !identifier.isInner() && this.getSourceFile(identifier) != null;
    }

    public boolean exists() {
        ClassFile classFile = this.binaryPath.getDirectory(this.pkg);
        if (classFile != null && classFile.isDirectory()) {
            return true;
        }
        if (this.sourcePath != this.binaryPath && (classFile = this.sourcePath.getDirectory(this.pkg)) != null && classFile.isDirectory()) {
            return true;
        }
        String string = String.valueOf(this.pkg) + File.separator;
        return this.binaryPath.getFiles(string, ".class").hasMoreElements() || this.sourcePath.getFiles(string, ".java").hasMoreElements();
    }

    public ClassFile getBinaryFile(Identifier identifier) {
        identifier = Type.mangleInnerType(identifier);
        String string = String.valueOf(identifier.toString()) + ".class";
        return this.binaryPath.getFile(this.makeName(string));
    }

    public Enumeration getBinaryFiles() {
        return this.binaryPath.getFiles(this.pkg, ".class");
    }

    public ClassFile getSourceFile(String string) {
        if (string.endsWith(".java")) {
            return this.sourcePath.getFile(this.makeName(string));
        }
        return null;
    }

    public ClassFile getSourceFile(Identifier identifier) {
        identifier = identifier.getTopName();
        String string = String.valueOf(identifier.toString()) + ".java";
        return this.sourcePath.getFile(this.makeName(string));
    }

    public Enumeration getSourceFiles() {
        return this.sourcePath.getFiles(this.pkg, ".java");
    }

    private String makeName(String string) {
        return this.pkg.equals("") ? string : String.valueOf(this.pkg) + File.separator + string;
    }

    public String toString() {
        if (this.pkg.equals("")) {
            return "unnamed package";
        }
        return "package " + this.pkg;
    }
}

