/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.InputListener;
import com.sun.tools.example.debug.bdi.OutputListener;
import com.sun.tools.example.debug.bdi.Session;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;
import javax.swing.SwingUtilities;

class ChildSession
extends Session {
    private Process process;
    private PrintWriter in;
    private BufferedReader out;
    private BufferedReader err;
    private InputWriter inputWriter;
    private OutputReader outputReader;
    private OutputReader errorReader;
    private InputListener input;
    private OutputListener output;
    private OutputListener error;

    private ChildSession(ExecutionManager executionManager, VirtualMachine virtualMachine, InputListener inputListener, OutputListener outputListener, OutputListener outputListener2, OutputListener outputListener3) {
        super(virtualMachine, executionManager, outputListener3);
        this.input = inputListener;
        this.output = outputListener;
        this.error = outputListener2;
    }

    public ChildSession(ExecutionManager executionManager, LaunchingConnector launchingConnector, Map map, InputListener inputListener, OutputListener outputListener, OutputListener outputListener2, OutputListener outputListener3) {
        this(executionManager, ChildSession.generalGetVM(outputListener3, launchingConnector, map), inputListener, outputListener, outputListener2, outputListener3);
    }

    public ChildSession(ExecutionManager executionManager, String string, String string2, InputListener inputListener, OutputListener outputListener, OutputListener outputListener2, OutputListener outputListener3) {
        this(executionManager, ChildSession.getVM(outputListener3, string, string2), inputListener, outputListener, outputListener2, outputListener3);
    }

    public boolean attach() {
        if (!this.connectToVMProcess()) {
            this.diagnostics.putString("Could not launch VM");
            return false;
        }
        OutputReader outputReader = new OutputReader("output reader", "output", this.out, this.output, this.diagnostics);
        outputReader.setPriority(9);
        outputReader.start();
        OutputReader outputReader2 = new OutputReader("error reader", "error", this.err, this.error, this.diagnostics);
        outputReader2.setPriority(9);
        outputReader2.start();
        InputWriter inputWriter = new InputWriter("input writer", this.in, this.input);
        inputWriter.setPriority(9);
        inputWriter.start();
        if (!super.attach()) {
            if (this.process != null) {
                this.process.destroy();
                this.process = null;
            }
            return false;
        }
        return true;
    }

    private boolean connectToVMProcess() {
        if (this.vm == null) {
            return false;
        }
        this.process = this.vm.process();
        this.in = new PrintWriter(new OutputStreamWriter(this.process.getOutputStream()));
        this.out = new BufferedReader(new InputStreamReader(this.process.getInputStream()), 1);
        this.err = new BufferedReader(new InputStreamReader(this.process.getErrorStream()), 1);
        return true;
    }

    public void detach() {
        super.detach();
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
    }

    private static void dumpFailedLaunchInfo(OutputListener outputListener, Process process) {
        try {
            ChildSession.dumpStream(outputListener, process.getErrorStream());
            ChildSession.dumpStream(outputListener, process.getInputStream());
        }
        catch (IOException iOException) {
            outputListener.putString("Unable to display process output: " + iOException.getMessage());
        }
    }

    private static void dumpStream(OutputListener outputListener, InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            outputListener.putString(string);
        }
    }

    private static VirtualMachine generalGetVM(OutputListener outputListener, LaunchingConnector launchingConnector, Map map) {
        VirtualMachine virtualMachine = null;
        try {
            outputListener.putString("Starting child.");
            virtualMachine = launchingConnector.launch(map);
        }
        catch (IOException iOException) {
            outputListener.putString("Unable to start child: " + iOException.getMessage());
        }
        catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
            outputListener.putString("Unable to start child: " + illegalConnectorArgumentsException.getMessage());
        }
        catch (VMStartException vMStartException) {
            outputListener.putString("Unable to start child: " + vMStartException.getMessage() + '\n');
            ChildSession.dumpFailedLaunchInfo(outputListener, vMStartException.process());
        }
        return virtualMachine;
    }

    private static VirtualMachine getVM(OutputListener outputListener, String string, String string2) {
        VirtualMachineManager virtualMachineManager = Bootstrap.virtualMachineManager();
        LaunchingConnector launchingConnector = virtualMachineManager.defaultConnector();
        Map map = launchingConnector.defaultArguments();
        ((Connector.Argument)map.get("options")).setValue(string);
        ((Connector.Argument)map.get("main")).setValue(string2);
        return ChildSession.generalGetVM(outputListener, launchingConnector, map);
    }

    private static class OutputReader
    extends Thread {
        private String streamName;
        private BufferedReader stream;
        private OutputListener output;
        private OutputListener diagnostics;
        private boolean running = true;
        private char[] buffer = new char[512];

        OutputReader(String string, String string2, BufferedReader bufferedReader, OutputListener outputListener, OutputListener outputListener2) {
            super(string);
            this.streamName = string2;
            this.stream = bufferedReader;
            this.output = outputListener;
            this.diagnostics = outputListener2;
        }

        static /* synthetic */ OutputListener access$0(OutputReader outputReader) {
            return outputReader.output;
        }

        static /* synthetic */ OutputListener access$1(OutputReader outputReader) {
            return outputReader.diagnostics;
        }

        static /* synthetic */ String access$2(OutputReader outputReader) {
            return outputReader.streamName;
        }

        public void quit() {
            this.running = false;
        }

        public void run() {
            try {
                int n;
                while (this.running && (n = this.stream.read(this.buffer, 0, 512)) != -1) {
                    if (n <= 0) continue;
                    String string = new String(this.buffer, 0, n);
                    SwingUtilities.invokeLater(new Runnable(string, this){
                        private final /* synthetic */ String val$chars;
                        private final /* synthetic */ OutputReader this$0;
                        {
                            this.val$chars = string;
                            this.this$0 = outputReader;
                        }

                        public void run() {
                            OutputReader.access$0(this.this$0).putString(this.val$chars);
                        }
                    });
                }
            }
            catch (IOException iOException) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ OutputReader this$0;
                    {
                        this.this$0 = outputReader;
                    }

                    public void run() {
                        OutputReader.access$1(this.this$0).putString("IO error reading " + OutputReader.access$2(this.this$0) + " stream of child java interpreter");
                    }
                });
            }
        }
    }

    private static class InputWriter
    extends Thread {
        private PrintWriter stream;
        private InputListener input;
        private boolean running = true;

        InputWriter(String string, PrintWriter printWriter, InputListener inputListener) {
            super(string);
            this.stream = printWriter;
            this.input = inputListener;
        }

        public void quit() {
            this.running = false;
        }

        public void run() {
            while (this.running) {
                String string = this.input.getLine();
                this.stream.println(string);
                this.stream.flush();
            }
        }
    }
}

