/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequest;
import com.sun.tools.example.debug.bdi.AccessWatchpointSpec;
import com.sun.tools.example.debug.bdi.BreakpointSpec;
import com.sun.tools.example.debug.bdi.EventRequestSpec;
import com.sun.tools.example.debug.bdi.ExceptionSpec;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.LineBreakpointSpec;
import com.sun.tools.example.debug.bdi.MethodBreakpointSpec;
import com.sun.tools.example.debug.bdi.ModificationWatchpointSpec;
import com.sun.tools.example.debug.bdi.PatternReferenceTypeSpec;
import com.sun.tools.example.debug.bdi.SourceNameReferenceTypeSpec;
import com.sun.tools.example.debug.bdi.SpecErrorEvent;
import com.sun.tools.example.debug.bdi.SpecEvent;
import com.sun.tools.example.debug.bdi.SpecListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

class EventRequestSpecList {
    private List eventRequestSpecs = Collections.synchronizedList(new ArrayList());
    final ExecutionManager runtime;

    EventRequestSpecList(ExecutionManager executionManager) {
        this.runtime = executionManager;
    }

    AccessWatchpointSpec createAccessWatchpoint(String string, String string2) {
        PatternReferenceTypeSpec patternReferenceTypeSpec = new PatternReferenceTypeSpec(string);
        return new AccessWatchpointSpec(this, patternReferenceTypeSpec, string2);
    }

    BreakpointSpec createClassLineBreakpoint(String string, int n) {
        PatternReferenceTypeSpec patternReferenceTypeSpec = new PatternReferenceTypeSpec(string);
        return new LineBreakpointSpec(this, patternReferenceTypeSpec, n);
    }

    ExceptionSpec createExceptionIntercept(String string, boolean bl, boolean bl2) {
        PatternReferenceTypeSpec patternReferenceTypeSpec = new PatternReferenceTypeSpec(string);
        return new ExceptionSpec(this, patternReferenceTypeSpec, bl, bl2);
    }

    BreakpointSpec createMethodBreakpoint(String string, String string2, List list) {
        PatternReferenceTypeSpec patternReferenceTypeSpec = new PatternReferenceTypeSpec(string);
        return new MethodBreakpointSpec(this, patternReferenceTypeSpec, string2, list);
    }

    ModificationWatchpointSpec createModificationWatchpoint(String string, String string2) {
        PatternReferenceTypeSpec patternReferenceTypeSpec = new PatternReferenceTypeSpec(string);
        return new ModificationWatchpointSpec(this, patternReferenceTypeSpec, string2);
    }

    BreakpointSpec createSourceLineBreakpoint(String string, int n) {
        SourceNameReferenceTypeSpec sourceNameReferenceTypeSpec = new SourceNameReferenceTypeSpec(string, n);
        return new LineBreakpointSpec(this, sourceNameReferenceTypeSpec, n);
    }

    void delete(EventRequestSpec eventRequestSpec) {
        EventRequest eventRequest = eventRequestSpec.getEventRequest();
        List list = this.eventRequestSpecs;
        synchronized (list) {
            this.eventRequestSpecs.remove(eventRequestSpec);
        }
        if (eventRequest != null) {
            eventRequest.virtualMachine().eventRequestManager().deleteEventRequest(eventRequest);
        }
        this.notifyDeleted(eventRequestSpec);
    }

    List eventRequestSpecs() {
        List list = this.eventRequestSpecs;
        synchronized (list) {
            ArrayList arrayList = new ArrayList(this.eventRequestSpecs);
            Object var3_3 = null;
            return arrayList;
        }
    }

    void install(EventRequestSpec eventRequestSpec, VirtualMachine virtualMachine) {
        List list = this.eventRequestSpecs;
        synchronized (list) {
            this.eventRequestSpecs.add(eventRequestSpec);
        }
        if (virtualMachine != null) {
            eventRequestSpec.attemptImmediateResolve(virtualMachine);
        }
    }

    void notifyDeferred(EventRequestSpec eventRequestSpec) {
        Vector vector = this.specListeners();
        SpecEvent specEvent = new SpecEvent(eventRequestSpec);
        int n = 0;
        while (n < vector.size()) {
            eventRequestSpec.notifyDeferred((SpecListener)vector.elementAt(n), specEvent);
            ++n;
        }
    }

    void notifyDeleted(EventRequestSpec eventRequestSpec) {
        Vector vector = this.specListeners();
        SpecEvent specEvent = new SpecEvent(eventRequestSpec);
        int n = 0;
        while (n < vector.size()) {
            eventRequestSpec.notifyDeleted((SpecListener)vector.elementAt(n), specEvent);
            ++n;
        }
    }

    void notifyError(EventRequestSpec eventRequestSpec, Exception exception) {
        Vector vector = this.specListeners();
        SpecErrorEvent specErrorEvent = new SpecErrorEvent(eventRequestSpec, exception);
        int n = 0;
        while (n < vector.size()) {
            eventRequestSpec.notifyError((SpecListener)vector.elementAt(n), specErrorEvent);
            ++n;
        }
    }

    void notifyResolved(EventRequestSpec eventRequestSpec) {
        Vector vector = this.specListeners();
        SpecEvent specEvent = new SpecEvent(eventRequestSpec);
        int n = 0;
        while (n < vector.size()) {
            eventRequestSpec.notifyResolved((SpecListener)vector.elementAt(n), specEvent);
            ++n;
        }
    }

    void notifySet(EventRequestSpec eventRequestSpec) {
        Vector vector = this.specListeners();
        SpecEvent specEvent = new SpecEvent(eventRequestSpec);
        int n = 0;
        while (n < vector.size()) {
            eventRequestSpec.notifySet((SpecListener)vector.elementAt(n), specEvent);
            ++n;
        }
    }

    void resolve(ReferenceType referenceType) {
        List list = this.eventRequestSpecs;
        synchronized (list) {
            Iterator iterator = this.eventRequestSpecs.iterator();
            while (iterator.hasNext()) {
                ((EventRequestSpec)iterator.next()).attemptResolve(referenceType);
            }
        }
    }

    private Vector specListeners() {
        return (Vector)this.runtime.specListeners.clone();
    }
}

