/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.Session;
import com.sun.tools.example.debug.event.AbstractEventSet;
import com.sun.tools.example.debug.event.AccessWatchpointEventSet;
import com.sun.tools.example.debug.event.ClassPrepareEventSet;
import com.sun.tools.example.debug.event.ClassUnloadEventSet;
import com.sun.tools.example.debug.event.ExceptionEventSet;
import com.sun.tools.example.debug.event.JDIListener;
import com.sun.tools.example.debug.event.LocationTriggerEventSet;
import com.sun.tools.example.debug.event.ModificationWatchpointEventSet;
import com.sun.tools.example.debug.event.ThreadDeathEventSet;
import com.sun.tools.example.debug.event.ThreadStartEventSet;
import com.sun.tools.example.debug.event.VMDeathEventSet;
import com.sun.tools.example.debug.event.VMDisconnectEventSet;
import com.sun.tools.example.debug.event.VMStartEventSet;
import java.util.AbstractList;
import java.util.Iterator;
import javax.swing.SwingUtilities;

class JDIEventSource
extends Thread {
    private EventQueue queue;
    private Session session;
    private ExecutionManager runtime;
    private final JDIListener firstListener = new FirstListener();
    private boolean wantInterrupt;

    JDIEventSource(Session session) {
        super("JDI Event Set Dispatcher");
        this.session = session;
        this.runtime = session.runtime;
        this.queue = session.vm.eventQueue();
    }

    private void dispatchEventSet(final AbstractEventSet abstractEventSet) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object object;
                boolean bl = abstractEventSet.suspendedAll();
                abstractEventSet.notify(firstListener);
                boolean bl2 = wantInterrupt;
                Iterator iterator = ((AbstractList)((JDIEventSource)this).session.runtime.jdiListeners).iterator();
                while (iterator.hasNext()) {
                    object = (JDIListener)iterator.next();
                    abstractEventSet.notify((JDIListener)object);
                }
                if (bl && !bl2) {
                    ((JDIEventSource)this).session.interrupted = false;
                    try {
                        ((JDIEventSource)this).session.vm.resume();
                    }
                    catch (VMDisconnectedException vMDisconnectedException) {}
                }
                if (abstractEventSet instanceof ThreadDeathEventSet) {
                    object = ((ThreadDeathEventSet)abstractEventSet).getThread();
                    ((JDIEventSource)this).session.runtime.removeThreadInfo((ThreadReference)object);
                }
            }
        });
    }

    private void finalizeEventSet(AbstractEventSet abstractEventSet) {
        if (this.session.interrupted && !this.wantInterrupt) {
            this.session.interrupted = false;
            try {
                this.session.vm.resume();
            }
            catch (VMDisconnectedException vMDisconnectedException) {}
        }
        if (abstractEventSet instanceof ThreadDeathEventSet) {
            ThreadReference threadReference = ((ThreadDeathEventSet)abstractEventSet).getThread();
            this.session.runtime.removeThreadInfo(threadReference);
        }
    }

    public void run() {
        try {
            this.runLoop();
        }
        catch (Exception exception) {}
        this.session.running = false;
    }

    private void runLoop() throws InterruptedException {
        AbstractEventSet abstractEventSet;
        do {
            EventSet eventSet = this.queue.remove();
            abstractEventSet = AbstractEventSet.toSpecificEventSet(eventSet);
            this.session.interrupted = abstractEventSet.suspendedAll();
            this.dispatchEventSet(abstractEventSet);
        } while (!(abstractEventSet instanceof VMDisconnectEventSet));
    }

    private class FirstListener
    implements JDIListener {
        FirstListener() {
        }

        public void accessWatchpoint(AccessWatchpointEventSet accessWatchpointEventSet) {
            ((JDIEventSource)JDIEventSource.this).session.runtime.validateThreadInfo();
            JDIEventSource.this.wantInterrupt = true;
        }

        public void classPrepare(ClassPrepareEventSet classPrepareEventSet) {
            JDIEventSource.this.wantInterrupt = false;
            JDIEventSource.this.runtime.resolve(classPrepareEventSet.getReferenceType());
        }

        public void classUnload(ClassUnloadEventSet classUnloadEventSet) {
            JDIEventSource.this.wantInterrupt = false;
        }

        public void exception(ExceptionEventSet exceptionEventSet) {
            JDIEventSource.this.wantInterrupt = true;
        }

        public void locationTrigger(LocationTriggerEventSet locationTriggerEventSet) {
            ((JDIEventSource)JDIEventSource.this).session.runtime.validateThreadInfo();
            JDIEventSource.this.wantInterrupt = true;
        }

        public void modificationWatchpoint(ModificationWatchpointEventSet modificationWatchpointEventSet) {
            ((JDIEventSource)JDIEventSource.this).session.runtime.validateThreadInfo();
            JDIEventSource.this.wantInterrupt = true;
        }

        public void threadDeath(ThreadDeathEventSet threadDeathEventSet) {
            JDIEventSource.this.wantInterrupt = false;
        }

        public void threadStart(ThreadStartEventSet threadStartEventSet) {
            JDIEventSource.this.wantInterrupt = false;
        }

        public void vmDeath(VMDeathEventSet vMDeathEventSet) {
            JDIEventSource.this.wantInterrupt = false;
        }

        public void vmDisconnect(VMDisconnectEventSet vMDisconnectEventSet) {
            JDIEventSource.this.wantInterrupt = false;
            ((JDIEventSource)JDIEventSource.this).session.runtime.endSession();
        }

        public void vmStart(VMStartEventSet vMStartEventSet) {
            JDIEventSource.this.wantInterrupt = false;
        }
    }
}

