/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.ClassType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.example.debug.bdi.AmbiguousMethodException;
import com.sun.tools.example.debug.bdi.BreakpointSpec;
import com.sun.tools.example.debug.bdi.EventRequestSpecList;
import com.sun.tools.example.debug.bdi.MalformedMemberNameException;
import com.sun.tools.example.debug.bdi.NoSessionException;
import com.sun.tools.example.debug.bdi.ReferenceTypeSpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MethodBreakpointSpec
extends BreakpointSpec {
    String methodId;
    List methodArgs;

    MethodBreakpointSpec(EventRequestSpecList eventRequestSpecList, ReferenceTypeSpec referenceTypeSpec, String string, List list) {
        super(eventRequestSpecList, referenceTypeSpec);
        this.methodId = string;
        this.methodArgs = list;
    }

    private boolean compareArgTypes(Method method, List list) {
        List list2 = method.argumentTypeNames();
        if (list2.size() != list.size()) {
            return false;
        }
        int n = 0;
        while (n < list2.size()) {
            String string;
            String string2 = (String)list2.get(n);
            if (!string2.equals(string = (String)list.get(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof MethodBreakpointSpec) {
            MethodBreakpointSpec methodBreakpointSpec = (MethodBreakpointSpec)object;
            return this.methodId.equals(methodBreakpointSpec.methodId) && this.methodArgs.equals(methodBreakpointSpec.methodArgs) && this.refSpec.equals(methodBreakpointSpec.refSpec);
        }
        return false;
    }

    public String errorMessageFor(Exception exception) {
        if (exception instanceof AmbiguousMethodException) {
            return "Method " + this.methodName() + " is overloaded; specify arguments";
        }
        if (exception instanceof NoSuchMethodException) {
            return "No method " + this.methodName() + " in " + this.refSpec;
        }
        if (exception instanceof InvalidTypeException) {
            return "Breakpoints can be located only in classes. " + this.refSpec + " is an interface or array";
        }
        return super.errorMessageFor(exception);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Method findMatchingMethod(ClassType classType) throws AmbiguousMethodException, NoSuchMethodException, NoSessionException {
        Object object;
        Object object2;
        Iterator iterator;
        ArrayList<String> arrayList = null;
        if (this.methodArgs() != null) {
            arrayList = new ArrayList<String>(this.methodArgs().size());
            iterator = this.methodArgs().iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                object2 = this.normalizeArgTypeName((String)object2);
                arrayList.add((String)object2);
            }
        }
        iterator = classType.methods().iterator();
        object2 = null;
        Object object3 = null;
        int n = 0;
        while (iterator.hasNext()) {
            object = (Method)iterator.next();
            if (!object.name().equals(this.methodName())) continue;
            if (++n == 1) {
                object2 = object;
            }
            if (arrayList == null || !this.compareArgTypes((Method)object, arrayList)) continue;
            object3 = object;
            break;
        }
        object = null;
        if (object3 != null) {
            return object3;
        }
        if (arrayList != null) throw new NoSuchMethodException(this.methodName());
        if (n <= 0) throw new NoSuchMethodException(this.methodName());
        if (n != 1) throw new AmbiguousMethodException();
        return object2;
    }

    public int hashCode() {
        return this.refSpec.hashCode() + (this.methodId != null ? this.methodId.hashCode() : 0) + (this.methodArgs != null ? this.methodArgs.hashCode() : 0);
    }

    private boolean isValidMethodName(String string) {
        return this.isJavaIdentifier(string) || string.equals("<init>") || string.equals("<clinit>");
    }

    private Location location(ClassType classType) throws AmbiguousMethodException, NoSuchMethodException, NoSessionException {
        Method method = this.findMatchingMethod(classType);
        Location location = method.location();
        return location;
    }

    public List methodArgs() {
        return this.methodArgs;
    }

    public String methodName() {
        return this.methodId;
    }

    private String normalizeArgTypeName(String string) throws NoSessionException {
        char c;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        string = string.trim();
        while (n < string.length()) {
            c = string.charAt(n);
            if (Character.isWhitespace(c) || c == '[') break;
            stringBuffer.append(c);
            ++n;
        }
        while (n < string.length()) {
            c = string.charAt(n);
            if (c == '[' || c == ']') {
                stringBuffer2.append(c);
            } else if (!Character.isWhitespace(c)) {
                throw new IllegalArgumentException("Invalid argument type name");
            }
            ++n;
        }
        string = stringBuffer.toString();
        if (string.indexOf(46) == -1 || string.startsWith("*.")) {
            try {
                List list = this.specs.runtime.findClassesMatchingPattern(string);
                if (list.size() > 0) {
                    string = ((ReferenceType)list.get(0)).name();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        string = String.valueOf(string) + stringBuffer2.toString();
        return string;
    }

    void resolve(ReferenceType referenceType) throws MalformedMemberNameException, AmbiguousMethodException, InvalidTypeException, NoSuchMethodException, NoSessionException {
        if (!this.isValidMethodName(this.methodId)) {
            throw new MalformedMemberNameException(this.methodId);
        }
        if (!(referenceType instanceof ClassType)) {
            throw new InvalidTypeException();
        }
        Location location = this.location((ClassType)referenceType);
        this.setRequest(referenceType.virtualMachine().eventRequestManager().createBreakpointRequest(location));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("breakpoint ");
        stringBuffer.append(this.refSpec.toString());
        stringBuffer.append('.');
        stringBuffer.append(this.methodId);
        if (this.methodArgs != null) {
            Iterator iterator = this.methodArgs.iterator();
            boolean bl = true;
            stringBuffer.append('(');
            while (iterator.hasNext()) {
                if (!bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((String)iterator.next());
                bl = false;
            }
            stringBuffer.append(")");
        }
        stringBuffer.append(" (");
        stringBuffer.append(this.getStatusString());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private VirtualMachine vm() {
        return this.request.virtualMachine();
    }
}

