/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.ReferenceType;
import com.sun.tools.example.debug.bdi.ReferenceTypeSpec;
import java.util.StringTokenizer;

class PatternReferenceTypeSpec
implements ReferenceTypeSpec {
    final boolean isWild;
    final String classId;

    PatternReferenceTypeSpec(String string) {
        this.isWild = string.startsWith("*.");
        this.classId = this.isWild ? string.substring(1) : string;
    }

    private void checkClassName(String string) throws ClassNotFoundException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!(this.isJavaIdentifier(string2) || bl && string2.equals("*"))) {
                throw new ClassNotFoundException();
            }
            bl = false;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof PatternReferenceTypeSpec) {
            PatternReferenceTypeSpec patternReferenceTypeSpec = (PatternReferenceTypeSpec)object;
            return this.classId.equals(patternReferenceTypeSpec.classId) && this.isWild == patternReferenceTypeSpec.isWild;
        }
        return false;
    }

    public int hashCode() {
        return this.classId.hashCode();
    }

    private boolean isJavaIdentifier(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean matches(ReferenceType referenceType) {
        if (this.isWild) {
            return referenceType.name().endsWith(this.classId);
        }
        return referenceType.name().equals(this.classId);
    }

    public String toString() {
        return this.isWild ? "*" + this.classId : this.classId;
    }
}

