/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.tools.example.debug.bdi.FrameIndexOutOfBoundsException;
import com.sun.tools.example.debug.bdi.VMNotInterruptedException;
import java.util.ArrayList;
import java.util.List;

public class ThreadInfo {
    private ThreadReference thread;
    private int status;
    private List frames;
    private int frameCount;
    private int extent;
    private int initial;
    private int prefetch;
    Object userObject;
    private boolean interrupted = false;

    ThreadInfo(ThreadReference threadReference, int n, int n2) {
        this.thread = threadReference;
        this.initial = n;
        this.prefetch = n2;
        this.frameCount = 0;
        this.frames = null;
    }

    private void assureInterrupted() throws VMNotInterruptedException {
        if (!this.interrupted) {
            throw new VMNotInterruptedException();
        }
    }

    public StackFrame getFrame(int n) throws VMNotInterruptedException {
        this.assureInterrupted();
        this.update();
        try {
            if (this.extent < n) {
                if (n < this.frameCount) {
                    int n2 = Math.min(n + this.prefetch, this.frameCount - 1);
                    this.frames.addAll(this.thread.frames(this.extent + 1, n2 - this.extent));
                    this.extent = n2;
                } else {
                    throw new FrameIndexOutOfBoundsException();
                }
            }
            return (StackFrame)this.frames.get(n);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            this.interrupted = false;
            throw new VMNotInterruptedException();
        }
    }

    public int getFrameCount() throws VMNotInterruptedException {
        this.assureInterrupted();
        this.update();
        return this.frameCount;
    }

    public int getStatus() throws VMNotInterruptedException {
        this.assureInterrupted();
        this.update();
        return this.status;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    void invalidate() {
        this.interrupted = false;
        this.frames = null;
        this.status = -1;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public ThreadReference thread() {
        return this.thread;
    }

    void update() throws VMNotInterruptedException {
        if (this.frames == null) {
            try {
                this.status = this.thread.status();
                this.frameCount = this.thread.frameCount();
                this.frames = new ArrayList(this.thread.frames(0, Math.min(this.frameCount, this.initial)));
                this.extent = this.initial - 1;
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                this.interrupted = false;
                throw new VMNotInterruptedException();
            }
        }
    }

    void validate() {
        this.interrupted = true;
    }
}

