/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.event;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.tools.example.debug.event.AccessWatchpointEventSet;
import com.sun.tools.example.debug.event.ClassPrepareEventSet;
import com.sun.tools.example.debug.event.ClassUnloadEventSet;
import com.sun.tools.example.debug.event.ExceptionEventSet;
import com.sun.tools.example.debug.event.JDIListener;
import com.sun.tools.example.debug.event.LocationTriggerEventSet;
import com.sun.tools.example.debug.event.ModificationWatchpointEventSet;
import com.sun.tools.example.debug.event.ThreadDeathEventSet;
import com.sun.tools.example.debug.event.ThreadStartEventSet;
import com.sun.tools.example.debug.event.VMDeathEventSet;
import com.sun.tools.example.debug.event.VMDisconnectEventSet;
import com.sun.tools.example.debug.event.VMStartEventSet;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;

public abstract class AbstractEventSet
extends EventObject
implements EventSet {
    private final EventSet jdiEventSet;
    final Event oneEvent;

    AbstractEventSet(EventSet eventSet) {
        super(eventSet.virtualMachine());
        this.jdiEventSet = eventSet;
        this.oneEvent = this.eventIterator().nextEvent();
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object object) {
        return this.jdiEventSet.contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.jdiEventSet.containsAll(collection);
    }

    public EventIterator eventIterator() {
        return this.jdiEventSet.eventIterator();
    }

    public int getSuspendPolicy() {
        return this.jdiEventSet.suspendPolicy();
    }

    public VirtualMachine getVirtualMachine() {
        return this.jdiEventSet.virtualMachine();
    }

    public boolean isEmpty() {
        return this.jdiEventSet.isEmpty();
    }

    public Iterator iterator() {
        return this.jdiEventSet.iterator();
    }

    public abstract void notify(JDIListener var1);

    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public void resume() {
        this.jdiEventSet.resume();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.jdiEventSet.size();
    }

    public int suspendPolicy() {
        return this.jdiEventSet.suspendPolicy();
    }

    public boolean suspendedAll() {
        return this.jdiEventSet.suspendPolicy() == 2;
    }

    public boolean suspendedEventThread() {
        return this.jdiEventSet.suspendPolicy() == 1;
    }

    public boolean suspendedNone() {
        return this.jdiEventSet.suspendPolicy() == 0;
    }

    public Object[] toArray() {
        return this.jdiEventSet.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.jdiEventSet.toArray(objectArray);
    }

    public static AbstractEventSet toSpecificEventSet(EventSet eventSet) {
        Event event = eventSet.eventIterator().nextEvent();
        if (event instanceof LocatableEvent) {
            if (event instanceof ExceptionEvent) {
                return new ExceptionEventSet(eventSet);
            }
            if (event instanceof WatchpointEvent) {
                if (event instanceof AccessWatchpointEvent) {
                    return new AccessWatchpointEventSet(eventSet);
                }
                return new ModificationWatchpointEventSet(eventSet);
            }
            return new LocationTriggerEventSet(eventSet);
        }
        if (event instanceof ClassPrepareEvent) {
            return new ClassPrepareEventSet(eventSet);
        }
        if (event instanceof ClassUnloadEvent) {
            return new ClassUnloadEventSet(eventSet);
        }
        if (event instanceof ThreadDeathEvent) {
            return new ThreadDeathEventSet(eventSet);
        }
        if (event instanceof ThreadStartEvent) {
            return new ThreadStartEventSet(eventSet);
        }
        if (event instanceof VMDeathEvent) {
            return new VMDeathEventSet(eventSet);
        }
        if (event instanceof VMDisconnectEvent) {
            return new VMDisconnectEventSet(eventSet);
        }
        if (event instanceof VMStartEvent) {
            return new VMStartEventSet(eventSet);
        }
        throw new IllegalArgumentException("Unknown event " + event);
    }

    public VirtualMachine virtualMachine() {
        return this.jdiEventSet.virtualMachine();
    }
}

