/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.Location;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.tools.example.debug.bdi.EventRequestSpec;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.OutputListener;
import com.sun.tools.example.debug.bdi.SessionListener;
import com.sun.tools.example.debug.bdi.SpecErrorEvent;
import com.sun.tools.example.debug.bdi.SpecEvent;
import com.sun.tools.example.debug.bdi.SpecListener;
import com.sun.tools.example.debug.bdi.Utils;
import com.sun.tools.example.debug.event.AccessWatchpointEventSet;
import com.sun.tools.example.debug.event.ClassPrepareEventSet;
import com.sun.tools.example.debug.event.ClassUnloadEventSet;
import com.sun.tools.example.debug.event.ExceptionEventSet;
import com.sun.tools.example.debug.event.JDIListener;
import com.sun.tools.example.debug.event.LocatableEventSet;
import com.sun.tools.example.debug.event.LocationTriggerEventSet;
import com.sun.tools.example.debug.event.ModificationWatchpointEventSet;
import com.sun.tools.example.debug.event.ThreadDeathEventSet;
import com.sun.tools.example.debug.event.ThreadStartEventSet;
import com.sun.tools.example.debug.event.VMDeathEventSet;
import com.sun.tools.example.debug.event.VMDisconnectEventSet;
import com.sun.tools.example.debug.event.VMStartEventSet;
import com.sun.tools.example.debug.gui.CommandInterpreter;
import com.sun.tools.example.debug.gui.ContextListener;
import com.sun.tools.example.debug.gui.ContextManager;
import com.sun.tools.example.debug.gui.CurrentFrameChangedEvent;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.SourceManager;
import com.sun.tools.example.debug.gui.TypeScript;
import com.sun.tools.example.debug.gui.TypeScriptOutputListener;
import com.sun.tools.example.debug.gui.TypeScriptWriter;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.EventObject;
import javax.swing.JPanel;

public class CommandTool
extends JPanel {
    private Environment env;
    private ContextManager context;
    private ExecutionManager runtime;
    private SourceManager sourceManager;
    private TypeScript script;
    private static final String DEFAULT_CMD_PROMPT = "Command:";

    public CommandTool(Environment environment) {
        super(new BorderLayout());
        this.env = environment;
        this.context = environment.getContextManager();
        this.runtime = environment.getExecutionManager();
        this.sourceManager = environment.getSourceManager();
        this.script = new TypeScript(DEFAULT_CMD_PROMPT, false);
        this.add(this.script);
        final CommandInterpreter commandInterpreter = new CommandInterpreter(environment);
        this.script.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                commandInterpreter.executeCommand(script.readln());
            }
        });
        TypeScriptOutputListener typeScriptOutputListener = new TypeScriptOutputListener(this.script, true);
        this.runtime.addDiagnosticsListener(typeScriptOutputListener);
        environment.setTypeScript(new PrintWriter(new TypeScriptWriter(this.script)));
        TTYDebugListener tTYDebugListener = new TTYDebugListener(typeScriptOutputListener);
        this.runtime.addJDIListener(tTYDebugListener);
        this.runtime.addSessionListener(tTYDebugListener);
        this.runtime.addSpecListener(tTYDebugListener);
        this.context.addContextListener(tTYDebugListener);
    }

    private String locationString(LocatableEventSet locatableEventSet) {
        Location location = locatableEventSet.getLocation();
        return "thread=\"" + locatableEventSet.getThread().name() + "\", " + Utils.locationString(location);
    }

    private String promptString(ThreadReference threadReference, int n) {
        if (threadReference == null) {
            return DEFAULT_CMD_PROMPT;
        }
        return String.valueOf(threadReference.name()) + "[" + (n + 1) + "]:";
    }

    private void setThread(LocatableEventSet locatableEventSet) {
        if (!locatableEventSet.suspendedNone()) {
            Thread.yield();
            this.script.setPrompt(this.promptString(locatableEventSet.getThread(), 0));
        }
    }

    private class TTYDebugListener
    implements JDIListener,
    SessionListener,
    SpecListener,
    ContextListener {
        private OutputListener diagnostics;

        TTYDebugListener(OutputListener outputListener) {
            this.diagnostics = outputListener;
        }

        public void accessWatchpoint(AccessWatchpointEventSet accessWatchpointEventSet) {
            CommandTool.this.setThread(accessWatchpointEventSet);
            EventIterator eventIterator = accessWatchpointEventSet.eventIterator();
            while (eventIterator.hasNext()) {
                Event event = eventIterator.nextEvent();
                this.diagnostics.putString("Watchpoint hit: " + CommandTool.this.locationString(accessWatchpointEventSet));
            }
        }

        public void breakpointDeferred(SpecEvent specEvent) {
            EventRequestSpec eventRequestSpec = specEvent.getEventRequestSpec();
            this.diagnostics.putString("Breakpoint will be set at " + eventRequestSpec + " when its class is loaded.");
        }

        public void breakpointDeleted(SpecEvent specEvent) {
            EventRequestSpec eventRequestSpec = specEvent.getEventRequestSpec();
            this.diagnostics.putString("Breakpoint at " + eventRequestSpec.toString() + " deleted.");
        }

        public void breakpointError(SpecErrorEvent specErrorEvent) {
            EventRequestSpec eventRequestSpec = specErrorEvent.getEventRequestSpec();
            this.diagnostics.putString("Deferred breakpoint at " + eventRequestSpec + " could not be resolved:" + specErrorEvent.getReason());
        }

        public void breakpointResolved(SpecEvent specEvent) {
            EventRequestSpec eventRequestSpec = specEvent.getEventRequestSpec();
            this.diagnostics.putString("Breakpoint resolved to " + eventRequestSpec.toString() + ".");
        }

        public void breakpointSet(SpecEvent specEvent) {
            EventRequestSpec eventRequestSpec = specEvent.getEventRequestSpec();
            this.diagnostics.putString("Breakpoint set at " + eventRequestSpec + ".");
        }

        public void classPrepare(ClassPrepareEventSet classPrepareEventSet) {
            if (CommandTool.this.context.getVerboseFlag()) {
                String string = classPrepareEventSet.getReferenceType().name();
                this.diagnostics.putString("Class " + string + " loaded");
            }
        }

        public void classUnload(ClassUnloadEventSet classUnloadEventSet) {
            if (CommandTool.this.context.getVerboseFlag()) {
                this.diagnostics.putString("Class " + classUnloadEventSet.getClassName() + " unloaded.");
            }
        }

        public void currentFrameChanged(CurrentFrameChangedEvent currentFrameChangedEvent) {
            ThreadReference threadReference = currentFrameChangedEvent.getThread();
            if (threadReference == CommandTool.this.context.getCurrentThread()) {
                CommandTool.this.script.setPrompt(CommandTool.this.promptString(threadReference, currentFrameChangedEvent.getIndex()));
            }
        }

        public void exception(ExceptionEventSet exceptionEventSet) {
            CommandTool.this.setThread(exceptionEventSet);
            String string = exceptionEventSet.getException().referenceType().name();
            this.diagnostics.putString("Exception: " + string);
        }

        public void exceptionInterceptDeferred(SpecEvent specEvent) {
        }

        public void exceptionInterceptDeleted(SpecEvent specEvent) {
        }

        public void exceptionInterceptError(SpecErrorEvent specErrorEvent) {
        }

        public void exceptionInterceptResolved(SpecEvent specEvent) {
        }

        public void exceptionInterceptSet(SpecEvent specEvent) {
        }

        public void locationTrigger(LocationTriggerEventSet locationTriggerEventSet) {
            String string = CommandTool.this.locationString(locationTriggerEventSet);
            CommandTool.this.setThread(locationTriggerEventSet);
            EventIterator eventIterator = locationTriggerEventSet.eventIterator();
            while (eventIterator.hasNext()) {
                Event event = eventIterator.nextEvent();
                if (event instanceof BreakpointEvent) {
                    this.diagnostics.putString("Breakpoint hit: " + string);
                    continue;
                }
                if (event instanceof StepEvent) {
                    this.diagnostics.putString("Step completed: " + string);
                    continue;
                }
                if (event instanceof MethodEntryEvent) {
                    this.diagnostics.putString("Method entered: " + string);
                    continue;
                }
                if (event instanceof MethodExitEvent) {
                    this.diagnostics.putString("Method exited: " + string);
                    continue;
                }
                this.diagnostics.putString("UNKNOWN event: " + locationTriggerEventSet);
            }
        }

        public void modificationWatchpoint(ModificationWatchpointEventSet modificationWatchpointEventSet) {
            CommandTool.this.setThread(modificationWatchpointEventSet);
            EventIterator eventIterator = modificationWatchpointEventSet.eventIterator();
            while (eventIterator.hasNext()) {
                Event event = eventIterator.nextEvent();
                this.diagnostics.putString("Watchpoint hit: " + CommandTool.this.locationString(modificationWatchpointEventSet));
            }
        }

        public void sessionContinue(EventObject eventObject) {
            this.diagnostics.putString("Execution resumed.");
            CommandTool.this.script.setPrompt(CommandTool.DEFAULT_CMD_PROMPT);
        }

        public void sessionInterrupt(EventObject eventObject) {
            Thread.yield();
            this.diagnostics.putString("VM interrupted by user.");
            CommandTool.this.script.setPrompt(CommandTool.DEFAULT_CMD_PROMPT);
        }

        public void sessionStart(EventObject eventObject) {
        }

        public void threadDeath(ThreadDeathEventSet threadDeathEventSet) {
            if (CommandTool.this.context.getVerboseFlag()) {
                this.diagnostics.putString("Thread " + threadDeathEventSet.getThread() + " ended.");
            }
        }

        public void threadStart(ThreadStartEventSet threadStartEventSet) {
            if (CommandTool.this.context.getVerboseFlag()) {
                this.diagnostics.putString("Thread " + threadStartEventSet.getThread() + " started.");
            }
        }

        public void vmDeath(VMDeathEventSet vMDeathEventSet) {
            CommandTool.this.script.setPrompt(CommandTool.DEFAULT_CMD_PROMPT);
            this.diagnostics.putString("VM exited");
        }

        public void vmDisconnect(VMDisconnectEventSet vMDisconnectEventSet) {
            CommandTool.this.script.setPrompt(CommandTool.DEFAULT_CMD_PROMPT);
            this.diagnostics.putString("Disconnected from VM");
        }

        public void vmStart(VMStartEventSet vMStartEventSet) {
            CommandTool.this.script.setPrompt(CommandTool.DEFAULT_CMD_PROMPT);
            this.diagnostics.putString("VM started");
        }

        public void watchpointDeferred(SpecEvent specEvent) {
        }

        public void watchpointDeleted(SpecEvent specEvent) {
        }

        public void watchpointError(SpecErrorEvent specErrorEvent) {
        }

        public void watchpointResolved(SpecEvent specEvent) {
        }

        public void watchpointSet(SpecEvent specEvent) {
        }
    }
}

