/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.gui.ApplicationTool;
import com.sun.tools.example.debug.gui.ClassTreeTool;
import com.sun.tools.example.debug.gui.CommandTool;
import com.sun.tools.example.debug.gui.ContextManager;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.JDBMenuBar;
import com.sun.tools.example.debug.gui.JDBToolBar;
import com.sun.tools.example.debug.gui.MonitorTool;
import com.sun.tools.example.debug.gui.SearchPath;
import com.sun.tools.example.debug.gui.SourceTool;
import com.sun.tools.example.debug.gui.SourceTreeTool;
import com.sun.tools.example.debug.gui.StackTraceTool;
import com.sun.tools.example.debug.gui.ThreadTreeTool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class GUI
extends JPanel {
    private CommandTool cmdTool;
    private ApplicationTool appTool;
    public static SourceTool srcTool;
    private SourceTreeTool sourceTreeTool;
    private ClassTreeTool classTreeTool;
    private ThreadTreeTool threadTreeTool;
    private StackTraceTool stackTool;
    private MonitorTool monitorTool;
    public static final String progname = "javadt";
    public static final String version = "1.0Beta";
    public static final String windowBanner = "Java(tm) platform Debug Tool";
    private Font fixedFont = new Font("monospaced", 0, 10);

    private GUI(Environment environment) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add((Component)new JDBToolBar(environment), "North");
        srcTool = new SourceTool(environment);
        srcTool.setPreferredSize(new Dimension(500, 300));
        srcTool.setTextFont(this.fixedFont);
        this.stackTool = new StackTraceTool(environment);
        this.stackTool.setPreferredSize(new Dimension(500, 100));
        this.monitorTool = new MonitorTool(environment);
        this.monitorTool.setPreferredSize(new Dimension(500, 50));
        JSplitPane jSplitPane = new JSplitPane(0, srcTool, new JSplitPane(0, this.stackTool, this.monitorTool));
        this.sourceTreeTool = new SourceTreeTool(environment);
        this.sourceTreeTool.setPreferredSize(new Dimension(200, 450));
        this.classTreeTool = new ClassTreeTool(environment);
        this.classTreeTool.setPreferredSize(new Dimension(200, 450));
        this.threadTreeTool = new ThreadTreeTool(environment);
        this.threadTreeTool.setPreferredSize(new Dimension(200, 450));
        JTabbedPane jTabbedPane = new JTabbedPane(3);
        jTabbedPane.addTab("Source", null, this.sourceTreeTool);
        jTabbedPane.addTab("Classes", null, this.classTreeTool);
        jTabbedPane.addTab("Threads", null, this.threadTreeTool);
        JSplitPane jSplitPane2 = new JSplitPane(1, jTabbedPane, jSplitPane);
        this.cmdTool = new CommandTool(environment);
        this.cmdTool.setPreferredSize(new Dimension(700, 150));
        this.appTool = new ApplicationTool(environment);
        this.appTool.setPreferredSize(new Dimension(700, 200));
        JSplitPane jSplitPane3 = new JSplitPane(0, this.cmdTool, this.appTool);
        JSplitPane jSplitPane4 = new JSplitPane(0, jSplitPane2, jSplitPane3);
        this.add((Component)jSplitPane4, "Center");
    }

    public static void main(String[] stringArray) {
        Object object;
        Object var1_1 = null;
        Object object2 = "";
        String string = "";
        String string2 = "";
        boolean bl = false;
        final Environment environment = new Environment();
        GUI gUI = new GUI(environment);
        ContextManager contextManager = environment.getContextManager();
        ExecutionManager executionManager = environment.getExecutionManager();
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n];
            if (((String)object).equals("-dbgtrace")) {
                if (n == stringArray.length - 1 || !Character.isDigit(stringArray[n + 1].charAt(0))) {
                    executionManager.setTraceMode(0xFFFFFF);
                } else {
                    String string3 = stringArray[++n];
                    executionManager.setTraceMode(Integer.decode(string3));
                }
            } else if (((String)object).equals("-X")) {
                System.out.println("Use 'java -X' to see the available non-standard options");
                System.out.println();
                GUI.usage();
                System.exit(1);
            } else if (((String)object).equals("-v") || ((String)object).startsWith("-v:") || ((String)object).startsWith("-verbose") || ((String)object).startsWith("-D") || ((String)object).startsWith("-X") || ((String)object).equals("-noasyncgc") || ((String)object).equals("-prof") || ((String)object).equals("-verify") || ((String)object).equals("-noverify") || ((String)object).equals("-verifyremote") || ((String)object).equals("-verbosegc") || ((String)object).startsWith("-ms") || ((String)object).startsWith("-mx") || ((String)object).startsWith("-ss") || ((String)object).startsWith("-oss")) {
                string2 = String.valueOf(string2) + (String)object + " ";
            } else if (((String)object).equals("-sourcepath")) {
                if (n == stringArray.length - 1) {
                    System.out.println("No sourcepath specified.");
                    GUI.usage();
                    System.exit(1);
                }
                environment.getSourceManager().setSourcePath(new SearchPath(stringArray[++n]));
            } else if (((String)object).equals("-classpath")) {
                if (n == stringArray.length - 1) {
                    System.out.println("No classpath specified.");
                    GUI.usage();
                    System.exit(1);
                }
                environment.getClassManager().setClassPath(new SearchPath(stringArray[++n]));
            } else if (((String)object).equals("-remote")) {
                if (n == stringArray.length - 1) {
                    System.out.println("No remote specified.");
                    GUI.usage();
                    System.exit(1);
                }
                environment.getContextManager().setRemotePort(stringArray[++n]);
            } else if (((String)object).equals("-help")) {
                GUI.usage();
                System.exit(0);
            } else if (((String)object).equals("-version")) {
                System.out.println("javadt version 1.0Beta");
                System.exit(0);
            } else {
                if (!((String)object).startsWith("-")) {
                    object2 = object;
                    ++n;
                    while (n < stringArray.length) {
                        string = String.valueOf(string) + stringArray[n] + " ";
                        ++n;
                    }
                    break;
                }
                System.out.println("invalid option: " + (String)object);
                GUI.usage();
                System.exit(1);
            }
            ++n;
        }
        contextManager.setMainClassName((String)object2);
        contextManager.setProgramArguments(string);
        contextManager.setVmArguments(string2);
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Error loading L&F: " + exception);
        }
        object = new JFrame();
        ((Component)object).setBackground(Color.lightGray);
        ((Frame)object).setTitle(windowBanner);
        ((JFrame)object).setJMenuBar(new JDBMenuBar(environment));
        ((JFrame)object).setContentPane(gUI);
        ((Window)object).addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                environment.terminate();
            }
        });
        ((Window)object).pack();
        ((Window)object).show();
    }

    private static void usage() {
        String string = File.pathSeparator;
        System.out.println("Usage: javadt <options> <class> <arguments>");
        System.out.println();
        System.out.println("where options include:");
        System.out.println("    -help             print out this message and exit");
        System.out.println("    -sourcepath <directories separated by \"" + string + "\">");
        System.out.println("                      list directories in which to look for source files");
        System.out.println("    -remote <hostname>:<port-number>");
        System.out.println("                      host machine and port number of interpreter to attach to");
        System.out.println("    -dbgtrace [flags] print info for debugging javadt");
        System.out.println();
        System.out.println("options forwarded to debuggee process:");
        System.out.println("    -v -verbose[:class|gc|jni]");
        System.out.println("                      turn on verbose mode");
        System.out.println("    -D<name>=<value>  set a system property");
        System.out.println("    -classpath <directories separated by \"" + string + "\">");
        System.out.println("                      list directories in which to look for classes");
        System.out.println("    -X<option>        non-standard debuggee VM option");
        System.out.println();
        System.out.println("<class> is the name of the class to begin debugging");
        System.out.println("<arguments> are the arguments passed to the main() method of <class>");
        System.out.println();
        System.out.println("For command help type 'help' at javadt prompt");
    }
}

