/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.gui.ClassManager;
import com.sun.tools.example.debug.gui.CommandInterpreter;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.SourceManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JToolBar;

class JDBToolBar
extends JToolBar {
    Environment env;
    ExecutionManager runtime;
    ClassManager classManager;
    SourceManager sourceManager;
    CommandInterpreter interpreter;

    JDBToolBar(Environment environment) {
        this.env = environment;
        this.runtime = environment.getExecutionManager();
        this.classManager = environment.getClassManager();
        this.sourceManager = environment.getSourceManager();
        this.interpreter = new CommandInterpreter(environment, true);
        this.addTool("Run application", "run", "run");
        this.addTool("Connect to application", "connect", "connect");
        this.addSeparator();
        this.addTool("Step into next line", "step", "step");
        this.addTool("Step over next line", "next", "next");
        this.addTool("Step out of current method call", "step up", "step up");
        this.addSeparator();
        this.addTool("Suspend execution", "interrupt", "interrupt");
        this.addTool("Continue execution", "cont", "cont");
        this.addSeparator();
        this.addTool("Move up one stack frame", "up", "up");
        this.addTool("Move down one stack frame", "down", "down");
    }

    private void addTool(String string, String string2, String string3) {
        JButton jButton = new JButton(string2);
        jButton.setToolTipText(string);
        final String string4 = string3;
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                interpreter.executeCommand(string4);
            }
        });
        this.add(jButton);
    }
}

