/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.Connector;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.VMLaunchFailureException;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

class LaunchTool {
    private final ExecutionManager runtime;

    private LaunchTool(ExecutionManager executionManager) {
        this.runtime = executionManager;
    }

    private void configureAndConnect(final Connector connector) {
        Object object;
        final JDialog jDialog = new JDialog();
        final Map map = connector.defaultArguments();
        jDialog.setModal(true);
        jDialog.setTitle("Connector Arguments");
        Container container = jDialog.getContentPane();
        JPanel jPanel = new JPanel();
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, connector.description(), 1, 2);
        jPanel.setBorder(border);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        final ArrayList<BooleanArgRep> arrayList = new ArrayList<BooleanArgRep>(map.size());
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            ArgRep argRep = object instanceof Connector.BooleanArgument ? new BooleanArgRep((Connector.BooleanArgument)object, jPanel) : new StringArgRep((Connector.Argument)object, jPanel);
            arrayList.add((BooleanArgRep)argRep);
        }
        container.add(jPanel);
        object = this.okCancel(jDialog, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ArgRep argRep = (ArgRep)iterator.next();
                    if (!argRep.isSpecified()) {
                        JOptionPane.showMessageDialog(jDialog, String.valueOf(argRep.arg.label()) + ": Argument must be specified", "No argument", 0);
                        return;
                    }
                    if (!argRep.isValid()) {
                        JOptionPane.showMessageDialog(jDialog, String.valueOf(argRep.arg.label()) + ": Bad argument value: " + argRep.getText(), "Bad argument", 0);
                        return;
                    }
                    argRep.install();
                }
                try {
                    if (runtime.explictStart(connector, map)) {
                        ((Component)jDialog).setVisible(false);
                        jDialog.dispose();
                    } else {
                        JOptionPane.showMessageDialog(jDialog, "Bad arguments values: See diagnostics window.", "Bad arguments", 0);
                    }
                }
                catch (VMLaunchFailureException vMLaunchFailureException) {
                    JOptionPane.showMessageDialog(jDialog, "Launch Failure: " + vMLaunchFailureException, "Launch Failed", 0);
                }
            }
        });
        container.add("South", (Component)object);
        jDialog.pack();
        jDialog.show();
    }

    private JPanel okCancel(final JDialog jDialog, ActionListener actionListener) {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("OK");
        JButton jButton2 = new JButton("Cancel");
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jButton.addActionListener(actionListener);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)jDialog).setVisible(false);
                jDialog.dispose();
            }
        });
        return jPanel;
    }

    static void queryAndLaunchVM(ExecutionManager executionManager) throws VMLaunchFailureException {
        LaunchTool launchTool = new LaunchTool(executionManager);
        Connector connector = launchTool.selectConnector();
        if (connector != null) {
            launchTool.configureAndConnect(connector);
        }
    }

    private Connector selectConnector() {
        JComponent jComponent;
        Object object;
        final JDialog jDialog = new JDialog();
        Container container = jDialog.getContentPane();
        JPanel jPanel = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        VirtualMachineManager virtualMachineManager = Bootstrap.virtualMachineManager();
        List list = virtualMachineManager.allConnectors();
        HashMap<ButtonModel, Object> hashMap = new HashMap<ButtonModel, Object>(list.size(), 0.5f);
        jDialog.setModal(true);
        jDialog.setTitle("Select Connector Type");
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (Connector)iterator.next();
            jComponent = new JRadioButton(object.description());
            hashMap.put(jComponent.getModel(), object);
            jPanel.add(jComponent);
            buttonGroup.add((AbstractButton)jComponent);
        }
        container.add(jPanel);
        object = new boolean[1];
        jComponent = this.okCancel(jDialog, new ActionListener((boolean[])object, buttonGroup){
            private final /* synthetic */ boolean[] val$oked;
            private final /* synthetic */ ButtonGroup val$radioGroup;
            {
                this.val$oked = blArray;
                this.val$radioGroup = buttonGroup;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (this.val$radioGroup.getSelection() == null) {
                    JOptionPane.showMessageDialog(jDialog, "Please select a connector type", "No Selection", 0);
                } else {
                    this.val$oked[0] = true;
                    ((Component)jDialog).setVisible(false);
                    jDialog.dispose();
                }
            }
        });
        container.add("South", jComponent);
        jDialog.pack();
        jDialog.show();
        return object[0] != false ? (Connector)hashMap.get(buttonGroup.getSelection()) : null;
    }

    private abstract class ArgRep {
        final Connector.Argument arg;
        final JPanel panel;

        ArgRep(Connector.Argument argument) {
            this.arg = argument;
            this.panel = new JPanel();
            Border border = BorderFactory.createEtchedBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, argument.description(), 1, 2);
            this.panel.setBorder(titledBorder);
        }

        abstract String getText();

        void install() {
            this.arg.setValue(this.getText());
        }

        boolean isSpecified() {
            String string = this.getText();
            return string != null && string.length() > 0 || !this.arg.mustSpecify();
        }

        boolean isValid() {
            return this.arg.isValid(this.getText());
        }
    }

    private class StringArgRep
    extends ArgRep {
        final JTextField textField;

        StringArgRep(Connector.Argument argument, JPanel jPanel) {
            super(argument);
            this.textField = new JTextField(argument.value(), 50);
            this.textField.setBorder(BorderFactory.createLoweredBevelBorder());
            this.panel.add(new JLabel(argument.label(), 4));
            this.panel.add(this.textField);
            jPanel.add(this.panel);
        }

        String getText() {
            return this.textField.getText();
        }
    }

    private class BooleanArgRep
    extends ArgRep {
        final JCheckBox check;

        BooleanArgRep(Connector.BooleanArgument booleanArgument, JPanel jPanel) {
            super(booleanArgument);
            this.check = new JCheckBox(booleanArgument.label());
            this.check.setSelected(booleanArgument.booleanValue());
            this.panel.add(this.check);
            jPanel.add(this.panel);
        }

        String getText() {
            return ((Connector.BooleanArgument)this.arg).stringValueOf(this.check.getModel().isSelected());
        }
    }
}

