/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.tools.example.debug.gui.ContextListener;
import com.sun.tools.example.debug.gui.CurrentFrameChangedEvent;
import com.sun.tools.example.debug.gui.Environment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;

public class MonitorListModel
extends AbstractListModel {
    private final List monitors = new ArrayList();

    MonitorListModel(Environment environment) {
        MonitorListListener monitorListListener = new MonitorListListener();
        environment.getContextManager().addContextListener(monitorListListener);
    }

    public void add(String string) {
        this.monitors.add(string);
        int n = this.monitors.size() - 1;
        this.fireIntervalAdded(this, n, n);
    }

    public Object getElementAt(int n) {
        return this.monitors.get(n);
    }

    public int getSize() {
        return this.monitors.size();
    }

    private void invalidate() {
        this.fireContentsChanged(this, 0, this.monitors.size() - 1);
    }

    public Iterator iterator() {
        return this.monitors().iterator();
    }

    public List monitors() {
        return Collections.unmodifiableList(this.monitors);
    }

    public void remove(int n) {
        this.monitors.remove(n);
        this.fireIntervalRemoved(this, n, n);
    }

    public void remove(String string) {
        int n = this.monitors.indexOf(string);
        this.remove(n);
    }

    private class MonitorListListener
    implements ContextListener {
        MonitorListListener() {
        }

        public void currentFrameChanged(CurrentFrameChangedEvent currentFrameChangedEvent) {
            MonitorListModel.this.invalidate();
        }
    }
}

