/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class SearchPath {
    private String pathString;
    private String[] pathArray;

    public SearchPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        this.pathString = string;
        this.pathArray = arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] asArray() {
        return (String[])this.pathArray.clone();
    }

    public String asString() {
        return this.pathString;
    }

    public String[] children(String string, FilenameFilter filenameFilter) {
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = 0;
        while (n < this.pathArray.length) {
            String[] stringArray;
            File file = new File(this.pathArray[n], string);
            if (file.exists() && (stringArray = file.list(filenameFilter)) != null) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (!treeSet.contains(stringArray[n2])) {
                        treeSet.add(stringArray[n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public boolean isEmpty() {
        return this.pathArray.length == 0;
    }

    public File resolve(String string) {
        int n = 0;
        while (n < this.pathArray.length) {
            File file = new File(this.pathArray[n], string);
            if (file.exists()) {
                return file;
            }
            ++n;
        }
        return null;
    }
}

