/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.tools.example.debug.event.ClassPrepareEventSet;
import com.sun.tools.example.debug.event.ClassUnloadEventSet;
import com.sun.tools.example.debug.event.JDIAdapter;
import com.sun.tools.example.debug.event.JDIListener;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.SearchPath;
import com.sun.tools.example.debug.gui.SourceListener;
import com.sun.tools.example.debug.gui.SourceModel;
import com.sun.tools.example.debug.gui.SourcepathChangedEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class SourceManager {
    private List sourceList;
    private SearchPath sourcePath;
    private Vector sourceListeners = new Vector();
    private Map classToSource = new HashMap();
    private Environment env;
    private SMClassListener classListener = new SMClassListener();

    public SourceManager(Environment environment) {
        this(environment, new SearchPath(""));
    }

    public SourceManager(Environment environment, SearchPath searchPath) {
        this.env = environment;
        this.sourceList = new LinkedList();
        this.sourcePath = searchPath;
        environment.getExecutionManager().addJDIListener(this.classListener);
    }

    public void addSourceListener(SourceListener sourceListener) {
        this.sourceListeners.addElement(sourceListener);
    }

    public SearchPath getSourcePath() {
        return this.sourcePath;
    }

    private void notifySourcepathChanged() {
        Vector vector = (Vector)this.sourceListeners.clone();
        SourcepathChangedEvent sourcepathChangedEvent = new SourcepathChangedEvent(this);
        int n = 0;
        while (n < vector.size()) {
            ((SourceListener)vector.elementAt(n)).sourcepathChanged(sourcepathChangedEvent);
            ++n;
        }
    }

    public void removeSourceListener(SourceListener sourceListener) {
        this.sourceListeners.removeElement(sourceListener);
    }

    public void setSourcePath(SearchPath searchPath) {
        this.sourcePath = searchPath;
        this.sourceList = new LinkedList();
        this.notifySourcepathChanged();
        this.classToSource = new HashMap();
    }

    public SourceModel sourceForClass(ReferenceType referenceType) {
        SourceModel sourceModel = (SourceModel)this.classToSource.get(referenceType);
        if (sourceModel != null) {
            return sourceModel;
        }
        try {
            String string = referenceType.sourceName();
            String string2 = referenceType.name();
            int n = string2.lastIndexOf(46);
            String string3 = n >= 0 ? string2.substring(0, n + 1) : "";
            String string4 = String.valueOf(string3.replace('.', File.separatorChar)) + string;
            File file = this.sourcePath.resolve(string4);
            if (file != null) {
                sourceModel = this.sourceForFile(file);
                this.classToSource.put(referenceType, sourceModel);
                return sourceModel;
            }
            return null;
        }
        catch (AbsentInformationException absentInformationException) {
            return null;
        }
    }

    public SourceModel sourceForFile(File file) {
        Iterator iterator = this.sourceList.iterator();
        SourceModel sourceModel = null;
        while (iterator.hasNext()) {
            SourceModel sourceModel2 = (SourceModel)iterator.next();
            if (!sourceModel2.fileName().equals(file)) continue;
            sourceModel = sourceModel2;
            iterator.remove();
            break;
        }
        if (sourceModel == null && file.exists()) {
            sourceModel = new SourceModel(this.env, file);
        }
        if (sourceModel != null) {
            this.sourceList.add(0, sourceModel);
        }
        return sourceModel;
    }

    public SourceModel sourceForLocation(Location location) {
        return this.sourceForClass(location.declaringType());
    }

    private class SMClassListener
    extends JDIAdapter
    implements JDIListener {
        SMClassListener() {
        }

        public void classPrepare(ClassPrepareEventSet classPrepareEventSet) {
            ReferenceType referenceType = classPrepareEventSet.getReferenceType();
            SourceModel sourceModel = SourceManager.this.sourceForClass(referenceType);
            if (sourceModel != null) {
                sourceModel.addClass(referenceType);
            }
        }

        public void classUnload(ClassUnloadEventSet classUnloadEventSet) {
        }
    }
}

