/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.tools.example.debug.gui.Environment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;

public class SourceModel
extends AbstractListModel {
    private File path;
    boolean isActuallySource = true;
    private List classes = new ArrayList();
    private Environment env;
    private List sourceLines = null;
    public static final Line prototypeCellValue = new Line("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890~!@#$%^&*()_+{}|:<>?`-=[];',.XXXXXXXXXXXX/\\\"");

    SourceModel(Environment environment, File file) {
        this.env = environment;
        this.path = file;
    }

    public SourceModel(String string) {
        this.path = null;
        this.setMessage(string);
    }

    void addClass(ReferenceType referenceType) {
        if (this.classes.indexOf(referenceType) == -1) {
            this.classes.add(referenceType);
            if (this.sourceLines != null) {
                this.markClassLines(referenceType);
            }
        }
    }

    private String expandTabs(String string) {
        int n = 0;
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(132);
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            stringBuffer.append(c);
            if (c == '\t') {
                int n4 = 8 - n % 8;
                int n5 = 0;
                while (n5 < n4) {
                    stringBuffer.append(' ');
                    ++n5;
                }
                n += n4;
            } else {
                ++n;
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public File fileName() {
        return this.path;
    }

    public Object getElementAt(int n) {
        if (this.sourceLines == null) {
            this.initialize();
        }
        return this.sourceLines.get(n);
    }

    public int getSize() {
        if (this.sourceLines == null) {
            this.initialize();
        }
        return this.sourceLines.size();
    }

    private void initialize() {
        try {
            this.rawInit();
        }
        catch (IOException iOException) {
            this.setMessage("[Error reading source code]");
        }
    }

    public Line line(int n) {
        int n2;
        if (this.sourceLines == null) {
            this.initialize();
        }
        if ((n2 = n - 1) >= this.sourceLines.size() || n2 < 0) {
            return null;
        }
        return (Line)this.sourceLines.get(n2);
    }

    private void markClassLines(ReferenceType referenceType) {
        Location location;
        Object object;
        Object object2;
        Object object3;
        List list = referenceType.methods();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object3 = (Method)iterator.next();
            try {
                object2 = object3.allLineLocations();
                object = object2.iterator();
                while (object.hasNext()) {
                    location = (Location)object.next();
                    this.showExecutable(location.lineNumber(), referenceType);
                }
            }
            catch (AbsentInformationException absentInformationException) {}
        }
        object3 = this.env.getExecutionManager().eventRequestManager().breakpointRequests();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (BreakpointRequest)object2.next();
            if (object.location() == null || !(location = object.location()).declaringType().equals(referenceType)) continue;
            this.showBreakpoint(location.lineNumber(), true);
        }
    }

    private void rawInit() throws IOException {
        this.sourceLines = new ArrayList();
        BufferedReader bufferedReader = this.sourceReader();
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                this.sourceLines.add(new Line(this.expandTabs(string)));
                string = bufferedReader.readLine();
            }
        }
        finally {
            Object var3_3 = null;
            bufferedReader.close();
        }
        Iterator iterator = this.classes.iterator();
        while (iterator.hasNext()) {
            this.markClassLines((ClassType)iterator.next());
        }
    }

    public List referenceTypes() {
        return Collections.unmodifiableList(this.classes);
    }

    private void setMessage(String string) {
        this.isActuallySource = false;
        this.sourceLines = new ArrayList();
        this.sourceLines.add(new Line(string));
    }

    public void showBreakpoint(int n, boolean bl) {
        this.line((int)n).hasBreakpoint = bl;
        this.fireContentsChanged(this, n, n);
    }

    public void showExecutable(int n, ReferenceType referenceType) {
        this.line((int)n).refType = referenceType;
        this.fireContentsChanged(this, n, n);
    }

    public String sourceLine(int n) {
        Line line = this.line(n);
        if (line == null) {
            return null;
        }
        return line.text;
    }

    public BufferedReader sourceReader() throws IOException {
        return new BufferedReader(new FileReader(this.path));
    }

    public static class Line {
        public String text;
        public boolean hasBreakpoint = false;
        public ReferenceType refType = null;

        Line(String string) {
            this.text = string;
        }

        public boolean hasBreakpoint() {
            return this.hasBreakpoint;
        }

        public boolean isExecutable() {
            return this.refType != null;
        }
    }
}

