/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.SpecErrorEvent;
import com.sun.tools.example.debug.bdi.SpecEvent;
import com.sun.tools.example.debug.bdi.SpecListener;
import com.sun.tools.example.debug.gui.CommandInterpreter;
import com.sun.tools.example.debug.gui.ContextListener;
import com.sun.tools.example.debug.gui.ContextManager;
import com.sun.tools.example.debug.gui.CurrentFrameChangedEvent;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.Icons;
import com.sun.tools.example.debug.gui.SearchPath;
import com.sun.tools.example.debug.gui.SourceListener;
import com.sun.tools.example.debug.gui.SourceManager;
import com.sun.tools.example.debug.gui.SourceModel;
import com.sun.tools.example.debug.gui.SourcepathChangedEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class SourceTool
extends JPanel {
    private Environment env;
    private ExecutionManager runtime;
    private ContextManager context;
    private SourceManager sourceManager;
    private JList list;
    private ListModel sourceModel;
    private String sourceName;
    private Location sourceLocn;
    private CommandInterpreter interpreter;

    public SourceTool(Environment environment) {
        super(new BorderLayout());
        this.env = environment;
        this.runtime = environment.getExecutionManager();
        this.sourceManager = environment.getSourceManager();
        this.context = environment.getContextManager();
        this.interpreter = new CommandInterpreter(environment, true);
        this.sourceModel = new DefaultListModel();
        this.list = new JList(this.sourceModel);
        this.list.setCellRenderer(new SourceLineRenderer());
        this.list.setPrototypeCellValue(SourceModel.prototypeCellValue);
        SourceToolListener sourceToolListener = new SourceToolListener();
        this.context.addContextListener(sourceToolListener);
        this.runtime.addSpecListener(sourceToolListener);
        this.sourceManager.addSourceListener(sourceToolListener);
        STMouseListener sTMouseListener = new STMouseListener();
        this.list.addMouseListener(sTMouseListener);
        this.add(new JScrollPane(this.list));
    }

    static /* synthetic */ CommandInterpreter access$4(SourceTool sourceTool) {
        return sourceTool.interpreter;
    }

    public void setTextFont(Font font) {
        this.list.setFont(font);
        this.list.setPrototypeCellValue(SourceModel.prototypeCellValue);
    }

    private void setViewModel(SourceModel sourceModel) {
        if (sourceModel != this.sourceModel) {
            this.list.setModel(sourceModel);
            this.sourceModel = sourceModel;
        }
    }

    private void showSource(SourceModel sourceModel) {
        this.setViewModel(sourceModel);
    }

    private void showSourceAtLine(SourceModel sourceModel, int n) {
        this.setViewModel(sourceModel);
        if (sourceModel.isActuallySource && n < sourceModel.getSize()) {
            this.list.setSelectedIndex(n);
            if (n + 4 < sourceModel.getSize()) {
                this.list.ensureIndexIsVisible(n + 4);
            }
            this.list.ensureIndexIsVisible(n);
        }
    }

    private void showSourceContext(ThreadReference threadReference, int n) {
        StackFrame stackFrame = null;
        if (threadReference != null && n > 0) {
            try {
                stackFrame = threadReference.frame(n);
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {}
        }
        if (stackFrame == null) {
            return;
        }
        Location location = stackFrame.location();
        this.showSourceForLocation(location);
    }

    public boolean showSourceFile(String string) {
        File file;
        Object object;
        this.sourceLocn = null;
        if (!string.startsWith(File.separator)) {
            this.sourceName = string;
            object = this.sourceManager.getSourcePath();
            file = ((SearchPath)object).resolve(string);
            if (file == null) {
                this.showSourceUnavailable();
                return false;
            }
        } else {
            this.sourceName = null;
            file = new File(string);
        }
        if ((object = this.sourceManager.sourceForFile(file)) != null) {
            this.showSource((SourceModel)object);
            return true;
        }
        this.showSourceUnavailable();
        return false;
    }

    public boolean showSourceForLocation(Location location) {
        SourceModel sourceModel;
        this.sourceName = null;
        this.sourceLocn = location;
        int n = location.lineNumber();
        if (n != -1 && (sourceModel = this.sourceManager.sourceForLocation(location)) != null) {
            this.showSourceAtLine(sourceModel, n - 1);
            return true;
        }
        this.showSourceUnavailable();
        return false;
    }

    private void showSourceUnavailable() {
        SourceModel sourceModel = new SourceModel("[Source code is not available]");
        this.setViewModel(sourceModel);
    }

    private class SourceToolListener
    implements ContextListener,
    SourceListener,
    SpecListener {
        SourceToolListener() {
        }

        public void breakpointDeferred(SpecEvent specEvent) {
        }

        public void breakpointDeleted(SpecEvent specEvent) {
            block2: {
                BreakpointRequest breakpointRequest = (BreakpointRequest)specEvent.getEventRequest();
                Location location = breakpointRequest.location();
                if (location == null) break block2;
                try {
                    SourceModel sourceModel = SourceTool.this.sourceManager.sourceForLocation(location);
                    sourceModel.showBreakpoint(location.lineNumber(), false);
                    SourceTool.this.showSourceForLocation(location);
                }
                catch (Exception exception) {}
            }
        }

        public void breakpointError(SpecErrorEvent specErrorEvent) {
            this.breakpointDeleted(specErrorEvent);
        }

        public void breakpointResolved(SpecEvent specEvent) {
            BreakpointRequest breakpointRequest = (BreakpointRequest)specEvent.getEventRequest();
            Location location = breakpointRequest.location();
            try {
                SourceModel sourceModel = SourceTool.this.sourceManager.sourceForLocation(location);
                sourceModel.showBreakpoint(location.lineNumber(), true);
                SourceTool.this.showSourceForLocation(location);
            }
            catch (Exception exception) {}
        }

        public void breakpointSet(SpecEvent specEvent) {
            this.breakpointResolved(specEvent);
        }

        public void currentFrameChanged(CurrentFrameChangedEvent currentFrameChangedEvent) {
            SourceTool.this.showSourceContext(currentFrameChangedEvent.getThread(), currentFrameChangedEvent.getIndex());
        }

        public void exceptionInterceptDeferred(SpecEvent specEvent) {
        }

        public void exceptionInterceptDeleted(SpecEvent specEvent) {
        }

        public void exceptionInterceptError(SpecErrorEvent specErrorEvent) {
        }

        public void exceptionInterceptResolved(SpecEvent specEvent) {
        }

        public void exceptionInterceptSet(SpecEvent specEvent) {
        }

        public void sourcepathChanged(SourcepathChangedEvent sourcepathChangedEvent) {
            if (SourceTool.this.sourceName != null) {
                SourceTool.this.showSourceFile(SourceTool.this.sourceName);
            } else if (SourceTool.this.sourceLocn != null) {
                SourceTool.this.showSourceForLocation(SourceTool.this.sourceLocn);
            }
        }

        public void watchpointDeferred(SpecEvent specEvent) {
        }

        public void watchpointDeleted(SpecEvent specEvent) {
        }

        public void watchpointError(SpecErrorEvent specErrorEvent) {
        }

        public void watchpointResolved(SpecEvent specEvent) {
        }

        public void watchpointSet(SpecEvent specEvent) {
        }
    }

    private class SourceLineRenderer
    extends DefaultListCellRenderer {
        SourceLineRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            SourceModel.Line line = (SourceModel.Line)object;
            this.setText(line.text);
            if (line.hasBreakpoint) {
                this.setIcon(Icons.stopSignIcon);
            } else if (line.isExecutable()) {
                this.setIcon(Icons.execIcon);
            } else {
                this.setIcon(Icons.blankIcon);
            }
            return this;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(dimension.width, dimension.height - 5);
        }
    }

    private class STMouseListener
    extends MouseAdapter
    implements MouseListener {
        STMouseListener() {
        }

        static /* synthetic */ SourceTool access$0(STMouseListener sTMouseListener) {
            return sTMouseListener.SourceTool.this;
        }

        private JMenuItem commandItem(String string, String string2) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(new ActionListener(string2, this){
                private final /* synthetic */ String val$cmd;
                private final /* synthetic */ STMouseListener this$1;
                {
                    this.val$cmd = string;
                    this.this$1 = sTMouseListener;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SourceTool.access$4(STMouseListener.access$0(this.this$1)).executeCommand(this.val$cmd);
                }
            });
            return jMenuItem;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void showPopupMenu(Component component, int n, int n2) {
            JList jList = (JList)component;
            int n3 = jList.getSelectedIndex() + 1;
            SourceModel.Line line = (SourceModel.Line)jList.getSelectedValue();
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (line == null) {
                jPopupMenu.add(new JMenuItem("please select a line"));
            } else if (line.isExecutable()) {
                String string = line.refType.name();
                if (line.hasBreakpoint()) {
                    jPopupMenu.add(this.commandItem("Clear Breakpoint", "clear " + string + ":" + n3));
                } else {
                    jPopupMenu.add(this.commandItem("Set Breakpoint", "stop at " + string + ":" + n3));
                }
            } else {
                jPopupMenu.add(new JMenuItem("not an executable line"));
            }
            jPopupMenu.show(component, n + jPopupMenu.getWidth() / 2, n2 + jPopupMenu.getHeight() / 2);
        }
    }
}

