/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.gui.ClassManager;
import com.sun.tools.example.debug.gui.CommandInterpreter;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.SearchPath;
import com.sun.tools.example.debug.gui.SingleLeafTreeSelectionModel;
import com.sun.tools.example.debug.gui.SourceListener;
import com.sun.tools.example.debug.gui.SourceManager;
import com.sun.tools.example.debug.gui.SourcepathChangedEvent;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SourceTreeTool
extends JPanel {
    private Environment env;
    private ExecutionManager runtime;
    private SourceManager sourceManager;
    private ClassManager classManager;
    private JTree tree;
    private SourceTreeNode root;
    private SearchPath sourcePath;
    private CommandInterpreter interpreter;
    private static String HEADING = "SOURCES";
    private static FilenameFilter filter = new SourceOrDirectoryFilter();

    public SourceTreeTool(Environment environment) {
        super(new BorderLayout());
        this.env = environment;
        this.runtime = environment.getExecutionManager();
        this.sourceManager = environment.getSourceManager();
        this.interpreter = new CommandInterpreter(environment);
        this.sourcePath = this.sourceManager.getSourcePath();
        this.root = this.createDirectoryTree(HEADING);
        this.tree = new JTree(new DefaultTreeModel(this.root));
        this.tree.setSelectionModel(new SingleLeafTreeSelectionModel());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SourceTreeNode sourceTreeNode;
                int n = SourceTreeTool.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = SourceTreeTool.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && mouseEvent.getClickCount() == 1 && (sourceTreeNode = (SourceTreeNode)treePath.getLastPathComponent()).isLeaf()) {
                    SourceTreeTool.this.tree.setSelectionPath(treePath);
                    SourceTreeTool.this.interpreter.executeCommand("view " + sourceTreeNode.getRelativePath());
                }
            }
        };
        this.tree.addMouseListener(mouseAdapter);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.add(jScrollPane);
        SourceTreeToolListener sourceTreeToolListener = new SourceTreeToolListener();
        this.sourceManager.addSourceListener(sourceTreeToolListener);
    }

    SourceTreeNode createDirectoryTree(String string) {
        try {
            class Com_sun_tools_example_debug_gui_SourceTreeTool$3 {
                /* synthetic */ Com_sun_tools_example_debug_gui_SourceTreeTool$3() {
                }
            }
            return new SourceTreeNode(null, string, null, "", true);
        }
        catch (SecurityException securityException) {
            this.env.failure("Cannot access source file or directory");
            return null;
        }
    }

    private class SourceTreeToolListener
    implements SourceListener {
        SourceTreeToolListener() {
        }

        public void sourcepathChanged(SourcepathChangedEvent sourcepathChangedEvent) {
            SourceTreeTool.this.sourcePath = SourceTreeTool.this.sourceManager.getSourcePath();
            SourceTreeTool.this.root = SourceTreeTool.this.createDirectoryTree(HEADING);
            SourceTreeTool.this.tree.setModel(new DefaultTreeModel(SourceTreeTool.this.root));
        }
    }

    private static class SourceOrDirectoryFilter
    implements FilenameFilter {
        SourceOrDirectoryFilter() {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".java") || new File(file, string).isDirectory();
        }
    }

    class SourceTreeNode
    implements TreeNode {
        private String name;
        private boolean isDirectory;
        private SourceTreeNode parent;
        private SourceTreeNode[] children;
        private String relativePath;
        private boolean isExpanded;

        /* synthetic */ SourceTreeNode(3 var2_2, String string, SourceTreeNode sourceTreeNode, String string2, boolean bl) {
            this(string, sourceTreeNode, string2, bl);
        }

        private SourceTreeNode(String string, SourceTreeNode sourceTreeNode, String string2, boolean bl) {
            this.name = string;
            this.relativePath = string2;
            this.parent = sourceTreeNode;
            this.isDirectory = bl;
        }

        static /* synthetic */ SourceTreeNode[] access$0(SourceTreeNode sourceTreeNode) {
            return sourceTreeNode.children;
        }

        public Enumeration children() {
            this.expandIfNeeded();
            return new Enumeration(this){
                private final /* synthetic */ SourceTreeNode this$1;
                int i;
                {
                    this.this$1 = sourceTreeNode;
                    this.i = 0;
                }

                public boolean hasMoreElements() {
                    return this.i < SourceTreeNode.access$0(this.this$1).length;
                }

                public Object nextElement() throws NoSuchElementException {
                    if (this.i >= SourceTreeNode.access$0(this.this$1).length) {
                        throw new NoSuchElementException();
                    }
                    return SourceTreeNode.access$0(this.this$1)[this.i++];
                }
            };
        }

        private void expandIfNeeded() {
            try {
                if (!this.isExpanded && this.isDirectory) {
                    String[] stringArray = SourceTreeTool.this.sourcePath.children(this.relativePath, filter);
                    this.children = new SourceTreeNode[stringArray.length];
                    int n = 0;
                    while (n < stringArray.length) {
                        String string = this.relativePath.equals("") ? stringArray[n] : String.valueOf(this.relativePath) + File.separator + stringArray[n];
                        File file = SourceTreeTool.this.sourcePath.resolve(string);
                        boolean bl = file != null && file.isDirectory();
                        this.children[n] = new SourceTreeNode(stringArray[n], this, string, bl);
                        ++n;
                    }
                }
                this.isExpanded = true;
            }
            catch (SecurityException securityException) {
                this.children = null;
                SourceTreeTool.this.env.failure("Cannot access source file or directory");
            }
        }

        public boolean getAllowsChildren() {
            return this.isDirectory;
        }

        public TreeNode getChildAt(int n) {
            this.expandIfNeeded();
            return this.children[n];
        }

        public int getChildCount() {
            this.expandIfNeeded();
            return this.children.length;
        }

        public int getIndex(TreeNode treeNode) {
            this.expandIfNeeded();
            int n = 0;
            while (n < this.children.length) {
                if (this.children[n] == treeNode) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public String getRelativePath() {
            return this.relativePath;
        }

        public boolean isLeaf() {
            this.expandIfNeeded();
            return this.isDirectory ^ true;
        }

        public String toString() {
            return this.name;
        }
    }
}

