/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.ThreadInfo;
import com.sun.tools.example.debug.bdi.VMNotInterruptedException;
import com.sun.tools.example.debug.gui.ContextListener;
import com.sun.tools.example.debug.gui.ContextManager;
import com.sun.tools.example.debug.gui.CurrentFrameChangedEvent;
import com.sun.tools.example.debug.gui.Environment;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StackTraceTool
extends JPanel {
    private Environment env;
    private ExecutionManager runtime;
    private ContextManager context;
    private ThreadInfo tinfo;
    private JList list;
    private ListModel stackModel;

    public StackTraceTool(Environment environment) {
        super(new BorderLayout());
        this.env = environment;
        this.runtime = environment.getExecutionManager();
        this.context = environment.getContextManager();
        this.stackModel = new DefaultListModel();
        this.list = new JList(this.stackModel);
        this.list.setCellRenderer(new StackFrameRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.list);
        this.add(jScrollPane);
        StackTraceToolListener stackTraceToolListener = new StackTraceToolListener();
        this.context.addContextListener(stackTraceToolListener);
        this.list.addListSelectionListener(stackTraceToolListener);
    }

    private void showStack(ThreadInfo threadInfo, int n) {
        StackTraceListModel stackTraceListModel = new StackTraceListModel(threadInfo);
        this.stackModel = stackTraceListModel;
        this.list.setModel(this.stackModel);
        this.list.setSelectedIndex(n);
        this.list.ensureIndexIsVisible(n);
    }

    private class StackTraceToolListener
    implements ContextListener,
    ListSelectionListener {
        StackTraceToolListener() {
        }

        public void currentFrameChanged(CurrentFrameChangedEvent currentFrameChangedEvent) {
            int n = currentFrameChangedEvent.getIndex();
            ThreadInfo threadInfo = currentFrameChangedEvent.getThreadInfo();
            if (currentFrameChangedEvent.getInvalidate() || StackTraceTool.this.tinfo != threadInfo) {
                StackTraceTool.this.tinfo = threadInfo;
                StackTraceTool.this.showStack(threadInfo, n);
            } else if (n < StackTraceTool.this.stackModel.getSize()) {
                StackTraceTool.this.list.setSelectedIndex(n);
                StackTraceTool.this.list.ensureIndexIsVisible(n);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            block2: {
                int n = StackTraceTool.this.list.getSelectedIndex();
                if (n == -1) break block2;
                try {
                    StackTraceTool.this.context.setCurrentFrameIndex(n);
                }
                catch (VMNotInterruptedException vMNotInterruptedException) {}
            }
        }
    }

    private class StackFrameRenderer
    extends DefaultListCellRenderer {
        StackFrameRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object == null) {
                this.setText("<unavailable>");
            } else {
                StackFrame stackFrame = (StackFrame)object;
                Location location = stackFrame.location();
                Method method = location.method();
                String string = String.valueOf(method.declaringType().name()) + '.' + method.name();
                String string2 = "";
                if (method instanceof Method && method.isNative()) {
                    string2 = " (native method)";
                } else if (location.lineNumber() != -1) {
                    string2 = ":" + location.lineNumber();
                } else {
                    long l = location.codeIndex();
                    if (l != -1L) {
                        string2 = ", pc = " + l;
                    }
                }
                this.setText("[" + (n + 1) + "] " + string + string2);
            }
            return this;
        }
    }

    private static class StackTraceListModel
    extends AbstractListModel {
        private final ThreadInfo tinfo;

        public StackTraceListModel(ThreadInfo threadInfo) {
            this.tinfo = threadInfo;
        }

        public Object getElementAt(int n) {
            try {
                return this.tinfo == null ? null : this.tinfo.getFrame(n);
            }
            catch (VMNotInterruptedException vMNotInterruptedException) {
                return null;
            }
        }

        public int getSize() {
            try {
                return this.tinfo == null ? 1 : this.tinfo.getFrameCount();
            }
            catch (VMNotInterruptedException vMNotInterruptedException) {
                return 0;
            }
        }
    }
}

