/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.NoSessionException;
import com.sun.tools.example.debug.bdi.SessionListener;
import com.sun.tools.example.debug.event.JDIAdapter;
import com.sun.tools.example.debug.event.JDIListener;
import com.sun.tools.example.debug.event.ThreadDeathEventSet;
import com.sun.tools.example.debug.event.ThreadStartEventSet;
import com.sun.tools.example.debug.event.VMDisconnectEventSet;
import com.sun.tools.example.debug.gui.ClassManager;
import com.sun.tools.example.debug.gui.CommandInterpreter;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.SearchPath;
import com.sun.tools.example.debug.gui.SingleLeafTreeSelectionModel;
import com.sun.tools.example.debug.gui.SourceManager;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ThreadTreeTool
extends JPanel {
    private Environment env;
    private ExecutionManager runtime;
    private SourceManager sourceManager;
    private ClassManager classManager;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private ThreadTreeNode root;
    private SearchPath sourcePath;
    private CommandInterpreter interpreter;
    private static String HEADING = "THREADS";
    HashMap threadTable = new HashMap();

    public ThreadTreeTool(Environment environment) {
        super(new BorderLayout());
        this.env = environment;
        this.runtime = environment.getExecutionManager();
        this.sourceManager = environment.getSourceManager();
        this.interpreter = new CommandInterpreter(environment);
        this.root = this.createThreadTree(HEADING);
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.setSelectionModel(new SingleLeafTreeSelectionModel());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ThreadTreeNode threadTreeNode;
                int n = ThreadTreeTool.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = ThreadTreeTool.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && mouseEvent.getClickCount() == 1 && (threadTreeNode = (ThreadTreeNode)treePath.getLastPathComponent()).isLeaf()) {
                    ThreadTreeTool.this.tree.setSelectionPath(treePath);
                    ThreadTreeTool.this.interpreter.executeCommand("thread " + threadTreeNode.getThreadId() + "  (\"" + threadTreeNode.getName() + "\")");
                }
            }
        };
        this.tree.addMouseListener(mouseAdapter);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.add(jScrollPane);
        ThreadTreeToolListener threadTreeToolListener = new ThreadTreeToolListener();
        this.runtime.addJDIListener(threadTreeToolListener);
        this.runtime.addSessionListener(threadTreeToolListener);
    }

    ThreadTreeNode createThreadTree(String string) {
        return new ThreadTreeNode(string, null);
    }

    private List threadPath(ThreadReference threadReference) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(0, threadReference.name());
        ThreadGroupReference threadGroupReference = threadReference.threadGroup();
        while (threadGroupReference != null) {
            arrayList.add(0, threadGroupReference.name());
            threadGroupReference = threadGroupReference.parent();
        }
        return arrayList;
    }

    private class ThreadTreeToolListener
    extends JDIAdapter
    implements JDIListener,
    SessionListener {
        ThreadTreeToolListener() {
        }

        public void sessionContinue(EventObject eventObject) {
        }

        public void sessionInterrupt(EventObject eventObject) {
        }

        public void sessionStart(EventObject eventObject) {
            try {
                Iterator iterator = ThreadTreeTool.this.runtime.allThreads().iterator();
                while (iterator.hasNext()) {
                    ThreadReference threadReference = (ThreadReference)iterator.next();
                    ThreadTreeTool.this.root.addThread(threadReference);
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (NoSessionException noSessionException) {}
        }

        public void threadDeath(ThreadDeathEventSet threadDeathEventSet) {
            ThreadTreeTool.this.root.removeThread(threadDeathEventSet.getThread());
        }

        public void threadStart(ThreadStartEventSet threadStartEventSet) {
            ThreadTreeTool.this.root.addThread(threadStartEventSet.getThread());
        }

        public void vmDisconnect(VMDisconnectEventSet vMDisconnectEventSet) {
            ThreadTreeTool.this.root = ThreadTreeTool.this.createThreadTree(HEADING);
            ThreadTreeTool.this.treeModel = new DefaultTreeModel(ThreadTreeTool.this.root);
            ThreadTreeTool.this.tree.setModel(ThreadTreeTool.this.treeModel);
            ThreadTreeTool.this.threadTable = new HashMap();
        }
    }

    class ThreadTreeNode
    extends DefaultMutableTreeNode {
        String name;
        ThreadReference thread;
        long uid;
        String description;

        ThreadTreeNode(String string, ThreadReference threadReference) {
            if (string == null) {
                string = "<unnamed>";
            }
            this.name = string;
            this.thread = threadReference;
            if (threadReference == null) {
                this.uid = -1L;
                this.description = string;
            } else {
                this.uid = threadReference.uniqueID();
                this.description = String.valueOf(string) + " (t@" + Long.toHexString(this.uid) + ")";
            }
        }

        public void addThread(ThreadReference threadReference) {
            block4: {
                if (ThreadTreeTool.this.threadTable.get(threadReference) != null) break block4;
                try {
                    List list = ThreadTreeTool.this.threadPath(threadReference);
                    try {
                        ThreadTreeTool.this.threadTable.put(threadReference, list);
                        this.addThread(list, threadReference);
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException("ThreadTree corrupted");
                    }
                }
                catch (VMDisconnectedException vMDisconnectedException) {}
            }
        }

        private void addThread(List list, ThreadReference threadReference) {
            int n = list.size();
            if (n == 0) {
                return;
            }
            if (n == 1) {
                String string = (String)list.get(0);
                this.insertNode(string, threadReference);
            } else {
                String string = (String)list.get(0);
                List list2 = list.subList(1, n);
                ThreadTreeNode threadTreeNode = this.insertNode(string, null);
                threadTreeNode.addThread(list2, threadReference);
            }
        }

        private ThreadTreeNode findInternalNode(String string) {
            int n = 0;
            while (n < this.getChildCount()) {
                ThreadTreeNode threadTreeNode = (ThreadTreeNode)this.getChildAt(n);
                if (string.equals(threadTreeNode.getName())) {
                    return threadTreeNode;
                }
                ++n;
            }
            throw new RuntimeException("not found");
        }

        private ThreadTreeNode findLeafNode(ThreadReference threadReference, String string) {
            int n = 0;
            while (n < this.getChildCount()) {
                ThreadTreeNode threadTreeNode = (ThreadTreeNode)this.getChildAt(n);
                if (threadTreeNode.getThread() == threadReference) {
                    if (!string.equals(threadTreeNode.getName())) {
                        throw new RuntimeException("name mismatch");
                    }
                    return threadTreeNode;
                }
                ++n;
            }
            throw new RuntimeException("not found");
        }

        public String getName() {
            return this.name;
        }

        public ThreadReference getThread() {
            return this.thread;
        }

        public String getThreadId() {
            return "t@" + Long.toHexString(this.uid);
        }

        private ThreadTreeNode insertNode(String string, ThreadReference threadReference) {
            ThreadTreeNode threadTreeNode;
            int n = 0;
            while (n < this.getChildCount()) {
                threadTreeNode = (ThreadTreeNode)this.getChildAt(n);
                int n2 = string.compareTo(threadTreeNode.getName());
                if (n2 == 0 && threadReference == null) {
                    return threadTreeNode;
                }
                if (n2 < 0) {
                    ThreadTreeNode threadTreeNode2 = new ThreadTreeNode(string, threadReference);
                    ThreadTreeTool.this.treeModel.insertNodeInto(threadTreeNode2, this, n);
                    return threadTreeNode2;
                }
                ++n;
            }
            threadTreeNode = new ThreadTreeNode(string, threadReference);
            ThreadTreeTool.this.treeModel.insertNodeInto(threadTreeNode, this, this.getChildCount());
            return threadTreeNode;
        }

        public boolean isLeaf() {
            return this.isThreadGroup() ^ true;
        }

        private boolean isThreadGroup() {
            return this.thread == null;
        }

        public void removeThread(ThreadReference threadReference) {
            List list = (List)ThreadTreeTool.this.threadTable.get(threadReference);
            if (list != null) {
                this.removeThread(list, threadReference);
            }
        }

        private void removeThread(List list, ThreadReference threadReference) {
            int n = list.size();
            if (n == 0) {
                return;
            }
            if (n == 1) {
                String string = (String)list.get(0);
                ThreadTreeNode threadTreeNode = this.findLeafNode(threadReference, string);
                ThreadTreeTool.this.treeModel.removeNodeFromParent(threadTreeNode);
            } else {
                String string = (String)list.get(0);
                List list2 = list.subList(1, n);
                ThreadTreeNode threadTreeNode = this.findInternalNode(string);
                threadTreeNode.removeThread(list2, threadReference);
                if (threadTreeNode.isThreadGroup() && threadTreeNode.getChildCount() < 1) {
                    ThreadTreeTool.this.treeModel.removeNodeFromParent(threadTreeNode);
                }
            }
        }

        public String toString() {
            return this.description;
        }
    }
}

