/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class TypeScript
extends JPanel {
    private JTextArea history;
    private JTextField entry;
    private JLabel promptLabel;
    private JScrollBar historyVScrollBar;
    private JScrollBar historyHScrollBar;
    private boolean echoInput = false;
    private boolean nlPending = false;
    private static String newline = System.getProperty("line.separator");

    public TypeScript(String string) {
        this(string, true);
    }

    public TypeScript(String string, boolean bl) {
        this.echoInput = bl;
        this.setLayout(new BoxLayout(this, 1));
        this.history = new JTextArea(0, 0);
        this.history.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.history);
        this.historyVScrollBar = jScrollPane.getVerticalScrollBar();
        this.historyHScrollBar = jScrollPane.getHorizontalScrollBar();
        this.add(jScrollPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.promptLabel = new JLabel(String.valueOf(string) + " ");
        jPanel.add(this.promptLabel);
        this.entry = new JTextField();
        this.entry.setMaximumSize(new Dimension(1000, 20));
        jPanel.add(this.entry);
        this.add(jPanel);
    }

    public void addActionListener(ActionListener actionListener) {
        this.entry.addActionListener(actionListener);
    }

    public void append(String string) {
        this.history.append(string);
        this.historyVScrollBar.setValue(this.historyVScrollBar.getMaximum());
        this.historyHScrollBar.setValue(this.historyHScrollBar.getMinimum());
    }

    public void flush() {
    }

    public void newline() {
        this.history.append(newline);
        this.historyVScrollBar.setValue(this.historyVScrollBar.getMaximum());
        this.historyHScrollBar.setValue(this.historyHScrollBar.getMinimum());
    }

    public String readln() {
        String string = this.entry.getText();
        this.entry.setText("");
        if (this.echoInput) {
            this.history.append(">>>");
            this.history.append(string);
            this.history.append(newline);
            this.historyVScrollBar.setValue(this.historyVScrollBar.getMaximum());
            this.historyHScrollBar.setValue(this.historyHScrollBar.getMinimum());
        }
        return string;
    }

    public void removeActionListener(ActionListener actionListener) {
        this.entry.removeActionListener(actionListener);
    }

    public void setPrompt(String string) {
        this.promptLabel.setText(String.valueOf(string) + " ");
    }
}

