/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PathSearchingVirtualMachine;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.StepRequest;
import com.sun.tools.example.debug.expr.ExpressionParser;
import com.sun.tools.example.debug.expr.ParseException;
import com.sun.tools.example.debug.tty.BreakpointSpec;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.EventRequestSpec;
import com.sun.tools.example.debug.tty.ExceptionSpec;
import com.sun.tools.example.debug.tty.MalformedMemberNameException;
import com.sun.tools.example.debug.tty.ThreadGroupIterator;
import com.sun.tools.example.debug.tty.ThreadInfo;
import com.sun.tools.example.debug.tty.VMConnection;
import com.sun.tools.example.debug.tty.VMNotConnectedException;
import com.sun.tools.example.debug.tty.WatchpointSpec;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

class Commands {
    PrintStream out;
    private String sourcePath = ".";

    Commands(PrintStream printStream) {
        this.out = printStream;
    }

    void clearPreviousStep(ThreadReference threadReference) {
        EventRequestManager eventRequestManager = Env.vm().eventRequestManager();
        List list = eventRequestManager.stepRequests();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            StepRequest stepRequest = (StepRequest)iterator.next();
            if (!stepRequest.thread().equals(threadReference)) continue;
            eventRequestManager.deleteEventRequest(stepRequest);
            break;
        }
    }

    void commandBytecodes(StringTokenizer stringTokenizer) {
        Comparable comparable;
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("No class specified");
            return;
        }
        String string = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("No method specified");
            return;
        }
        String string2 = stringTokenizer.nextToken();
        List list = Env.vm().classesByName(string);
        if (list.size() == 0) {
            this.out.print(String.valueOf(string) + " not found");
            this.out.println(string.indexOf(46) > 0 ? " (try the full name)" : "");
            return;
        }
        ReferenceType referenceType = (ReferenceType)list.get(0);
        if (!(referenceType instanceof ClassType)) {
            this.out.print(String.valueOf(string) + " is not a class");
            return;
        }
        byte[] byArray = null;
        List list2 = referenceType.methodsByName(string2);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            comparable = (Method)iterator.next();
            if (comparable.isAbstract()) continue;
            byArray = comparable.bytecodes();
            break;
        }
        comparable = new StringBuffer(80);
        ((StringBuffer)comparable).append("0000: ");
        int n = 0;
        while (n < byArray.length) {
            String string3;
            int n2;
            if (n > 0 && n % 16 == 0) {
                this.out.println(((StringBuffer)comparable).toString());
                ((StringBuffer)comparable).setLength(0);
                ((StringBuffer)comparable).append(String.valueOf(n));
                ((StringBuffer)comparable).append(": ");
                n2 = ((StringBuffer)comparable).length();
                int n3 = 0;
                while (n3 < 6 - n2) {
                    ((StringBuffer)comparable).insert(0, '0');
                    ++n3;
                }
            }
            if ((string3 = Integer.toHexString(n2 = 0xFF & byArray[n])).length() == 1) {
                ((StringBuffer)comparable).append('0');
            }
            ((StringBuffer)comparable).append(string3);
            ((StringBuffer)comparable).append(' ');
            ++n;
        }
        if (((StringBuffer)comparable).length() > 6) {
            this.out.println(((StringBuffer)comparable).toString());
        }
    }

    void commandCatchException(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.listCaughtExceptions();
        } else {
            EventRequestSpec eventRequestSpec = this.parseExceptionSpec(stringTokenizer);
            if (eventRequestSpec != null) {
                this.resolveNow(eventRequestSpec);
            }
        }
    }

    void commandClass(StringTokenizer stringTokenizer) {
        ReferenceType referenceType;
        List list = Env.vm().allClasses();
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("No class specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        boolean bl = false;
        if (stringTokenizer.hasMoreTokens()) {
            if (stringTokenizer.nextToken().toLowerCase().equals("all")) {
                bl = true;
            } else {
                this.out.println("Invalid option on class command");
                return;
            }
        }
        if ((referenceType = Env.getReferenceTypeFromToken(string)) == null) {
            this.out.println("\"" + string + "\" is not a valid id or class name.");
            return;
        }
        if (referenceType instanceof ClassType) {
            Object object;
            Object object2;
            ClassType classType = (ClassType)referenceType;
            this.out.println("Class: " + classType.name());
            ClassType classType2 = classType.superclass();
            while (classType2 != null) {
                this.out.println("extends: " + classType2.name());
                ClassType classType3 = classType2 = bl ? classType2.superclass() : null;
            }
            List list2 = bl ? classType.allInterfaces() : classType.interfaces();
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                object2 = (InterfaceType)iterator.next();
                this.out.println("implements: " + object2.name());
            }
            object2 = classType.subclasses();
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (ClassType)iterator.next();
                this.out.println("subclass: " + object.name());
            }
            object = classType.nestedTypes();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                ReferenceType referenceType2 = (ReferenceType)iterator.next();
                this.out.println("nested: " + referenceType2.name());
            }
        } else if (referenceType instanceof InterfaceType) {
            Object object;
            Object object3;
            Object object4;
            InterfaceType interfaceType = (InterfaceType)referenceType;
            this.out.println("Interface: " + interfaceType.name());
            List list3 = interfaceType.superinterfaces();
            Iterator iterator = list3.iterator();
            while (iterator.hasNext()) {
                object4 = (InterfaceType)iterator.next();
                this.out.println("extends: " + object4.name());
            }
            object4 = interfaceType.subinterfaces();
            iterator = object4.iterator();
            while (iterator.hasNext()) {
                object3 = (InterfaceType)iterator.next();
                this.out.println("subinterface: " + object3.name());
            }
            object3 = interfaceType.implementors();
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                object = (ClassType)iterator.next();
                this.out.println("implementor: " + object.name());
            }
            object = interfaceType.nestedTypes();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                ReferenceType referenceType3 = (ReferenceType)iterator.next();
                this.out.println("nested: " + referenceType3.name());
            }
        } else {
            ArrayType arrayType = (ArrayType)referenceType;
            this.out.println("Array: " + arrayType.name());
        }
    }

    void commandClasses() {
        List list = Env.vm().allClasses();
        this.out.println("** classes list **");
        int n = 0;
        while (n < list.size()) {
            ReferenceType referenceType = (ReferenceType)list.get(n);
            this.out.println(referenceType.name());
            ++n;
        }
    }

    void commandClasspath(StringTokenizer stringTokenizer) {
        if (Env.vm() instanceof PathSearchingVirtualMachine) {
            PathSearchingVirtualMachine pathSearchingVirtualMachine = (PathSearchingVirtualMachine)Env.vm();
            this.out.println("base directory: " + pathSearchingVirtualMachine.baseDirectory());
            this.out.println("classpath: " + pathSearchingVirtualMachine.classPath());
            this.out.println("bootclasspath: " + pathSearchingVirtualMachine.bootClassPath());
        } else {
            this.out.println("The VM does not use paths");
        }
    }

    void commandClear(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.listBreakpoints();
            return;
        }
        BreakpointSpec breakpointSpec = this.parseBreakpointSpec(stringTokenizer, "clear", "clear");
        if (breakpointSpec != null) {
            if (Env.specList.delete(breakpointSpec)) {
                this.out.println("Removed: " + breakpointSpec);
            } else {
                this.out.println("Not found: " + breakpointSpec);
            }
        }
    }

    void commandCont() {
        if (ThreadInfo.current == null) {
            this.out.println("Nothing suspended.");
            return;
        }
        Env.vm().resume();
    }

    void commandDisableGC(final StringTokenizer stringTokenizer) {
        final ThreadReference threadReference = ThreadInfo.current.thread;
        Thread thread = new Thread("enablegc command"){

            public void run() {
                this.doDisableGC(stringTokenizer);
                ThreadInfo.invalidateAll();
                ThreadInfo.setCurrentThread(threadReference);
                Env.printPrompt();
            }
        };
        thread.start();
    }

    void commandDown(StringTokenizer stringTokenizer) {
        if (ThreadInfo.current == null) {
            this.out.println("Current thread not set.");
            return;
        }
        int n = 1;
        if (stringTokenizer.hasMoreTokens()) {
            int n2;
            String string = stringTokenizer.nextToken();
            try {
                n2 = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 <= 0) {
                this.out.println("usage: down [n frames]");
                return;
            }
            n = n2;
        }
        try {
            ThreadInfo.current.down(n);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            this.out.println("Thread isn't suspended.");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.out.println("End of stack.");
        }
    }

    void commandEnableGC(final StringTokenizer stringTokenizer) {
        final ThreadReference threadReference = ThreadInfo.current.thread;
        Thread thread = new Thread("enablegc command"){

            public void run() {
                this.doEnableGC(stringTokenizer);
                ThreadInfo.invalidateAll();
                ThreadInfo.setCurrentThread(threadReference);
                Env.printPrompt();
            }
        };
        thread.start();
    }

    void commandExclude(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println(Env.excludesString());
        } else {
            String string = stringTokenizer.nextToken("");
            if (string.equals("none")) {
                string = "";
            }
            Env.setExcludes(string);
        }
    }

    void commandFields(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("No class specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        ReferenceType referenceType = Env.getReferenceTypeFromToken(string);
        if (referenceType != null) {
            List list = referenceType.allFields();
            List list2 = referenceType.visibleFields();
            int n = 0;
            while (n < list.size()) {
                Field field = (Field)list.get(n);
                this.out.print(String.valueOf(field.typeName()) + " " + field.name());
                if (!list2.contains(field)) {
                    this.out.println(" (hidden)");
                } else if (!field.declaringType().equals(referenceType)) {
                    this.out.println(" (inherited from " + field.declaringType().name() + ")");
                } else {
                    this.out.println();
                }
                ++n;
            }
        } else {
            this.out.println("\"" + string + "\" is not a valid id or class name.");
        }
    }

    void commandGC() {
        this.out.println("The 'gc' command is no longer necessary.\nAll objects are garbage collected as usual. Use 'enablegc' and 'disablegc'\ncommands to control garbage collection of individual objects.");
    }

    void commandIgnoreException(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.listCaughtExceptions();
        } else {
            EventRequestSpec eventRequestSpec = this.parseExceptionSpec(stringTokenizer);
            if (Env.specList.delete(eventRequestSpec)) {
                this.out.println("Removed " + eventRequestSpec);
            } else {
                this.out.println("Not found: " + eventRequestSpec);
            }
        }
    }

    void commandInterrupt(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            if (ThreadInfo.current == null) {
                this.out.println("No thread specified.");
                return;
            }
            ThreadInfo.current.thread.interrupt();
        } else {
            String string = stringTokenizer.nextToken();
            ThreadInfo threadInfo = this.getThread(string);
            if (threadInfo != null) {
                threadInfo.thread.interrupt();
            } else {
                this.out.println("Invalid thread");
            }
        }
    }

    void commandKill(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("Usage: kill <thread id> <throwable>");
            return;
        }
        String string = stringTokenizer.nextToken();
        ThreadInfo threadInfo = ThreadInfo.getThread(string);
        if (threadInfo != null) {
            this.out.println("killing thread: " + threadInfo.thread.name());
            this.doKillThread(threadInfo.thread, stringTokenizer);
            return;
        }
        this.out.println("invalid thread");
    }

    void commandLines(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("Specify class and method");
        } else {
            String string = stringTokenizer.nextToken();
            String string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            try {
                ReferenceType referenceType = Env.getReferenceTypeFromToken(string);
                if (referenceType != null) {
                    Object object;
                    Object object2;
                    List list = null;
                    if (string2 == null) {
                        list = referenceType.allLineLocations();
                    } else {
                        object2 = referenceType.allMethods();
                        object = object2.iterator();
                        while (object.hasNext()) {
                            Method method = (Method)object.next();
                            if (!method.name().equals(string2)) continue;
                            list = method.allLineLocations();
                        }
                        if (list == null) {
                            this.out.println("\"" + string2 + "\" is not a method name.");
                        }
                    }
                    object2 = list.iterator();
                    while (object2.hasNext()) {
                        object = (Location)object2.next();
                        this.out.println(object);
                    }
                } else {
                    this.out.println("\"" + string + "\" is not a valid id or class name.");
                }
            }
            catch (AbsentInformationException absentInformationException) {
                this.out.println("Line number information not available for \"" + string + "\"");
            }
        }
    }

    void commandList(StringTokenizer stringTokenizer) {
        block19: {
            StackFrame stackFrame = null;
            if (ThreadInfo.current == null) {
                this.out.println("No thread specified.");
                return;
            }
            try {
                stackFrame = ThreadInfo.current.getCurrentFrame();
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                this.out.println("Current thread isn't suspended.");
                return;
            }
            if (stackFrame == null) {
                this.out.println("No frames on the current call stack");
                return;
            }
            Location location = stackFrame.location();
            if (location.method().isNative()) {
                this.out.println("Current method is native");
                return;
            }
            String string = null;
            try {
                string = location.sourceName();
                ReferenceType referenceType = location.declaringType();
                int n = location.lineNumber();
                if (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    try {
                        n = Integer.valueOf(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        List list = referenceType.methodsByName(string2);
                        if (list == null || list.size() == 0) {
                            this.out.println(String.valueOf(string2) + " is not a valid line number or " + "method name for class " + referenceType.name());
                            return;
                        }
                        if (list.size() > 1) {
                            this.out.println(String.valueOf(string2) + " is an ambiguous method name in" + referenceType.name());
                            return;
                        }
                        location = ((Method)list.get(0)).location();
                        n = location.lineNumber();
                    }
                }
                int n2 = n > 4 ? n - 4 : 1;
                int n3 = n2 + 9;
                if (Env.sourceLine(location, n) == null) {
                    this.out.println(n + " is an invalid line number for " + referenceType.name());
                    break block19;
                }
                int n4 = n2;
                while (n4 <= n3) {
                    String string3 = Env.sourceLine(location, n4);
                    if (string3 != null) {
                        this.out.print(n4);
                        this.out.print("\t");
                        if (n4 == n) {
                            this.out.print("=> ");
                        } else {
                            this.out.print("   ");
                        }
                        this.out.println(string3);
                        ++n4;
                        continue;
                    }
                    break;
                }
            }
            catch (AbsentInformationException absentInformationException) {
                this.out.println("No source information available for " + location);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.out.println("Source file not found: " + string);
            }
            catch (IOException iOException) {
                this.out.println("I/O Exception occurred: " + iOException);
            }
        }
    }

    void commandLoad(StringTokenizer stringTokenizer) {
        this.out.println("The 'load' command is no longer supported.");
    }

    void commandLocals() {
        if (ThreadInfo.current == null) {
            this.out.println("No default thread specified: use the \"thread\" command first.");
            return;
        }
        try {
            Mirror mirror;
            Object object;
            StackFrame stackFrame = ThreadInfo.current.getCurrentFrame();
            List list = stackFrame.visibleVariables();
            if (list.size() == 0) {
                this.out.println("No local variables");
                return;
            }
            Map map = stackFrame.getValues(list);
            this.out.println("Method arguments:");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (LocalVariable)iterator.next();
                if (!object.isArgument()) continue;
                mirror = (Value)map.get(object);
                this.printVar((LocalVariable)object, (Value)mirror);
            }
            this.out.println("Local variables:");
            object = list.iterator();
            while (object.hasNext()) {
                mirror = (LocalVariable)object.next();
                if (mirror.isArgument()) continue;
                Value value = (Value)map.get(mirror);
                this.printVar((LocalVariable)mirror, value);
            }
        }
        catch (AbsentInformationException absentInformationException) {
            this.out.println("Local variable information not available. Compile with -g to generate variable information");
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            this.out.println("Thread isn't suspended.");
        }
    }

    void commandLock(final StringTokenizer stringTokenizer) {
        final ThreadReference threadReference = ThreadInfo.current.thread;
        Thread thread = new Thread("lock command"){

            public void run() {
                this.doLock(stringTokenizer);
                ThreadInfo.invalidateAll();
                ThreadInfo.setCurrentThread(threadReference);
                Env.printPrompt();
            }
        };
        thread.start();
    }

    void commandMemory() {
        this.out.println("The 'memory' command is no longer supported.");
    }

    void commandMethods(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("No class specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        ReferenceType referenceType = Env.getReferenceTypeFromToken(string);
        if (referenceType != null) {
            List list = referenceType.allMethods();
            int n = 0;
            while (n < list.size()) {
                Method method = (Method)list.get(n);
                this.out.print(String.valueOf(method.declaringType().name()) + " " + method.name() + "(");
                Iterator iterator = method.argumentTypeNames().iterator();
                if (iterator.hasNext()) {
                    while (true) {
                        this.out.print((String)iterator.next());
                        if (!iterator.hasNext()) break;
                        this.out.print(", ");
                    }
                }
                this.out.println(")");
                ++n;
            }
        } else {
            this.out.println("\"" + string + "\" is not a valid id or class name.");
        }
    }

    void commandNext() {
        if (ThreadInfo.current == null) {
            this.out.println("Nothing suspended.");
            return;
        }
        this.clearPreviousStep(ThreadInfo.current.thread);
        EventRequestManager eventRequestManager = Env.vm().eventRequestManager();
        StepRequest stepRequest = eventRequestManager.createStepRequest(ThreadInfo.current.thread, -2, 2);
        Env.addExcludes(stepRequest);
        stepRequest.addCountFilter(1);
        stepRequest.enable();
        Env.vm().resume();
    }

    void commandPrint(final StringTokenizer stringTokenizer, final boolean bl) {
        final ThreadReference threadReference = ThreadInfo.current == null ? null : ThreadInfo.current.thread;
        Thread thread = new Thread("print command"){

            public void run() {
                this.doPrint(stringTokenizer, bl);
                ThreadInfo.invalidateAll();
                if (threadReference != null) {
                    ThreadInfo.setCurrentThread(threadReference);
                }
                Env.printPrompt();
            }
        };
        thread.start();
    }

    /*
     * Unable to fully structure code
     */
    void commandResume(StringTokenizer var1_1) {
        block2: {
            if (var1_1.hasMoreTokens()) ** GOTO lbl13
            var2_2 = ThreadInfo.threadIterator();
            while (var2_2.hasNext()) {
                var2_2.nextThread().resume();
            }
            ThreadInfo.invalidateAll();
            this.out.println("All threads resumed.");
            break block2;
lbl-1000:
            // 1 sources

            {
                var2_3 = this.getThread(var1_1.nextToken());
                if (var2_3 == null) continue;
                var2_3.thread.resume();
                var2_3.invalidate();
lbl13:
                // 3 sources

                ** while (var1_1.hasMoreTokens())
            }
        }
    }

    void commandRun(StringTokenizer stringTokenizer) {
        String string;
        VMConnection vMConnection = Env.connection();
        if (!vMConnection.isLaunch()) {
            if (!stringTokenizer.hasMoreTokens()) {
                this.commandCont();
            } else {
                this.out.println("'run <args>' command valid only with launched VMs");
            }
            return;
        }
        if (vMConnection.isOpen()) {
            this.out.println("VM already running. Use 'cont' to continue after events.");
            return;
        }
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken("");
            boolean bl = vMConnection.setConnectorArg("main", string);
            if (!bl) {
                this.out.println("Unable to set main class and arguments");
                return;
            }
        } else {
            string = vMConnection.connectorArg("main");
            if (string.length() == 0) {
                this.out.println("Main class and arguments must be specified");
                return;
            }
        }
        this.out.println("run " + string);
        vMConnection.open();
    }

    /*
     * Unable to fully structure code
     */
    void commandSave(final StringTokenizer var1_1) {
        block3: {
            block2: {
                if (var1_1.hasMoreTokens()) break block2;
                var2_2 = Env.getSaveKeys();
                var3_4 = var2_2.iterator();
                if (var3_4.hasNext()) ** GOTO lbl14
                this.out.println("No saved values");
                return;
lbl-1000:
                // 1 sources

                {
                    var4_6 = (String)var3_4.next();
                    var5_7 = Env.getSavedValue(var4_6);
                    this.out.print(String.valueOf(var4_6) + " = ");
                    if (var5_7 instanceof ObjectReference && ((ObjectReference)var5_7).isCollected()) {
                        this.out.println(" <collected>");
                        continue;
                    }
                    this.out.println(var5_7 != null ? var5_7.toString() : "null");
lbl14:
                    // 3 sources

                    ** while (var3_4.hasNext())
                }
lbl15:
                // 1 sources

                break block3;
            }
            var2_3 = ThreadInfo.current.thread;
            var3_5 = new Thread("save command"){

                public void run() {
                    this.doSave(var1_1);
                    ThreadInfo.invalidateAll();
                    ThreadInfo.setCurrentThread(var2_3);
                    Env.printPrompt();
                }
            };
            var3_5.start();
        }
    }

    void commandSet(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken("");
        if (string.indexOf(61) == -1) {
            this.out.println("Invalid assignment syntax");
            Env.printPrompt();
            return;
        }
        this.commandPrint(new StringTokenizer(string), false);
    }

    void commandStep(StringTokenizer stringTokenizer) {
        if (ThreadInfo.current == null) {
            this.out.println("Nothing suspended.");
            return;
        }
        int n = stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().toLowerCase().equals("up") ? 3 : 1;
        this.clearPreviousStep(ThreadInfo.current.thread);
        EventRequestManager eventRequestManager = Env.vm().eventRequestManager();
        StepRequest stepRequest = eventRequestManager.createStepRequest(ThreadInfo.current.thread, -2, n);
        if (n == 1) {
            Env.addExcludes(stepRequest);
        }
        stepRequest.addCountFilter(1);
        stepRequest.enable();
        Env.vm().resume();
    }

    void commandStepi() {
        if (ThreadInfo.current == null) {
            this.out.println("Nothing suspended.");
            return;
        }
        this.clearPreviousStep(ThreadInfo.current.thread);
        EventRequestManager eventRequestManager = Env.vm().eventRequestManager();
        StepRequest stepRequest = eventRequestManager.createStepRequest(ThreadInfo.current.thread, -1, 1);
        Env.addExcludes(stepRequest);
        stepRequest.addCountFilter(1);
        stepRequest.enable();
        Env.vm().resume();
    }

    void commandStop(StringTokenizer stringTokenizer) {
        String string;
        int n = 2;
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (string.equals("go") && stringTokenizer.hasMoreTokens()) {
                n = 0;
                string = stringTokenizer.nextToken();
            } else if (string.equals("thread") && stringTokenizer.hasMoreTokens()) {
                n = 1;
                string = stringTokenizer.nextToken();
            }
        } else {
            this.listBreakpoints();
            return;
        }
        BreakpointSpec breakpointSpec = this.parseBreakpointSpec(stringTokenizer, "stop at", "stop in");
        if (breakpointSpec != null) {
            if (string.equals("at") && breakpointSpec.isMethodBreakpoint()) {
                this.out.println("Use 'stop at' to set a breakpoint at a line number");
                this.printBreakpointCommandUsage("stop at", "stop in");
                return;
            }
            breakpointSpec.suspendPolicy = n;
            this.resolveNow(breakpointSpec);
        }
    }

    /*
     * Unable to fully structure code
     */
    void commandSuspend(StringTokenizer var1_1) {
        block2: {
            if (var1_1.hasMoreTokens()) ** GOTO lbl11
            var2_2 = ThreadInfo.threadIterator();
            while (var2_2.hasNext()) {
                var2_2.nextThread().suspend();
            }
            this.out.println("All (non-system) threads suspended.");
            break block2;
lbl-1000:
            // 1 sources

            {
                var2_3 = this.getThread(var1_1.nextToken());
                if (var2_3 == null) continue;
                var2_3.thread.suspend();
lbl11:
                // 3 sources

                ** while (var1_1.hasMoreTokens())
            }
        }
    }

    void commandThread(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("Thread number not specified.");
            return;
        }
        ThreadInfo threadInfo = this.getThread(stringTokenizer.nextToken());
        if (threadInfo != null) {
            ThreadInfo.current = threadInfo;
        }
    }

    void commandThreadGroup(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("Threadgroup name not specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        ThreadGroupReference threadGroupReference = ThreadGroupIterator.find(string);
        if (threadGroupReference == null) {
            this.out.println(String.valueOf(string) + " is not a valid threadgroup name.");
        } else {
            ThreadInfo.setThreadGroup(threadGroupReference);
        }
    }

    void commandThreadGroups() {
        ThreadGroupIterator threadGroupIterator = new ThreadGroupIterator();
        int n = 0;
        while (threadGroupIterator.hasNext()) {
            ThreadGroupReference threadGroupReference = threadGroupIterator.nextThreadGroup();
            this.out.println(++n + ". " + Env.description(threadGroupReference) + " " + threadGroupReference.name());
        }
    }

    void commandThreadlocks(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.printThreadLockInfo(ThreadInfo.current.thread);
            return;
        }
        String string = stringTokenizer.nextToken();
        if (string.toLowerCase().equals("all")) {
            ThreadInfo[] threadInfoArray = ThreadInfo.threads();
            int n = 0;
            while (n < threadInfoArray.length) {
                ThreadInfo threadInfo = threadInfoArray[n];
                this.printThreadLockInfo(threadInfo.thread);
                ++n;
            }
        } else {
            ThreadInfo threadInfo = this.getThread(string);
            if (threadInfo != null) {
                ThreadInfo.current = threadInfo;
            }
            this.printThreadLockInfo(threadInfo.thread);
        }
    }

    void commandThreads(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.printThreadGroup(ThreadInfo.group(), 0);
            return;
        }
        String string = stringTokenizer.nextToken();
        ThreadGroupReference threadGroupReference = ThreadGroupIterator.find(string);
        if (threadGroupReference == null) {
            this.out.println(String.valueOf(string) + " is not a valid threadgroup name.");
        } else {
            this.printThreadGroup(threadGroupReference, 0);
        }
    }

    void commandTrace(StringTokenizer stringTokenizer) {
        int n = 2;
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equals("go")) {
                n = 0;
                string = stringTokenizer.nextToken();
            } else if (string.equals("thread")) {
                n = 1;
                string = stringTokenizer.nextToken();
            }
            if (!string.equals("methods")) {
                this.out.println("Specify kind, for example 'methods'");
            }
        }
        ThreadInfo threadInfo = null;
        if (stringTokenizer.hasMoreTokens()) {
            threadInfo = this.getThread(stringTokenizer.nextToken());
        }
        EventRequestManager eventRequestManager = Env.vm().eventRequestManager();
        MethodEntryRequest methodEntryRequest = eventRequestManager.createMethodEntryRequest();
        MethodExitRequest methodExitRequest = eventRequestManager.createMethodExitRequest();
        if (threadInfo != null) {
            methodEntryRequest.addThreadFilter(threadInfo.thread);
            methodExitRequest.addThreadFilter(threadInfo.thread);
        }
        Env.addExcludes(methodEntryRequest);
        Env.addExcludes(methodExitRequest);
        methodEntryRequest.setSuspendPolicy(n);
        methodExitRequest.setSuspendPolicy(n);
        methodEntryRequest.enable();
        methodExitRequest.enable();
    }

    void commandUntrace(StringTokenizer stringTokenizer) {
        EventRequestManager eventRequestManager = Env.vm().eventRequestManager();
        Iterator iterator = eventRequestManager.methodEntryRequests().iterator();
        while (iterator.hasNext()) {
            ((EventRequest)iterator.next()).disable();
        }
        iterator = eventRequestManager.methodExitRequests().iterator();
        while (iterator.hasNext()) {
            ((EventRequest)iterator.next()).disable();
        }
    }

    void commandUnwatch(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("Field to unwatch not specified.");
            return;
        }
        Iterator iterator = this.parseWatchpointSpec(stringTokenizer).iterator();
        while (iterator.hasNext()) {
            WatchpointSpec watchpointSpec = (WatchpointSpec)iterator.next();
            if (Env.specList.delete(watchpointSpec)) {
                this.out.println("Removed " + watchpointSpec);
                continue;
            }
            this.out.println("Not found: " + watchpointSpec);
        }
    }

    void commandUp(StringTokenizer stringTokenizer) {
        if (ThreadInfo.current == null) {
            this.out.println("Current thread not set.");
            return;
        }
        int n = 1;
        if (stringTokenizer.hasMoreTokens()) {
            int n2;
            String string = stringTokenizer.nextToken();
            try {
                n2 = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 <= 0) {
                this.out.println("Usage: up [n frames]");
                return;
            }
            n = n2;
        }
        try {
            ThreadInfo.current.up(n);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            this.out.println("Thread isn't suspended.");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.out.println("End of stack.");
        }
    }

    void commandUse(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println(this.sourcePath);
        } else {
            Env.setSourcePath(stringTokenizer.nextToken());
        }
    }

    void commandVersion(String string, String string2, StringTokenizer stringTokenizer) {
        this.out.println(String.valueOf(string) + ", version " + string2);
        try {
            this.out.println(Env.vm().description());
        }
        catch (VMNotConnectedException vMNotConnectedException) {
            this.out.println("No VM connected");
        }
    }

    void commandWatch(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("Field to watch not specified.");
            return;
        }
        Iterator iterator = this.parseWatchpointSpec(stringTokenizer).iterator();
        while (iterator.hasNext()) {
            this.resolveNow((WatchpointSpec)iterator.next());
        }
    }

    void commandWhere(StringTokenizer stringTokenizer, boolean bl) {
        if (!stringTokenizer.hasMoreTokens()) {
            if (ThreadInfo.current == null) {
                this.out.println("No thread specified.");
                return;
            }
            this.dumpStack(ThreadInfo.current, bl);
        } else {
            String string = stringTokenizer.nextToken();
            if (string.toLowerCase().equals("all")) {
                ThreadInfo[] threadInfoArray = ThreadInfo.threads();
                int n = 0;
                while (n < threadInfoArray.length) {
                    ThreadInfo threadInfo = threadInfoArray[n];
                    this.out.println(String.valueOf(threadInfo.thread.name()) + ": ");
                    this.dumpStack(threadInfo, bl);
                    ++n;
                }
            } else {
                ThreadInfo threadInfo = this.getThread(string);
                if (threadInfo != null) {
                    ThreadInfo.current = threadInfo;
                }
                this.dumpStack(threadInfo, bl);
            }
        }
    }

    void doDisableGC(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("No object specified.");
            return;
        }
        String string = stringTokenizer.nextToken("");
        Value value = null;
        try {
            value = this.evaluate(string);
        }
        catch (ParseException parseException) {
            System.out.println(parseException.getMessage());
        }
        catch (InvocationException invocationException) {
            System.out.println("Exception in expression: " + invocationException.exception().referenceType().name());
        }
        catch (InvalidTypeException invalidTypeException) {
            System.out.println(invalidTypeException.getMessage());
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            System.out.println(incompatibleThreadStateException.getMessage());
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            System.out.println(classNotLoadedException.getMessage());
        }
        if (value != null && value instanceof ObjectReference) {
            ObjectReference objectReference = (ObjectReference)value;
            objectReference.disableCollection();
            this.out.println("GC Disabled for " + value.toString() + ":");
        } else {
            this.out.println("Expression must evaluate to an object");
        }
    }

    void doEnableGC(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("No object specified.");
            return;
        }
        String string = stringTokenizer.nextToken("");
        Value value = null;
        try {
            value = this.evaluate(string);
        }
        catch (ParseException parseException) {
            System.out.println(parseException.getMessage());
        }
        catch (InvocationException invocationException) {
            System.out.println("Exception in expression: " + invocationException.exception().referenceType().name());
        }
        catch (InvalidTypeException invalidTypeException) {
            System.out.println(invalidTypeException.getMessage());
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            System.out.println(incompatibleThreadStateException.getMessage());
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            System.out.println(classNotLoadedException.getMessage());
        }
        if (value != null && value instanceof ObjectReference) {
            ObjectReference objectReference = (ObjectReference)value;
            objectReference.enableCollection();
            this.out.println("GC Enabled for " + value.toString() + ":");
        } else {
            this.out.println("Expression must evaluate to an object");
        }
    }

    void doKill(ThreadReference threadReference, StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("No exception object specified.");
            return;
        }
        String string = stringTokenizer.nextToken("");
        Value value = null;
        try {
            value = this.evaluate(string);
        }
        catch (ParseException parseException) {
            System.out.println(parseException.getMessage());
        }
        catch (InvocationException invocationException) {
            System.out.println("Exception in expression: " + invocationException.exception().referenceType().name());
        }
        catch (InvalidTypeException invalidTypeException) {
            System.out.println(invalidTypeException.getMessage());
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            System.out.println(incompatibleThreadStateException.getMessage());
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            System.out.println(classNotLoadedException.getMessage());
        }
        if (value != null && value instanceof ObjectReference) {
            try {
                threadReference.stop((ObjectReference)value);
                this.out.println(String.valueOf(threadReference.toString()) + " killed");
            }
            catch (InvalidTypeException invalidTypeException) {
                this.out.println("Invalid exception object");
            }
        } else {
            this.out.println("Expression must evaluate to an object");
        }
    }

    void doKillThread(ThreadReference threadReference, StringTokenizer stringTokenizer) {
        final ThreadReference threadReference2 = ThreadInfo.current.thread;
        final ThreadReference threadReference3 = threadReference;
        final StringTokenizer stringTokenizer2 = stringTokenizer;
        Thread thread = new Thread("kill command"){

            public void run() {
                this.doKill(threadReference3, stringTokenizer2);
                ThreadInfo.invalidateAll();
                ThreadInfo.setCurrentThread(threadReference2);
                Env.printPrompt();
            }
        };
        thread.start();
    }

    void doLock(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("No object specified.");
            return;
        }
        String string = stringTokenizer.nextToken("");
        Value value = null;
        try {
            value = this.evaluate(string);
        }
        catch (ParseException parseException) {
            System.out.println(parseException.getMessage());
        }
        catch (InvocationException invocationException) {
            System.out.println("Exception in expression: " + invocationException.exception().referenceType().name());
        }
        catch (InvalidTypeException invalidTypeException) {
            System.out.println(invalidTypeException.getMessage());
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            System.out.println(incompatibleThreadStateException.getMessage());
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            System.out.println(classNotLoadedException.getMessage());
        }
        try {
            if (value != null && value instanceof ObjectReference) {
                ObjectReference objectReference = (ObjectReference)value;
                this.out.println("Monitor information for " + value.toString() + ":");
                ThreadReference threadReference = objectReference.owningThread();
                if (threadReference == null) {
                    this.out.println("  Not owned");
                } else {
                    this.out.println("  Owned by: " + threadReference.name() + ", entry count: " + objectReference.entryCount());
                }
                List list = objectReference.waitingThreads();
                if (list.size() == 0) {
                    this.out.println("  No waiters");
                } else {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ThreadReference threadReference2 = (ThreadReference)iterator.next();
                        this.out.println("  Waiting thread: " + threadReference.name());
                    }
                }
            } else {
                this.out.println("Expression must evaluate to an object");
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            this.out.println("Threads must be suspended");
        }
    }

    /*
     * Unable to fully structure code
     */
    void doPrint(StringTokenizer var1_1, boolean var2_2) {
        if (var1_1.hasMoreTokens()) ** GOTO lbl33
        this.out.println("No objects specified.");
        return;
lbl-1000:
        // 1 sources

        {
            var3_3 = var1_1.nextToken("");
            try {
                var4_4 = this.evaluate(var3_3);
                if (var4_4 == null) {
                    this.out.println(String.valueOf(var3_3) + " = null");
                    continue;
                }
                if (var2_2 && var4_4 instanceof ObjectReference && !(var4_4 instanceof StringReference)) {
                    var5_10 = (ObjectReference)var4_4;
                    var6_11 = var5_10.referenceType();
                    this.out.println(String.valueOf(var3_3) + " = " + var4_4.toString() + " {");
                    this.dump(var5_10, var6_11, var6_11);
                    this.out.println("}");
                    continue;
                }
                this.out.println(String.valueOf(var3_3) + " = " + var4_4.toString());
                continue;
            }
            catch (ParseException var4_5) {
                System.out.println(var4_5.getMessage());
                continue;
            }
            catch (InvocationException var4_6) {
                System.out.println("Exception in expression: " + var4_6.exception().referenceType().name());
                continue;
            }
            catch (InvalidTypeException var4_7) {
                System.out.println(var4_7.getMessage());
                continue;
            }
            catch (IncompatibleThreadStateException var4_8) {
                System.out.println(var4_8.getMessage());
                continue;
            }
            catch (ClassNotLoadedException var4_9) {
                System.out.println(var4_9.getMessage());
            }
lbl33:
            // 9 sources

            ** while (var1_1.hasMoreTokens())
        }
lbl34:
        // 1 sources

    }

    void doSave(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("No save index specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("No expression specified.");
            return;
        }
        String string2 = stringTokenizer.nextToken("");
        Value value = null;
        try {
            value = this.evaluate(string2);
        }
        catch (ParseException parseException) {
            System.out.println(parseException.getMessage());
        }
        catch (InvocationException invocationException) {
            System.out.println("Exception in expression: " + invocationException.exception().referenceType().name());
        }
        catch (InvalidTypeException invalidTypeException) {
            System.out.println(invalidTypeException.getMessage());
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            System.out.println(incompatibleThreadStateException.getMessage());
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            System.out.println(classNotLoadedException.getMessage());
        }
        if (value != null) {
            Env.setSavedValue(string, value);
            this.out.println(String.valueOf(value.toString()) + " saved");
        } else {
            this.out.println("Expression cannot be void");
        }
    }

    private void dump(ObjectReference objectReference, ReferenceType referenceType, ReferenceType referenceType2) {
        Object object;
        Iterator iterator = referenceType.fields().iterator();
        while (iterator.hasNext()) {
            object = (Field)iterator.next();
            this.out.print("    ");
            if (!referenceType.equals(referenceType2)) {
                this.out.print(String.valueOf(referenceType.name()) + ".");
            }
            this.out.print(String.valueOf(object.name()) + ": ");
            this.out.println(objectReference.getValue((Field)object));
        }
        if (referenceType instanceof ClassType) {
            object = ((ClassType)referenceType).superclass();
            if (object != null) {
                this.dump(objectReference, (ReferenceType)object, referenceType2);
            }
        } else if (referenceType instanceof InterfaceType) {
            object = ((InterfaceType)referenceType).superinterfaces();
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                this.dump(objectReference, (ReferenceType)iterator2.next(), referenceType2);
            }
        }
    }

    private void dumpStack(ThreadInfo threadInfo, boolean bl) {
        List list = null;
        try {
            list = threadInfo.stack();
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            this.out.println("Current thread isn't suspended.");
            return;
        }
        if (list == null) {
            this.out.println("Thread is not running (no stack).");
        } else {
            int n = list.size();
            int n2 = threadInfo.currentFrameIndex;
            while (n2 < n) {
                long l;
                StackFrame stackFrame = (StackFrame)list.get(n2);
                Location location = stackFrame.location();
                Method method = location.method();
                this.out.print("  [" + (n2 + 1) + "] ");
                this.out.print(method.declaringType().name());
                this.out.print('.');
                this.out.print(method.name());
                this.out.print(" (");
                if (method instanceof Method && method.isNative()) {
                    this.out.print("native method");
                } else if (location.lineNumber() != -1) {
                    try {
                        this.out.print(location.sourceName());
                    }
                    catch (AbsentInformationException absentInformationException) {
                        this.out.print("<unknown>");
                    }
                    this.out.print(':');
                    this.out.print(location.lineNumber());
                }
                this.out.print(')');
                if (bl && (l = location.codeIndex()) != -1L) {
                    this.out.print(", pc = " + l);
                }
                this.out.println();
                ++n2;
            }
        }
    }

    private Value evaluate(String string) throws ParseException, InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, VMNotConnectedException {
        ExpressionParser.GetFrame getFrame = null;
        final ThreadInfo threadInfo = ThreadInfo.current;
        if (threadInfo != null) {
            getFrame = new ExpressionParser.GetFrame(){

                public StackFrame get() throws IncompatibleThreadStateException {
                    return threadInfo.getCurrentFrame();
                }
            };
        }
        return ExpressionParser.evaluate(string, Env.vm(), getFrame);
    }

    ThreadInfo getThread(String string) {
        ThreadInfo threadInfo = ThreadInfo.getThread(string);
        if (threadInfo == null) {
            this.out.println("\"" + string + "\" is not a valid thread id.");
        }
        return threadInfo;
    }

    void listBreakpoints() {
        boolean bl = true;
        Iterator iterator = Env.specList.eventRequestSpecs().iterator();
        while (iterator.hasNext()) {
            EventRequestSpec eventRequestSpec = (EventRequestSpec)iterator.next();
            if (!(eventRequestSpec instanceof BreakpointSpec)) continue;
            if (bl) {
                bl = false;
                this.out.println("Breakpoints set:");
            }
            this.out.println("\t" + eventRequestSpec);
        }
        if (bl) {
            this.out.println("No breakpoints set.");
        }
    }

    void listCaughtExceptions() {
        boolean bl = true;
        Iterator iterator = Env.specList.eventRequestSpecs().iterator();
        while (iterator.hasNext()) {
            EventRequestSpec eventRequestSpec = (EventRequestSpec)iterator.next();
            if (!(eventRequestSpec instanceof ExceptionSpec)) continue;
            if (bl) {
                bl = false;
                this.out.println("Exceptions caught:");
            }
            this.out.println("\t" + eventRequestSpec);
        }
        if (bl) {
            this.out.println("No exceptions caught.");
        }
    }

    static String locationString(Location location) {
        return String.valueOf(location.declaringType().name()) + "." + location.method().name() + "(), line=" + location.lineNumber() + ", bci=" + location.codeIndex();
    }

    protected BreakpointSpec parseBreakpointSpec(StringTokenizer stringTokenizer, String string, String string2) {
        EventRequestSpec eventRequestSpec = null;
        try {
            String string3;
            String string4 = stringTokenizer.nextToken(":( \t\n\r");
            try {
                string3 = stringTokenizer.nextToken("").trim();
            }
            catch (NoSuchElementException noSuchElementException) {
                string3 = null;
            }
            if (string3 != null && string3.startsWith(":")) {
                stringTokenizer = new StringTokenizer(string3.substring(1));
                String string5 = string4;
                String string6 = stringTokenizer.nextToken();
                int n = Integer.valueOf(string6);
                if (stringTokenizer.hasMoreTokens()) {
                    this.printBreakpointCommandUsage(string, string2);
                    return null;
                }
                try {
                    eventRequestSpec = Env.specList.createBreakpoint(string5, n);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.out.println("Bad class name: " + string5);
                }
            } else {
                int n = string4.lastIndexOf(".");
                if (n <= 0 || n >= string4.length() - 1) {
                    this.printBreakpointCommandUsage(string, string2);
                    return null;
                }
                String string7 = string4.substring(n + 1);
                String string8 = string4.substring(0, n);
                ArrayList<String> arrayList = null;
                if (string3 != null) {
                    if (!string3.startsWith("(") || !string3.endsWith(")")) {
                        this.out.println("Invalid method specification: " + string7 + string3);
                        this.printBreakpointCommandUsage(string, string2);
                        return null;
                    }
                    string3 = string3.substring(1, string3.length() - 1);
                    arrayList = new ArrayList<String>();
                    stringTokenizer = new StringTokenizer(string3, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList.add(stringTokenizer.nextToken());
                    }
                }
                try {
                    eventRequestSpec = Env.specList.createBreakpoint(string8, string7, arrayList);
                }
                catch (MalformedMemberNameException malformedMemberNameException) {
                    this.out.println("Bad method name: " + string7);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.out.println("Bad class name: " + string8);
                }
            }
        }
        catch (Exception exception) {
            this.printBreakpointCommandUsage(string, string2);
            return null;
        }
        return (BreakpointSpec)eventRequestSpec;
    }

    private EventRequestSpec parseExceptionSpec(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        EventRequestSpec eventRequestSpec = null;
        try {
            eventRequestSpec = Env.specList.createExceptionCatch(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.out.println("Bad class name: " + string);
        }
        return eventRequestSpec;
    }

    private List parseWatchpointSpec(StringTokenizer stringTokenizer) {
        ArrayList<EventRequestSpec> arrayList = new ArrayList<EventRequestSpec>();
        boolean bl = false;
        boolean bl2 = false;
        int n = 2;
        String string = stringTokenizer.nextToken();
        if (string.equals("go")) {
            n = 0;
            string = stringTokenizer.nextToken();
        } else if (string.equals("thread")) {
            n = 1;
            string = stringTokenizer.nextToken();
        }
        if (string.equals("access")) {
            bl = true;
            string = stringTokenizer.nextToken();
        } else if (string.equals("all")) {
            bl = true;
            bl2 = true;
            string = stringTokenizer.nextToken();
        } else {
            bl2 = true;
        }
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            this.out.println("Class containing field must be specified.");
            return arrayList;
        }
        String string2 = string.substring(0, n2);
        string = string.substring(n2 + 1);
        try {
            EventRequestSpec eventRequestSpec;
            if (bl) {
                eventRequestSpec = Env.specList.createAccessWatchpoint(string2, string);
                eventRequestSpec.suspendPolicy = n;
                arrayList.add(eventRequestSpec);
            }
            if (bl2) {
                eventRequestSpec = Env.specList.createModificationWatchpoint(string2, string);
                eventRequestSpec.suspendPolicy = n;
                arrayList.add(eventRequestSpec);
            }
        }
        catch (MalformedMemberNameException malformedMemberNameException) {
            this.out.println("Bad field name: " + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.out.println("Bad class name: " + string2);
        }
        return arrayList;
    }

    private void printBreakpointCommandUsage(String string, String string2) {
        this.out.println("Usage: " + string + " <class>:<line_number> or");
        this.out.println("       " + string2 + " <class>.<method_name>[(argument_type,...)]");
    }

    private int printThreadGroup(ThreadGroupReference threadGroupReference, int n) {
        int n2;
        int n3;
        Object object;
        this.out.println("Group " + threadGroupReference.name() + ":");
        List list = threadGroupReference.threads();
        ThreadInfo[] threadInfoArray = ThreadInfo.threads();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < list.size()) {
            String string;
            int n7;
            object = (ThreadReference)list.get(n6);
            n3 = Env.description((ObjectReference)object).length();
            if (n3 > n4) {
                n4 = n3;
            }
            if ((n7 = (string = object.name()).lastIndexOf(46)) >= 0 && string.length() > n7) {
                string = string.substring(n7 + 1);
            }
            if (string.length() > n5) {
                n5 = string.length();
            }
            ++n6;
        }
        object = String.valueOf(threadInfoArray.length);
        n3 = ((String)object).length();
        int n8 = 0;
        while (n8 < list.size()) {
            ThreadReference threadReference = (ThreadReference)list.get(n8);
            n2 = 0;
            int n9 = 0;
            while (n9 < threadInfoArray.length) {
                if (threadInfoArray[n9].thread.equals(threadReference)) {
                    n2 = n9 + 1;
                    break;
                }
                ++n9;
            }
            char[] cArray = new char[80];
            int n10 = 0;
            while (n10 < 79) {
                cArray[n10] = 32;
                ++n10;
            }
            cArray[79] = '\u0000';
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(cArray);
            String string = String.valueOf(n2);
            stringBuffer.insert(n3 - string.length(), string);
            stringBuffer.insert(n3, ".");
            int n11 = n3 + 2;
            stringBuffer.insert(n11, Env.description(threadReference));
            n11 += n4 + 1;
            String string2 = threadReference.name();
            int n12 = string2.lastIndexOf(46);
            if (n12 >= 0 && string2.length() > n12) {
                string2 = string2.substring(n12 + 1);
            }
            stringBuffer.insert(n11, string2);
            stringBuffer.insert(n11 += n5 + 1, Env.getStatus(threadReference));
            stringBuffer.setLength(79);
            this.out.println(stringBuffer.toString());
            ++n8;
        }
        List list2 = threadGroupReference.threadGroups();
        n2 = 0;
        while (n2 < list2.size()) {
            ThreadGroupReference threadGroupReference2 = (ThreadGroupReference)list2.get(n2);
            if (!threadGroupReference.equals(threadGroupReference2)) {
                n += this.printThreadGroup(threadGroupReference2, n + list.size());
            }
            ++n2;
        }
        return list.size();
    }

    private void printThreadLockInfo(ThreadReference threadReference) {
        try {
            Object object;
            this.out.println("Monitor information for thread " + threadReference.name() + ":");
            List list = threadReference.ownedMonitors();
            if (list.size() == 0) {
                this.out.println("  No monitors owned");
            } else {
                object = list.iterator();
                while (object.hasNext()) {
                    ObjectReference objectReference = (ObjectReference)object.next();
                    this.out.println("  Owned monitor: " + objectReference);
                }
            }
            object = threadReference.currentContendedMonitor();
            if (object == null) {
                this.out.println("  Not waiting for a monitor");
            } else {
                this.out.println("  Waiting for monitor: " + object);
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            this.out.println("Threads must be suspended");
        }
    }

    private void printVar(LocalVariable localVariable, Value value) {
        this.out.println("  " + localVariable.name() + " = " + value);
    }

    private void resolveNow(EventRequestSpec eventRequestSpec) {
        boolean bl = Env.specList.addEagerlyResolve(eventRequestSpec);
        if (bl && !eventRequestSpec.isResolved()) {
            this.out.println("Deferring " + eventRequestSpec + ".");
            this.out.println("It will be set after the class is loaded.");
        }
    }

    String typedName(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(method.name());
        stringBuffer.append("(");
        Iterator iterator = method.argumentTypeNames().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

