/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.ReferenceTypeSpec;
import com.sun.tools.example.debug.tty.VMNotConnectedException;
import java.util.Iterator;

abstract class EventRequestSpec {
    final ReferenceTypeSpec refSpec;
    int suspendPolicy = 2;
    EventRequest resolved = null;
    ClassPrepareRequest prepareRequest = null;

    EventRequestSpec(ReferenceTypeSpec referenceTypeSpec) {
        this.refSpec = referenceTypeSpec;
    }

    String errorMessageFor(Exception exception) {
        if (exception instanceof IllegalArgumentException) {
            return "Invalid command syntax";
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        return "Internal error; unable to set" + this;
    }

    protected boolean isJavaIdentifier(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean isResolved() {
        return this.resolved != null;
    }

    synchronized EventRequest resolve(ClassPrepareEvent classPrepareEvent) throws Exception {
        if (this.resolved == null && this.prepareRequest != null && this.prepareRequest.equals(classPrepareEvent.request())) {
            this.resolved = this.resolveEventRequest(classPrepareEvent.referenceType());
            this.prepareRequest.disable();
            this.prepareRequest = null;
        }
        return this.resolved;
    }

    private EventRequest resolveAgainstPreparedClasses() throws Exception {
        Iterator iterator = Env.vm().allClasses().iterator();
        while (this.resolved == null && iterator.hasNext()) {
            ReferenceType referenceType = (ReferenceType)iterator.next();
            if (!referenceType.isPrepared() || !this.refSpec.matches(referenceType)) continue;
            this.resolved = this.resolveEventRequest(referenceType);
        }
        return this.resolved;
    }

    synchronized EventRequest resolveEagerly() throws Exception {
        try {
            this.resolveAgainstPreparedClasses();
            if (this.resolved == null) {
                this.prepareRequest = this.refSpec.createPrepareRequest();
                this.prepareRequest.enable();
                this.resolveAgainstPreparedClasses();
                if (this.resolved != null) {
                    this.prepareRequest.disable();
                    this.prepareRequest = null;
                }
            }
        }
        catch (VMNotConnectedException vMNotConnectedException) {}
        return this.resolved;
    }

    abstract EventRequest resolveEventRequest(ReferenceType var1) throws Exception;

    EventRequest resolved() {
        return this.resolved;
    }
}

