/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.tools.example.debug.tty.AccessWatchpointSpec;
import com.sun.tools.example.debug.tty.BreakpointSpec;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.EventRequestSpec;
import com.sun.tools.example.debug.tty.ExceptionSpec;
import com.sun.tools.example.debug.tty.MalformedMemberNameException;
import com.sun.tools.example.debug.tty.ModificationWatchpointSpec;
import com.sun.tools.example.debug.tty.PatternReferenceTypeSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class EventRequestSpecList {
    private static final int statusResolved = 1;
    private static final int statusUnresolved = 2;
    private static final int statusError = 3;
    private List eventRequestSpecs = Collections.synchronizedList(new ArrayList());

    EventRequestSpecList() {
    }

    void add(EventRequestSpec eventRequestSpec) {
        this.eventRequestSpecs.add(eventRequestSpec);
    }

    boolean addEagerlyResolve(EventRequestSpec eventRequestSpec) {
        try {
            this.eventRequestSpecs.add(eventRequestSpec);
            EventRequest eventRequest = eventRequestSpec.resolveEagerly();
            if (eventRequest != null) {
                Env.noticeln("Set " + eventRequest);
            }
            return true;
        }
        catch (Exception exception) {
            Env.errorln("Unable to set " + eventRequestSpec + " : " + eventRequestSpec.errorMessageFor(exception));
            return false;
        }
    }

    EventRequestSpec createAccessWatchpoint(String string, String string2) throws MalformedMemberNameException, ClassNotFoundException {
        PatternReferenceTypeSpec patternReferenceTypeSpec = new PatternReferenceTypeSpec(string);
        return new AccessWatchpointSpec(patternReferenceTypeSpec, string2);
    }

    EventRequestSpec createBreakpoint(String string, int n) throws ClassNotFoundException {
        PatternReferenceTypeSpec patternReferenceTypeSpec = new PatternReferenceTypeSpec(string);
        return new BreakpointSpec(patternReferenceTypeSpec, n);
    }

    EventRequestSpec createBreakpoint(String string, String string2, List list) throws MalformedMemberNameException, ClassNotFoundException {
        PatternReferenceTypeSpec patternReferenceTypeSpec = new PatternReferenceTypeSpec(string);
        return new BreakpointSpec(patternReferenceTypeSpec, string2, list);
    }

    EventRequestSpec createExceptionCatch(String string) throws ClassNotFoundException {
        PatternReferenceTypeSpec patternReferenceTypeSpec = new PatternReferenceTypeSpec(string);
        return new ExceptionSpec(patternReferenceTypeSpec);
    }

    EventRequestSpec createModificationWatchpoint(String string, String string2) throws MalformedMemberNameException, ClassNotFoundException {
        PatternReferenceTypeSpec patternReferenceTypeSpec = new PatternReferenceTypeSpec(string);
        return new ModificationWatchpointSpec(patternReferenceTypeSpec, string2);
    }

    boolean delete(EventRequestSpec eventRequestSpec) {
        List list = this.eventRequestSpecs;
        synchronized (list) {
            int n = this.eventRequestSpecs.indexOf(eventRequestSpec);
            if (n != -1) {
                EventRequestSpec eventRequestSpec2 = (EventRequestSpec)this.eventRequestSpecs.get(n);
                this.eventRequestSpecs.remove(n);
                if (eventRequestSpec2.isResolved()) {
                    Env.vm().eventRequestManager().deleteEventRequest(eventRequestSpec2.resolved());
                }
                boolean bl = true;
                Object var4_7 = null;
                return bl;
            }
            boolean bl = false;
            Object var4_8 = null;
            return bl;
        }
    }

    List eventRequestSpecs() {
        List list = this.eventRequestSpecs;
        synchronized (list) {
            ArrayList arrayList = new ArrayList(this.eventRequestSpecs);
            Object var3_3 = null;
            return arrayList;
        }
    }

    boolean resolve(ClassPrepareEvent classPrepareEvent) {
        boolean bl = false;
        List list = this.eventRequestSpecs;
        synchronized (list) {
            Iterator iterator = this.eventRequestSpecs.iterator();
            while (iterator.hasNext()) {
                EventRequestSpec eventRequestSpec = (EventRequestSpec)iterator.next();
                if (eventRequestSpec.isResolved()) continue;
                try {
                    EventRequest eventRequest = eventRequestSpec.resolve(classPrepareEvent);
                    if (eventRequest == null) continue;
                    Env.noticeln("Set deferred " + eventRequest);
                }
                catch (Exception exception) {
                    Env.errorln("Unable to set deferred " + eventRequestSpec + " : " + eventRequestSpec.errorMessageFor(exception));
                    bl = true;
                }
            }
        }
        return bl ^ true;
    }

    void resolveAll() {
        Iterator iterator = this.eventRequestSpecs.iterator();
        while (iterator.hasNext()) {
            EventRequestSpec eventRequestSpec = (EventRequestSpec)iterator.next();
            try {
                EventRequest eventRequest = eventRequestSpec.resolveEagerly();
                if (eventRequest == null) continue;
                Env.noticeln("Set deferred" + eventRequest);
            }
            catch (Exception exception) {}
        }
    }
}

