/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

class SourceMapper {
    private final String[] dirs;

    SourceMapper(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        this.dirs = arrayList.toArray(new String[0]);
    }

    File sourceFile(Location location) {
        try {
            String string = location.sourceName();
            String string2 = location.declaringType().name();
            int n = string2.lastIndexOf(46);
            String string3 = n >= 0 ? string2.substring(0, n + 1) : "";
            String string4 = String.valueOf(string3.replace('.', File.separatorChar)) + string;
            int n2 = 0;
            while (n2 < this.dirs.length) {
                File file = new File(this.dirs[n2], string4);
                if (file.exists()) {
                    return file;
                }
                ++n2;
            }
            return null;
        }
        catch (AbsentInformationException absentInformationException) {
            return null;
        }
    }

    BufferedReader sourceReader(Location location) {
        File file = this.sourceFile(location);
        if (file == null) {
            return null;
        }
        try {
            return new BufferedReader(new FileReader(file));
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

