/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.ThreadIterator;
import java.util.ArrayList;
import java.util.List;

class ThreadInfo {
    static ThreadInfo current = null;
    private static ThreadInfo[] threads;
    private static ThreadGroupReference group;
    final ThreadReference thread;
    int currentFrameIndex = 0;

    static {
        group = null;
    }

    private ThreadInfo(ThreadReference threadReference) {
        this.thread = threadReference;
        if (threadReference == null) {
            Env.fatalError("Internal error: null ThreadInfo created");
        }
    }

    private void assureSuspended() throws IncompatibleThreadStateException {
        if (!this.thread.isSuspended()) {
            throw new IncompatibleThreadStateException();
        }
    }

    void down(int n) throws IncompatibleThreadStateException {
        this.assureSuspended();
        if (this.currentFrameIndex - n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.currentFrameIndex -= n;
    }

    StackFrame getCurrentFrame() throws IncompatibleThreadStateException {
        if (this.thread.frameCount() == 0) {
            return null;
        }
        return this.thread.frame(this.currentFrameIndex);
    }

    static synchronized ThreadInfo getThread(int n) {
        if (n <= 0 || n > ThreadInfo.threads().length) {
            return null;
        }
        return ThreadInfo.threads()[n - 1];
    }

    static synchronized ThreadInfo getThread(ThreadReference threadReference) {
        ThreadInfo[] threadInfoArray = ThreadInfo.threads();
        int n = threadInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadInfo threadInfo = threadInfoArray[n2];
            if (threadInfo.thread.equals(threadReference)) {
                return threadInfo;
            }
            ++n2;
        }
        Env.out.println("Thread not found: " + threadReference.name());
        return null;
    }

    static ThreadInfo getThread(String string) {
        ThreadInfo threadInfo = null;
        if (string.startsWith("t@")) {
            string = string.substring(2);
        }
        try {
            int n = Integer.valueOf(string);
            threadInfo = ThreadInfo.getThread(n);
        }
        catch (NumberFormatException numberFormatException) {
            threadInfo = null;
        }
        return threadInfo;
    }

    static ThreadGroupReference group() {
        if (group == null) {
            ThreadInfo.setThreadGroup((ThreadGroupReference)Env.vm().topLevelThreadGroups().get(0));
        }
        return group;
    }

    void invalidate() {
        this.currentFrameIndex = 0;
    }

    static synchronized void invalidateAll() {
        current = null;
        threads = null;
        group = null;
    }

    static void setCurrentThread(ThreadReference threadReference) {
        if (threadReference == null) {
            current = null;
        } else {
            ThreadInfo threadInfo;
            current = threadInfo = ThreadInfo.getThread(threadReference);
            current.invalidate();
        }
    }

    static void setThreadGroup(ThreadGroupReference threadGroupReference) {
        ThreadInfo.invalidateAll();
        group = threadGroupReference;
    }

    List stack() throws IncompatibleThreadStateException {
        return this.thread.frames();
    }

    static ThreadIterator threadIterator() {
        return new ThreadIterator(ThreadInfo.group());
    }

    static synchronized ThreadInfo[] threads() {
        if (threads == null) {
            ThreadIterator threadIterator = ThreadInfo.threadIterator();
            ArrayList<ThreadInfo> arrayList = new ArrayList<ThreadInfo>();
            while (threadIterator.hasNext()) {
                ThreadInfo threadInfo = new ThreadInfo(threadIterator.nextThread());
                arrayList.add(threadInfo);
            }
            threads = arrayList.toArray(new ThreadInfo[arrayList.size()]);
        }
        return threads;
    }

    void up(int n) throws IncompatibleThreadStateException {
        this.assureSuspended();
        if (this.currentFrameIndex + n >= this.thread.frameCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.currentFrameIndex += n;
    }
}

