/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.ThreadInfo;
import com.sun.tools.example.debug.tty.VMNotConnectedException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

class VMConnection {
    private VirtualMachine vm;
    private Process process = null;
    private int outputCompleteCount = 0;
    private final Connector connector;
    private final Map connectorArgs;
    private final int traceFlags;

    VMConnection(String string, int n) {
        String string2;
        String string3;
        int n2 = string.indexOf(58);
        if (n2 == -1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n2);
            string2 = string.substring(n2 + 1);
        }
        this.connector = this.findConnector(string3);
        if (this.connector == null) {
            throw new IllegalArgumentException("No connector named: " + string3);
        }
        this.connectorArgs = this.parseConnectorArgs(this.connector, string2);
        this.traceFlags = n;
    }

    private VirtualMachine attachTarget() {
        AttachingConnector attachingConnector = (AttachingConnector)this.connector;
        try {
            return attachingConnector.attach(this.connectorArgs);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Env.fatalError("\n Unable to attach to target VM.");
        }
        catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
            illegalConnectorArgumentsException.printStackTrace();
            Env.fatalError("\n Internal debugger error.");
        }
        return null;
    }

    String connectorArg(String string) {
        Connector.Argument argument = (Connector.Argument)this.connectorArgs.get(string);
        if (argument == null) {
            return "";
        }
        return argument.value();
    }

    private void displayRemoteOutput(final InputStream inputStream) {
        Thread thread = new Thread("output reader"){

            public void run() {
                try {
                    try {
                        this.dumpStream(inputStream);
                    }
                    catch (IOException iOException) {
                        Env.fatalError("Failed reading output of child java interpreter.");
                    }
                    Object var2_1 = null;
                    this.notifyOutputComplete();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.notifyOutputComplete();
                    throw throwable;
                }
            }
        };
        thread.setPriority(9);
        thread.start();
    }

    public void disposeVM() {
        block4: {
            try {
                if (this.vm == null) break block4;
                this.vm.dispose();
                this.vm = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.process != null) {
                    this.process.destroy();
                    this.process = null;
                }
                this.waitOutputComplete();
                throw throwable;
            }
        }
        Object var2_1 = null;
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        this.waitOutputComplete();
    }

    private void dumpFailedLaunchInfo(Process process) {
        try {
            this.dumpStream(process.getErrorStream());
            this.dumpStream(process.getInputStream());
        }
        catch (IOException iOException) {
            System.err.println("Unable to display process output: " + iOException.getMessage());
        }
    }

    private void dumpStream(InputStream inputStream) throws IOException {
        String string;
        PrintStream printStream = Env.out;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            printStream.println(string);
        }
    }

    private Connector findConnector(String string) {
        List list = Bootstrap.virtualMachineManager().allConnectors();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Connector connector = (Connector)iterator.next();
            if (!connector.name().equals(string)) continue;
            return connector;
        }
        return null;
    }

    boolean isLaunch() {
        return this.connector instanceof LaunchingConnector;
    }

    boolean isOpen() {
        return this.vm != null;
    }

    private VirtualMachine launchTarget() {
        LaunchingConnector launchingConnector = (LaunchingConnector)this.connector;
        try {
            VirtualMachine virtualMachine = launchingConnector.launch(this.connectorArgs);
            this.process = virtualMachine.process();
            this.displayRemoteOutput(this.process.getErrorStream());
            this.displayRemoteOutput(this.process.getInputStream());
            return virtualMachine;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Env.fatalError("\n Unable to launch target VM.");
        }
        catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
            illegalConnectorArgumentsException.printStackTrace();
            Env.fatalError("\n Internal debugger error.");
        }
        catch (VMStartException vMStartException) {
            System.err.println(String.valueOf(vMStartException.getMessage()) + "\n");
            this.dumpFailedLaunchInfo(vMStartException.process());
            Env.fatalError("\n Target VM failed to initialize.");
        }
        return null;
    }

    private VirtualMachine listenTarget() {
        ListeningConnector listeningConnector = (ListeningConnector)this.connector;
        try {
            String string = listeningConnector.startListening(this.connectorArgs);
            System.out.println("Listening at address: " + string);
            this.vm = listeningConnector.accept(this.connectorArgs);
            listeningConnector.stopListening(this.connectorArgs);
            return this.vm;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Env.fatalError("\n Unable to attach to target VM.");
        }
        catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
            illegalConnectorArgumentsException.printStackTrace();
            Env.fatalError("\n Internal debugger error.");
        }
        return null;
    }

    synchronized void notifyOutputComplete() {
        ++this.outputCompleteCount;
        this.notifyAll();
    }

    synchronized VirtualMachine open() {
        if (this.connector instanceof LaunchingConnector) {
            this.vm = this.launchTarget();
        } else if (this.connector instanceof AttachingConnector) {
            this.vm = this.attachTarget();
            ThreadInfo.setCurrentThread(ThreadInfo.getThread((int)1).thread);
        } else if (this.connector instanceof ListeningConnector) {
            this.vm = this.listenTarget();
            ThreadInfo.setCurrentThread(ThreadInfo.getThread((int)1).thread);
        } else {
            throw new InternalError("Invalid connect type");
        }
        this.vm.setDebugTraceMode(this.traceFlags);
        this.setEventRequests(this.vm);
        this.resolveEventRequests();
        return this.vm;
    }

    private Map parseConnectorArgs(Connector connector, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Map map = connector.defaultArguments();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n == -1) {
                throw new IllegalArgumentException("Illegal connector argument: " + string2);
            }
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            Connector.Argument argument = (Connector.Argument)map.get(string3);
            if (argument == null) {
                throw new IllegalArgumentException("Argument " + string3 + " is not defined for connector: " + connector.name());
            }
            argument.setValue(string4);
        }
        return map;
    }

    private void resolveEventRequests() {
        Env.specList.resolveAll();
    }

    boolean setConnectorArg(String string, String string2) {
        if (this.vm != null) {
            return false;
        }
        Connector.Argument argument = (Connector.Argument)this.connectorArgs.get(string);
        if (argument == null) {
            return false;
        }
        argument.setValue(string2);
        return true;
    }

    private void setEventRequests(VirtualMachine virtualMachine) {
        EventRequestManager eventRequestManager = virtualMachine.eventRequestManager();
        ExceptionRequest exceptionRequest = eventRequestManager.createExceptionRequest(null, false, true);
        exceptionRequest.enable();
    }

    public synchronized VirtualMachine vm() {
        if (this.vm == null) {
            throw new VMNotConnectedException();
        }
        return this.vm;
    }

    synchronized void waitOutputComplete() {
        if (this.process != null) {
            while (this.outputCompleteCount < 2) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

