/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.Transport;
import com.sun.jdi.connect.VMStartException;
import com.sun.tools.jdi.ConnectionService;
import com.sun.tools.jdi.ConnectorImpl;
import com.sun.tools.jdi.TransportService;
import com.sun.tools.jdi.VirtualMachineManagerService;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;

abstract class AbstractLauncher
extends ConnectorImpl
implements LaunchingConnector {
    private TransportService transport;

    AbstractLauncher(VirtualMachineManagerService virtualMachineManagerService, TransportService transportService) {
        super(virtualMachineManagerService);
        this.transport = transportService;
    }

    static /* synthetic */ TransportService access$0(AbstractLauncher abstractLauncher) {
        return abstractLauncher.transport;
    }

    public abstract String description();

    public abstract VirtualMachine launch(Map var1) throws IOException, IllegalConnectorArgumentsException, VMStartException;

    protected VirtualMachine launch(String[] stringArray, String string) throws IOException, VMStartException {
        Helper helper = new Helper(stringArray, string);
        helper.launchAndAccept();
        return this.manager().createVirtualMachine(helper.connection(), helper.process());
    }

    public abstract String name();

    String[] tokenizeCommand(String string, char c) {
        String[] stringArray;
        String string2 = String.valueOf(c);
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(c) + " \t\r\n\f", true);
        String string3 = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            if (string3 != null) {
                if (stringArray.equals(string2)) {
                    arrayList.add(string3);
                    string3 = null;
                    continue;
                }
                string3 = String.valueOf(string3) + (String)stringArray;
                continue;
            }
            if (stringArray.equals(string2)) {
                string3 = "";
                continue;
            }
            if (stringArray.length() == 1 && Character.isWhitespace(stringArray.charAt(0))) continue;
            arrayList.add(stringArray);
        }
        if (string3 != null) {
            arrayList.add(string3);
        }
        stringArray = new String[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            stringArray[n] = (String)arrayList.get(n);
            ++n;
        }
        return stringArray;
    }

    public Transport transport() {
        return this.transport;
    }

    protected TransportService transportService() {
        return this.transport;
    }

    private class Helper {
        private final String address;
        private final String[] commandArray;
        private Process process = null;
        private ConnectionService connection = null;
        private IOException acceptException = null;
        private boolean exited = false;

        Helper(String[] stringArray, String string) {
            this.commandArray = stringArray;
            this.address = string;
        }

        Thread acceptConnection() {
            Thread thread = new Thread(this, "connection acceptor"){
                private final /* synthetic */ Helper this$1;
                {
                    this.this$1 = helper;
                }

                public void run() {
                    try {
                        ConnectionService connectionService = AbstractLauncher.access$0(Helper.access$1(this.this$1)).accept(Helper.access$2(this.this$1));
                        this.this$1.notifyOfConnection(connectionService);
                    }
                    catch (InterruptedIOException interruptedIOException) {
                    }
                    catch (IOException iOException) {
                        this.this$1.notifyOfAcceptException(iOException);
                    }
                }
            };
            thread.start();
            return thread;
        }

        static /* synthetic */ Process access$0(Helper helper) {
            return helper.process;
        }

        static /* synthetic */ AbstractLauncher access$1(Helper helper) {
            return helper.AbstractLauncher.this;
        }

        static /* synthetic */ String access$2(Helper helper) {
            return helper.address;
        }

        String commandString() {
            String string = "";
            int n = 0;
            while (n < this.commandArray.length) {
                if (n > 0) {
                    string = String.valueOf(string) + " ";
                }
                string = String.valueOf(string) + this.commandArray[n];
                ++n;
            }
            return string;
        }

        ConnectionService connection() {
            return this.connection;
        }

        synchronized void launchAndAccept() throws IOException, VMStartException {
            this.process = Runtime.getRuntime().exec(this.commandArray);
            Thread thread = this.acceptConnection();
            Thread thread2 = this.monitorTarget();
            try {
                try {
                    while (this.connection == null && this.acceptException == null && !this.exited) {
                        this.wait();
                    }
                    if (this.exited) {
                        throw new VMStartException("VM initialization failed for: " + this.commandString(), this.process);
                    }
                    if (this.acceptException != null) {
                        throw this.acceptException;
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException("Interrupted during accept");
                }
                Object var4_3 = null;
                thread.interrupt();
                thread2.interrupt();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                thread.interrupt();
                thread2.interrupt();
                throw throwable;
            }
        }

        Thread monitorTarget() {
            Thread thread = new Thread(this, "launched target monitor"){
                private final /* synthetic */ Helper this$1;
                {
                    this.this$1 = helper;
                }

                public void run() {
                    try {
                        Helper.access$0(this.this$1).waitFor();
                        this.this$1.notifyOfExit();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            };
            thread.start();
            return thread;
        }

        synchronized void notifyOfAcceptException(IOException iOException) {
            this.acceptException = iOException;
            this.notify();
        }

        synchronized void notifyOfConnection(ConnectionService connectionService) {
            this.connection = connectionService;
            this.notify();
        }

        synchronized void notifyOfExit() {
            this.exited = true;
            this.notify();
        }

        Process process() {
            return this.process;
        }
    }
}

