/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.ArrayTypeImpl;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.ValueContainer;
import com.sun.tools.jdi.ValueImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.List;

public class ArrayReferenceImpl
extends ObjectReferenceImpl
implements ArrayReference {
    int length = -1;

    ArrayReferenceImpl(VirtualMachine virtualMachine, long l) {
        super(virtualMachine, l);
    }

    ArrayTypeImpl arrayType() {
        return (ArrayTypeImpl)this.type();
    }

    public Value getValue(int n) {
        List list = this.getValues(n, 1);
        return (Value)list.get(0);
    }

    public List getValues() {
        return this.getValues(0, -1);
    }

    public List getValues(int n, int n2) {
        List list;
        this.validateArrayAccess(n, n2);
        try {
            list = JDWP.ArrayReference.GetValues.process((VirtualMachineImpl)this.vm, (ArrayReferenceImpl)this, (int)n, (int)n2).values;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        return list;
    }

    public int length() {
        if (this.length == -1) {
            ArrayReferenceImpl arrayReferenceImpl = this;
            synchronized (arrayReferenceImpl) {
                if (this.length != -1) {
                    int n = this.length;
                    Object var3_3 = null;
                    return n;
                }
                try {
                    this.length = JDWP.ArrayReference.Length.process((VirtualMachineImpl)this.vm, (ArrayReferenceImpl)this).arrayLength;
                }
                catch (JDWPException jDWPException) {
                    throw jDWPException.toJDIException();
                }
            }
        }
        return this.length;
    }

    public void setValue(int n, Value value) throws InvalidTypeException, ClassNotLoadedException {
        ArrayList<Value> arrayList = new ArrayList<Value>(1);
        arrayList.add(value);
        this.setValues(n, arrayList, 0, 1);
    }

    public void setValues(int n, List list, int n2, int n3) throws InvalidTypeException, ClassNotLoadedException {
        this.validateMirrorsOrNulls(list);
        this.validateArrayAccess(n, n3);
        if (n3 == -1) {
            n3 = this.length() - n;
        }
        if (n3 > 0) {
            boolean bl = false;
            ValueImpl[] valueImplArray = new ValueImpl[n3];
            int n4 = 0;
            while (n4 < n3) {
                ValueImpl valueImpl = (ValueImpl)list.get(n2 + n4);
                try {
                    valueImplArray[n4] = ValueImpl.prepareForAssignment(valueImpl, new Component());
                }
                catch (ClassNotLoadedException classNotLoadedException) {
                    if (valueImpl == null) {
                        bl = true;
                    }
                    throw classNotLoadedException;
                }
                ++n4;
            }
            if (!bl) {
                try {
                    JDWP.ArrayReference.SetValues.process(this.vm, this, n, valueImplArray);
                }
                catch (JDWPException jDWPException) {
                    throw jDWPException.toJDIException();
                }
            }
        }
    }

    public void setValues(List list) throws InvalidTypeException, ClassNotLoadedException {
        this.setValues(0, list, 0, -1);
    }

    public String toString() {
        return "instance of " + this.arrayType().componentTypeName() + "[" + this.length() + "] (id=" + this.uniqueID() + ")";
    }

    byte typeValueKey() {
        return 91;
    }

    void validateArrayAccess(int n, int n2) {
        int n3 = n;
        if (n2 < -1) {
            throw new IndexOutOfBoundsException("Invalid array range length: " + n2);
        }
        if (n2 == -1 || n2 == 0) {
            if (n < 0 || n >= this.length()) {
                throw new IndexOutOfBoundsException("Invalid array index: " + n);
            }
        } else if (n < 0 || n + n2 > this.length()) {
            throw new IndexOutOfBoundsException("Invalid array range: " + n + " to " + (n + n2 - 1));
        }
    }

    void validateAssignment(ValueContainer valueContainer) throws InvalidTypeException, ClassNotLoadedException {
        block3: {
            try {
                super.validateAssignment(valueContainer);
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                boolean bl = false;
                JNITypeParser jNITypeParser = new JNITypeParser(valueContainer.signature());
                JNITypeParser jNITypeParser2 = new JNITypeParser(this.arrayType().signature());
                int n = jNITypeParser.dimensionCount();
                if (n <= jNITypeParser2.dimensionCount()) {
                    String string = jNITypeParser.componentSignature(n);
                    Type type = valueContainer.findType(string);
                    String string2 = jNITypeParser2.componentSignature(n);
                    Type type2 = this.arrayType().findComponentType(string2);
                    bl = ArrayTypeImpl.isComponentAssignable(type, type2);
                }
                if (bl) break block3;
                throw new InvalidTypeException("Cannot assign " + this.arrayType().name() + " to " + valueContainer.typeName());
            }
        }
    }

    class Component
    implements ValueContainer {
        Component() {
        }

        public Type findType(String string) throws ClassNotLoadedException {
            return ArrayReferenceImpl.this.arrayType().findComponentType(string);
        }

        public String signature() {
            return ArrayReferenceImpl.this.arrayType().componentSignature();
        }

        public Type type() throws ClassNotLoadedException {
            return ArrayReferenceImpl.this.arrayType().componentType();
        }

        public String typeName() {
            return ArrayReferenceImpl.this.arrayType().componentTypeName();
        }
    }
}

