/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.PacketStream;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ArrayTypeImpl
extends ReferenceTypeImpl
implements ArrayType {
    protected ArrayTypeImpl(VirtualMachine virtualMachine, long l) {
        super(virtualMachine, l);
    }

    void addVisibleMethods(Map map) {
    }

    public List allMethods() {
        return new ArrayList(0);
    }

    public String componentSignature() {
        return this.signature().substring(1);
    }

    public Type componentType() throws ClassNotLoadedException {
        return this.findComponentType(this.componentSignature());
    }

    public String componentTypeName() {
        JNITypeParser jNITypeParser = new JNITypeParser(this.componentSignature());
        return jNITypeParser.typeName();
    }

    public boolean failedToInitialize() {
        return false;
    }

    Type findComponentType(String string) throws ClassNotLoadedException {
        byte by;
        block1: {
            by = (byte)string.charAt(0);
            if (!PacketStream.isObjectTag(by)) break block1;
            JNITypeParser jNITypeParser = new JNITypeParser(this.componentSignature());
            List list = this.vm.classesByName(jNITypeParser.typeName());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ReferenceType referenceType;
                block3: {
                    boolean bl;
                    block4: {
                        ClassLoaderReference classLoaderReference;
                        block2: {
                            referenceType = (ReferenceType)iterator.next();
                            classLoaderReference = referenceType.classLoader();
                            if (classLoaderReference != null) break block2;
                            if (this.classLoader() == null) break block3;
                            bl = false;
                            break block4;
                        }
                        bl = classLoaderReference.equals(this.classLoader());
                    }
                    if (!bl) continue;
                }
                return referenceType;
            }
            throw new ClassNotLoadedException(this.componentTypeName());
        }
        return this.vm.primitiveTypeMirror(by);
    }

    List inheritedTypes() {
        return new ArrayList(0);
    }

    public boolean isAbstract() {
        return false;
    }

    boolean isAssignableTo(ReferenceType referenceType) {
        if (referenceType instanceof ArrayType) {
            try {
                Type type = ((ArrayType)referenceType).componentType();
                return ArrayTypeImpl.isComponentAssignable(type, this.componentType());
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                return false;
            }
        }
        if (referenceType instanceof InterfaceType) {
            return referenceType.name().equals("java.lang.Cloneable");
        }
        return referenceType.name().equals("java.lang.Object");
    }

    static boolean isComponentAssignable(Type type, Type type2) {
        if (type2 instanceof PrimitiveType) {
            return type2.equals(type);
        }
        if (type instanceof PrimitiveType) {
            return false;
        }
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)type2;
        ReferenceTypeImpl referenceTypeImpl2 = (ReferenceTypeImpl)type;
        return referenceTypeImpl.isAssignableTo(referenceTypeImpl2);
    }

    public boolean isFinal() {
        return true;
    }

    public boolean isInitialized() {
        return true;
    }

    public boolean isPrepared() {
        return true;
    }

    boolean isPrimitiveArray() {
        char c = this.signature().charAt(1);
        return c != 'L' && c != '[';
    }

    public boolean isVerified() {
        return true;
    }

    public ArrayReference newInstance(int n) {
        try {
            return (ArrayReference)((Object)JDWP.ArrayType.NewInstance.process((VirtualMachineImpl)this.vm, (ArrayTypeImpl)this, (int)n).newArray);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    public String toString() {
        return "array class " + this.name() + " (" + this.loaderString() + ")";
    }

    Type type() throws ClassNotLoadedException {
        return this.findType(this.componentSignature());
    }
}

