/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.VMAction;
import com.sun.tools.jdi.VMListener;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ClassLoaderReferenceImpl
extends ObjectReferenceImpl
implements ClassLoaderReference,
VMListener {
    List cachedVisibleClasses = null;

    ClassLoaderReferenceImpl(VirtualMachine virtualMachine, long l) {
        super(virtualMachine, l);
        this.vm.addListener(this);
    }

    public List definedClasses() {
        ArrayList<ReferenceType> arrayList = new ArrayList<ReferenceType>();
        Iterator iterator = this.vm.allClasses().iterator();
        while (iterator.hasNext()) {
            ReferenceType referenceType = (ReferenceType)iterator.next();
            if (!this.equals(referenceType.classLoader())) continue;
            arrayList.add(referenceType);
        }
        return arrayList;
    }

    Type findType(String string) throws ClassNotLoadedException {
        Object object;
        List list = this.visibleClasses();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (ReferenceType)iterator.next();
            if (!object.signature().equals(string)) continue;
            return object;
        }
        object = new JNITypeParser(string);
        throw new ClassNotLoadedException(((JNITypeParser)object).typeName(), "Class " + ((JNITypeParser)object).typeName() + " not loaded");
    }

    byte typeValueKey() {
        return 108;
    }

    public synchronized List visibleClasses() {
        try {
            List list = this.cachedVisibleClasses;
            if (list == null) {
                JDWP.ClassLoaderReference.VisibleClasses.ClassInfo[] classInfoArray = JDWP.ClassLoaderReference.VisibleClasses.process((VirtualMachineImpl)this.vm, (ClassLoaderReferenceImpl)this).classes;
                list = new ArrayList<ReferenceTypeImpl>(classInfoArray.length);
                int n = 0;
                while (n < classInfoArray.length) {
                    list.add(this.vm.referenceType(classInfoArray[n].typeID, classInfoArray[n].refTypeTag));
                    ++n;
                }
                list = Collections.unmodifiableList(list);
                VirtualMachineImpl.State state = this.vm.state();
                synchronized (state) {
                    if (this.vm.state().isFrozen()) {
                        this.cachedVisibleClasses = list;
                        if ((this.vm.traceFlags & 0x10) != 0) {
                            this.vm.printTrace("ClassLoaderReference " + this.uniqueID() + " temporarily caching visible classes (count = " + list.size() + ")");
                        }
                    }
                }
            }
            return list;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    public boolean vmNotSuspended(VMAction vMAction) {
        if ((this.vm.traceFlags & 0x10) != 0) {
            this.vm.printTrace("Clearing temporary cache for ClassLoaderReference " + this.uniqueID());
        }
        this.cachedVisibleClasses = null;
        return super.vmNotSuspended(vMAction);
    }

    public boolean vmSuspended(VMAction vMAction) {
        super.vmSuspended(vMAction);
        return true;
    }
}

