/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.CommandSender;
import com.sun.tools.jdi.FieldImpl;
import com.sun.tools.jdi.InterfaceTypeImpl;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.MethodImpl;
import com.sun.tools.jdi.PacketStream;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.ThreadReferenceImpl;
import com.sun.tools.jdi.ValueImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ClassTypeImpl
extends ReferenceTypeImpl
implements ClassType {
    private boolean cachedSuperclass = false;
    private ClassType superclass = null;
    private Map lineMapper = null;
    private int lastLine = -1;
    private List interfaces = null;

    protected ClassTypeImpl(VirtualMachine virtualMachine, long l) {
        super(virtualMachine, l);
    }

    void addInterfaces(List list) {
        ReferenceTypeImpl referenceTypeImpl;
        List list2 = this.interfaces();
        list.addAll(this.interfaces());
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            referenceTypeImpl = (InterfaceTypeImpl)iterator.next();
            ((InterfaceTypeImpl)referenceTypeImpl).addSuperinterfaces(list);
        }
        referenceTypeImpl = (ClassTypeImpl)this.superclass();
        if (referenceTypeImpl != null) {
            ((ClassTypeImpl)referenceTypeImpl).addInterfaces(list);
        }
    }

    void addVisibleMethods(Map map) {
        ReferenceTypeImpl referenceTypeImpl;
        Iterator iterator = this.interfaces().iterator();
        while (iterator.hasNext()) {
            referenceTypeImpl = (InterfaceTypeImpl)iterator.next();
            ((InterfaceTypeImpl)referenceTypeImpl).addVisibleMethods(map);
        }
        referenceTypeImpl = (ClassTypeImpl)this.superclass();
        if (referenceTypeImpl != null) {
            ((ClassTypeImpl)referenceTypeImpl).addVisibleMethods(map);
        }
        this.addToMethodMap(map, this.methods());
    }

    public List allInterfaces() {
        ArrayList arrayList = new ArrayList();
        this.addInterfaces(arrayList);
        return arrayList;
    }

    public List allMethods() {
        ArrayList arrayList = new ArrayList(this.methods());
        ClassType classType = this.superclass();
        while (classType != null) {
            arrayList.addAll(classType.methods());
            classType = classType.superclass();
        }
        Iterator iterator = this.allInterfaces().iterator();
        while (iterator.hasNext()) {
            InterfaceType interfaceType = (InterfaceType)iterator.next();
            arrayList.addAll(interfaceType.methods());
        }
        return arrayList;
    }

    public Method concreteMethodByName(String string, String string2) {
        List list = this.visibleMethods();
        Method method = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Method method2 = (Method)iterator.next();
            if (!method2.name().equals(string) || !method2.signature().equals(string2) || method2.isAbstract()) continue;
            method = method2;
            break;
        }
        return method;
    }

    List inheritedTypes() {
        ArrayList<ClassType> arrayList = new ArrayList<ClassType>(this.interfaces());
        if (this.superclass() != null) {
            arrayList.add(0, this.superclass());
        }
        return arrayList;
    }

    public List interfaces() {
        if (this.interfaces == null) {
            ClassTypeImpl classTypeImpl = this;
            synchronized (classTypeImpl) {
                if (this.interfaces == null) {
                    this.interfaces = this.getInterfaces();
                }
            }
        }
        return this.interfaces;
    }

    public Value invokeMethod(ThreadReference threadReference, Method method, List list, int n) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        JDWP.ClassType.InvokeMethod invokeMethod;
        this.validateMirror(threadReference);
        this.validateMirror(method);
        this.validateMirrorsOrNulls(list);
        MethodImpl methodImpl = (MethodImpl)method;
        ThreadReferenceImpl threadReferenceImpl = (ThreadReferenceImpl)threadReference;
        this.validateMethodInvocation(methodImpl, list, n);
        methodImpl.prepareArgumentsForInvoke(list);
        ValueImpl[] valueImplArray = list.toArray(new ValueImpl[0]);
        try {
            PacketStream packetStream = this.sendInvokeCommand(threadReferenceImpl, methodImpl, valueImplArray, n);
            invokeMethod = JDWP.ClassType.InvokeMethod.waitForReply(this.vm, packetStream);
        }
        catch (JDWPException jDWPException) {
            if (jDWPException.errorCode() == 10) {
                throw new IncompatibleThreadStateException();
            }
            throw jDWPException.toJDIException();
        }
        if ((n & 1) == 0) {
            this.vm.notifySuspend();
        }
        if (invokeMethod.exception != null) {
            throw new InvocationException(invokeMethod.exception);
        }
        return invokeMethod.returnValue;
    }

    boolean isAssignableTo(ReferenceType referenceType) {
        ClassTypeImpl classTypeImpl = (ClassTypeImpl)this.superclass();
        if (this.equals(referenceType)) {
            return true;
        }
        if (classTypeImpl != null && classTypeImpl.isAssignableTo(referenceType)) {
            return true;
        }
        List list = this.interfaces();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            InterfaceTypeImpl interfaceTypeImpl = (InterfaceTypeImpl)iterator.next();
            if (!interfaceTypeImpl.isAssignableTo(referenceType)) continue;
            return true;
        }
        return false;
    }

    public ObjectReference newInstance(ThreadReference threadReference, Method method, List list, int n) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        this.validateMirror(threadReference);
        this.validateMirror(method);
        this.validateMirrorsOrNulls(list);
        MethodImpl methodImpl = (MethodImpl)method;
        ThreadReferenceImpl threadReferenceImpl = (ThreadReferenceImpl)threadReference;
        this.validateConstructorInvocation(methodImpl, list, n);
        methodImpl.prepareArgumentsForInvoke(list);
        ValueImpl[] valueImplArray = list.toArray(new ValueImpl[0]);
        JDWP.ClassType.NewInstance newInstance = null;
        try {
            PacketStream packetStream = this.sendNewInstanceCommand(threadReferenceImpl, methodImpl, valueImplArray, n);
            newInstance = JDWP.ClassType.NewInstance.waitForReply(this.vm, packetStream);
        }
        catch (JDWPException jDWPException) {
            if (jDWPException.errorCode() == 10) {
                throw new IncompatibleThreadStateException();
            }
            throw jDWPException.toJDIException();
        }
        if ((n & 1) == 0) {
            this.vm.notifySuspend();
        }
        if (newInstance.exception != null) {
            throw new InvocationException(newInstance.exception);
        }
        return newInstance.newObject;
    }

    PacketStream sendInvokeCommand(final ThreadReferenceImpl threadReferenceImpl, final MethodImpl methodImpl, final ValueImpl[] valueImplArray, final int n) {
        CommandSender commandSender = new CommandSender(){

            public PacketStream send() {
                return JDWP.ClassType.InvokeMethod.enqueueCommand(vm, this, threadReferenceImpl, methodImpl.ref(), valueImplArray, n);
            }
        };
        PacketStream packetStream = (n & 1) != 0 ? threadReferenceImpl.sendResumingCommand(commandSender) : this.vm.sendResumingCommand(commandSender);
        return packetStream;
    }

    PacketStream sendNewInstanceCommand(final ThreadReferenceImpl threadReferenceImpl, final MethodImpl methodImpl, final ValueImpl[] valueImplArray, final int n) {
        CommandSender commandSender = new CommandSender(){

            public PacketStream send() {
                return JDWP.ClassType.NewInstance.enqueueCommand(vm, this, threadReferenceImpl, methodImpl.ref(), valueImplArray, n);
            }
        };
        PacketStream packetStream = (n & 1) != 0 ? threadReferenceImpl.sendResumingCommand(commandSender) : this.vm.sendResumingCommand(commandSender);
        return packetStream;
    }

    public void setValue(Field field, Value value) throws InvalidTypeException, ClassNotLoadedException {
        block5: {
            this.validateMirror(field);
            this.validateMirrorOrNull(value);
            this.validateFieldSet(field);
            if (!field.isStatic()) {
                throw new IllegalArgumentException("Must set non-static field through an instance");
            }
            try {
                JDWP.ClassType.SetValues.FieldValue[] fieldValueArray = new JDWP.ClassType.SetValues.FieldValue[]{new JDWP.ClassType.SetValues.FieldValue(((FieldImpl)field).ref(), ValueImpl.prepareForAssignment(value, (FieldImpl)field))};
                try {
                    JDWP.ClassType.SetValues.process(this.vm, this, fieldValueArray);
                }
                catch (JDWPException jDWPException) {
                    throw jDWPException.toJDIException();
                }
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                if (value == null) break block5;
                throw classNotLoadedException;
            }
        }
    }

    public List subclasses() {
        List list = this.vm.allClasses();
        ArrayList<ReferenceType> arrayList = new ArrayList<ReferenceType>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ClassType classType;
            ClassType classType2;
            ReferenceType referenceType = (ReferenceType)iterator.next();
            if (!(referenceType instanceof ClassType) || (classType2 = (classType = (ClassType)referenceType).superclass()) == null || !classType2.equals(this)) continue;
            arrayList.add(referenceType);
        }
        return arrayList;
    }

    public ClassType superclass() {
        if (!this.cachedSuperclass) {
            ClassTypeImpl classTypeImpl = this;
            synchronized (classTypeImpl) {
                if (this.cachedSuperclass) {
                    ClassType classType = this.superclass;
                    Object var3_3 = null;
                    return classType;
                }
                ClassTypeImpl classTypeImpl2 = null;
                try {
                    classTypeImpl2 = JDWP.ClassType.Superclass.process((VirtualMachineImpl)this.vm, (ClassTypeImpl)this).superclass;
                }
                catch (JDWPException jDWPException) {
                    throw jDWPException.toJDIException();
                }
                if (classTypeImpl2 != null) {
                    this.superclass = classTypeImpl2;
                }
                this.cachedSuperclass = true;
            }
        }
        return this.superclass;
    }

    public String toString() {
        return "class " + this.name() + " (" + this.loaderString() + ")";
    }

    void validateConstructorInvocation(Method method, List list, int n) throws InvalidTypeException, InvocationException {
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)method.declaringType();
        if (!referenceTypeImpl.equals(this)) {
            throw new IllegalArgumentException("Invalid constructor");
        }
        if (!method.isConstructor()) {
            throw new IllegalArgumentException("Cannot create instance with non-constructor");
        }
        JNITypeParser jNITypeParser = new JNITypeParser(method.signature());
        List list2 = jNITypeParser.argumentSignatures();
        if (list2.size() != list.size()) {
            throw new IllegalArgumentException("Invalid argument count");
        }
    }

    void validateMethodInvocation(Method method, List list, int n) throws InvalidTypeException, InvocationException {
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)method.declaringType();
        if (!referenceTypeImpl.isAssignableFrom(this)) {
            throw new IllegalArgumentException("Invalid method");
        }
        if (!method.isStatic()) {
            throw new IllegalArgumentException("Cannot invoke instance method on a class type");
        }
        if (method.isStaticInitializer()) {
            throw new IllegalArgumentException("Cannot invoke static initializer");
        }
        JNITypeParser jNITypeParser = new JNITypeParser(method.signature());
        List list2 = jNITypeParser.argumentSignatures();
        if (list2.size() != list.size()) {
            throw new IllegalArgumentException("Invalid argument count");
        }
    }
}

