/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.DuplicateRequestException;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.InvalidRequestStateException;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import com.sun.jdi.request.StepRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import com.sun.jdi.request.WatchpointRequest;
import com.sun.tools.jdi.ClassTypeImpl;
import com.sun.tools.jdi.FieldImpl;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.MirrorImpl;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.ThreadReferenceImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class EventRequestManagerImpl
extends MirrorImpl
implements EventRequestManager {
    List[] requestLists;
    static /* synthetic */ Class class$com$sun$tools$jdi$JDWP$EventKind;

    EventRequestManagerImpl(VirtualMachine virtualMachine) {
        super(virtualMachine);
        int n;
        Field[] fieldArray = (class$com$sun$tools$jdi$JDWP$EventKind != null ? class$com$sun$tools$jdi$JDWP$EventKind : (class$com$sun$tools$jdi$JDWP$EventKind = EventRequestManagerImpl.class$("com.sun.tools.jdi.JDWP$EventKind"))).getDeclaredFields();
        int n2 = 0;
        int n3 = 0;
        while (n3 < fieldArray.length) {
            try {
                n = fieldArray[n3].getInt(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Got: " + illegalAccessException);
            }
            if (n > n2) {
                n2 = n;
            }
            ++n3;
        }
        this.requestLists = new List[n2 + 1];
        n = 0;
        while (n <= n2) {
            this.requestLists[n] = new ArrayList();
            ++n;
        }
    }

    static byte JDItoJDWPSuspendPolicy(int n) {
        switch (n) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Illegal policy constant: " + n);
    }

    static int JDWPtoJDISuspendPolicy(byte by) {
        switch (by) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Illegal policy constant: " + by);
    }

    public List accessWatchpointRequests() {
        return this.unmodifiableRequestList(20);
    }

    public List breakpointRequests() {
        return this.unmodifiableRequestList(2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public List classPrepareRequests() {
        return this.unmodifiableRequestList(8);
    }

    public List classUnloadRequests() {
        return this.unmodifiableRequestList(9);
    }

    public AccessWatchpointRequest createAccessWatchpointRequest(com.sun.jdi.Field field) {
        this.validateMirror(field);
        return new AccessWatchpointRequestImpl(field);
    }

    public BreakpointRequest createBreakpointRequest(Location location) {
        this.validateMirror(location);
        return new BreakpointRequestImpl(location);
    }

    public ClassPrepareRequest createClassPrepareRequest() {
        return new ClassPrepareRequestImpl();
    }

    public ClassUnloadRequest createClassUnloadRequest() {
        return new ClassUnloadRequestImpl();
    }

    public ExceptionRequest createExceptionRequest(ReferenceType referenceType, boolean bl, boolean bl2) {
        this.validateMirrorOrNull(referenceType);
        return new ExceptionRequestImpl(referenceType, bl, bl2);
    }

    public MethodEntryRequest createMethodEntryRequest() {
        return new MethodEntryRequestImpl();
    }

    public MethodExitRequest createMethodExitRequest() {
        return new MethodExitRequestImpl();
    }

    public ModificationWatchpointRequest createModificationWatchpointRequest(com.sun.jdi.Field field) {
        this.validateMirror(field);
        return new ModificationWatchpointRequestImpl(field);
    }

    public StepRequest createStepRequest(ThreadReference threadReference, int n, int n2) {
        this.validateMirror(threadReference);
        return new StepRequestImpl(threadReference, n, n2);
    }

    public ThreadDeathRequest createThreadDeathRequest() {
        return new ThreadDeathRequestImpl();
    }

    public ThreadStartRequest createThreadStartRequest() {
        return new ThreadStartRequestImpl();
    }

    public void deleteAllBreakpoints() {
        this.requestList(2).clear();
        try {
            JDWP.EventRequest.ClearAllBreakpoints.process(this.vm);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    public void deleteEventRequest(EventRequest eventRequest) {
        this.validateMirror(eventRequest);
        ((EventRequestImpl)eventRequest).delete();
    }

    public void deleteEventRequests(List list) {
        this.validateMirrors(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((EventRequestImpl)iterator.next()).delete();
        }
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public List exceptionRequests() {
        return this.unmodifiableRequestList(4);
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public List methodEntryRequests() {
        return this.unmodifiableRequestList(40);
    }

    public List methodExitRequests() {
        return this.unmodifiableRequestList(41);
    }

    public List modificationWatchpointRequests() {
        return this.unmodifiableRequestList(21);
    }

    EventRequest request(int n, int n2) {
        List list = this.requestList(n);
        int n3 = list.size() - 1;
        while (n3 >= 0) {
            EventRequestImpl eventRequestImpl = (EventRequestImpl)list.get(n3);
            if (eventRequestImpl.id == n2) {
                return eventRequestImpl;
            }
            --n3;
        }
        return null;
    }

    List requestList(int n) {
        return this.requestLists[n];
    }

    public List stepRequests() {
        return this.unmodifiableRequestList(1);
    }

    public List threadDeathRequests() {
        return this.unmodifiableRequestList(7);
    }

    public List threadStartRequests() {
        return this.unmodifiableRequestList(6);
    }

    List unmodifiableRequestList(int n) {
        return Collections.unmodifiableList(this.requestList(n));
    }

    abstract class EventRequestImpl
    extends MirrorImpl
    implements EventRequest {
        int id;
        List filters = new ArrayList();
        boolean isEnabled = false;
        boolean deleted = false;
        byte suspendPolicy = (byte)2;
        private Map clientProperties = null;

        EventRequestImpl() {
            super(EventRequestManagerImpl.this.vm);
            this.requestList().add(this);
        }

        public synchronized void addCountFilter(int n) {
            if (this.isEnabled()) {
                throw new InvalidRequestStateException();
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.Count.create(n));
        }

        synchronized void clear() {
            try {
                JDWP.EventRequest.Clear.process(this.vm, (byte)this.eventCmd(), this.id);
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
            this.isEnabled = false;
        }

        void delete() {
            this.requestList().remove(this);
            this.disable();
            this.deleted = true;
        }

        public void disable() {
            this.setEnabled(false);
        }

        public void enable() {
            this.setEnabled(true);
        }

        public boolean equals(Object object) {
            return this == object;
        }

        abstract int eventCmd();

        private Map getProperties() {
            if (this.clientProperties == null) {
                this.clientProperties = new HashMap(2);
            }
            return this.clientProperties;
        }

        public final Object getProperty(Object object) {
            if (this.clientProperties == null) {
                return null;
            }
            return this.getProperties().get(object);
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public final void putProperty(Object object, Object object2) {
            if (object2 != null) {
                this.getProperties().put(object, object2);
            } else {
                this.getProperties().remove(object);
            }
        }

        List requestList() {
            return EventRequestManagerImpl.this.requestList(this.eventCmd());
        }

        synchronized void set() {
            JDWP.EventRequest.Set.Modifier[] modifierArray = this.filters.toArray(new JDWP.EventRequest.Set.Modifier[this.filters.size()]);
            try {
                this.id = JDWP.EventRequest.Set.process((VirtualMachineImpl)this.vm, (byte)((byte)this.eventCmd()), (byte)this.suspendPolicy, (JDWP.EventRequest.Set.Modifier[])modifierArray).requestID;
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
            this.isEnabled = true;
        }

        public synchronized void setEnabled(boolean bl) {
            if (!this.deleted && bl != this.isEnabled) {
                if (this.isEnabled) {
                    this.clear();
                } else {
                    this.set();
                }
            }
        }

        public void setSuspendPolicy(int n) {
            this.suspendPolicy = EventRequestManagerImpl.JDItoJDWPSuspendPolicy(n);
        }

        public int suspendPolicy() {
            return EventRequestManagerImpl.JDWPtoJDISuspendPolicy(this.suspendPolicy);
        }
    }

    abstract class ThreadVisibleEventRequestImpl
    extends EventRequestImpl {
        ThreadVisibleEventRequestImpl() {
        }

        public synchronized void addThreadFilter(ThreadReference threadReference) {
            this.validateMirror(threadReference);
            if (this.isEnabled()) {
                throw new InvalidRequestStateException();
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.ThreadOnly.create((ThreadReferenceImpl)threadReference));
        }
    }

    abstract class ClassVisibleEventRequestImpl
    extends ThreadVisibleEventRequestImpl {
        ClassVisibleEventRequestImpl() {
        }

        public synchronized void addClassExclusionFilter(String string) {
            if (this.isEnabled()) {
                throw new InvalidRequestStateException();
            }
            if (string == null) {
                throw new NullPointerException();
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.ClassExclude.create(string));
        }

        public synchronized void addClassFilter(ReferenceType referenceType) {
            this.validateMirror(referenceType);
            if (this.isEnabled()) {
                throw new InvalidRequestStateException();
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.ClassOnly.create((ReferenceTypeImpl)referenceType));
        }

        public synchronized void addClassFilter(String string) {
            if (this.isEnabled()) {
                throw new InvalidRequestStateException();
            }
            if (string == null) {
                throw new NullPointerException();
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.ClassMatch.create(string));
        }
    }

    class BreakpointRequestImpl
    extends ClassVisibleEventRequestImpl
    implements BreakpointRequest {
        private final Location location;

        BreakpointRequestImpl(Location location) {
            this.location = location;
            this.filters.add(0, JDWP.EventRequest.Set.Modifier.LocationOnly.create(location));
        }

        int eventCmd() {
            return 2;
        }

        public Location location() {
            return this.location;
        }

        public String toString() {
            return "breakpoint request " + this.location();
        }
    }

    class ClassPrepareRequestImpl
    extends ClassVisibleEventRequestImpl
    implements ClassPrepareRequest {
        ClassPrepareRequestImpl() {
        }

        int eventCmd() {
            return 8;
        }
    }

    class ClassUnloadRequestImpl
    extends ClassVisibleEventRequestImpl
    implements ClassUnloadRequest {
        ClassUnloadRequestImpl() {
        }

        int eventCmd() {
            return 9;
        }
    }

    class ExceptionRequestImpl
    extends ClassVisibleEventRequestImpl
    implements ExceptionRequest {
        ReferenceType exception = null;
        boolean caught = true;
        boolean uncaught = true;

        ExceptionRequestImpl(ReferenceType referenceType, boolean bl, boolean bl2) {
            this.exception = referenceType;
            this.caught = bl;
            this.uncaught = bl2;
            if (this.caught || this.uncaught) {
                ReferenceTypeImpl referenceTypeImpl = this.exception == null ? new ClassTypeImpl(this.vm, 0L) : (ReferenceTypeImpl)this.exception;
                this.filters.add(JDWP.EventRequest.Set.Modifier.ExceptionOnly.create(referenceTypeImpl, this.caught, this.uncaught));
            }
        }

        int eventCmd() {
            return 4;
        }

        public ReferenceType exception() {
            return this.exception;
        }

        public boolean notifyCaught() {
            return this.caught;
        }

        public boolean notifyUncaught() {
            return this.uncaught;
        }
    }

    class MethodEntryRequestImpl
    extends ClassVisibleEventRequestImpl
    implements MethodEntryRequest {
        MethodEntryRequestImpl() {
        }

        int eventCmd() {
            return 40;
        }
    }

    class MethodExitRequestImpl
    extends ClassVisibleEventRequestImpl
    implements MethodExitRequest {
        MethodExitRequestImpl() {
        }

        int eventCmd() {
            return 41;
        }
    }

    class StepRequestImpl
    extends ClassVisibleEventRequestImpl
    implements StepRequest {
        ThreadReferenceImpl thread;
        int size;
        int depth;

        StepRequestImpl(ThreadReference threadReference, int n, int n2) {
            int n3;
            int n4;
            this.thread = (ThreadReferenceImpl)threadReference;
            this.size = n;
            this.depth = n2;
            switch (n) {
                case -1: {
                    n4 = 0;
                    break;
                }
                case -2: {
                    n4 = 1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid step size");
                }
            }
            switch (n2) {
                case 1: {
                    n3 = 0;
                    break;
                }
                case 2: {
                    n3 = 1;
                    break;
                }
                case 3: {
                    n3 = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid step depth");
                }
            }
            List list = EventRequestManagerImpl.this.stepRequests();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                StepRequest stepRequest = (StepRequest)iterator.next();
                if (stepRequest == this || !stepRequest.isEnabled() || !stepRequest.thread().equals(threadReference)) continue;
                throw new DuplicateRequestException("Only one step request allowed per thread");
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.Step.create(this.thread, n4, n3));
        }

        public int depth() {
            return this.depth;
        }

        int eventCmd() {
            return 1;
        }

        public int size() {
            return this.depth;
        }

        public ThreadReference thread() {
            return this.thread;
        }
    }

    class ThreadDeathRequestImpl
    extends ThreadVisibleEventRequestImpl
    implements ThreadDeathRequest {
        ThreadDeathRequestImpl() {
        }

        int eventCmd() {
            return 7;
        }
    }

    class ThreadStartRequestImpl
    extends ThreadVisibleEventRequestImpl
    implements ThreadStartRequest {
        ThreadStartRequestImpl() {
        }

        int eventCmd() {
            return 6;
        }
    }

    abstract class WatchpointRequestImpl
    extends ClassVisibleEventRequestImpl
    implements WatchpointRequest {
        final com.sun.jdi.Field field;

        WatchpointRequestImpl(com.sun.jdi.Field field) {
            this.field = field;
            this.filters.add(0, JDWP.EventRequest.Set.Modifier.FieldOnly.create((ReferenceTypeImpl)field.declaringType(), ((FieldImpl)field).ref()));
        }

        public com.sun.jdi.Field field() {
            return this.field;
        }
    }

    class AccessWatchpointRequestImpl
    extends WatchpointRequestImpl
    implements AccessWatchpointRequest {
        AccessWatchpointRequestImpl(com.sun.jdi.Field field) {
            super(field);
        }

        int eventCmd() {
            return 20;
        }

        public String toString() {
            return "access watchpoint request " + this.field;
        }
    }

    class ModificationWatchpointRequestImpl
    extends WatchpointRequestImpl
    implements ModificationWatchpointRequest {
        ModificationWatchpointRequestImpl(com.sun.jdi.Field field) {
            super(field);
        }

        int eventCmd() {
            return 21;
        }

        public String toString() {
            return "modification watchpoint request " + this.field;
        }
    }
}

