/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.PrimitiveValueImpl;

public class IntegerValueImpl
extends PrimitiveValueImpl
implements IntegerValue {
    private int value;

    IntegerValueImpl(VirtualMachine virtualMachine, int n) {
        super(virtualMachine);
        this.value = n;
    }

    public boolean booleanValue() {
        return this.value != 0;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public char charValue() {
        return (char)this.value;
    }

    byte checkedByteValue() throws InvalidTypeException {
        if (this.value > 127 || this.value < -128) {
            throw new InvalidTypeException("Can't convert " + this.value + " to byte");
        }
        return super.checkedByteValue();
    }

    char checkedCharValue() throws InvalidTypeException {
        if (this.value > 65535 || this.value < 0) {
            throw new InvalidTypeException("Can't convert " + this.value + " to char");
        }
        return super.checkedCharValue();
    }

    short checkedShortValue() throws InvalidTypeException {
        if (this.value > Short.MAX_VALUE || this.value < Short.MIN_VALUE) {
            throw new InvalidTypeException("Can't convert " + this.value + " to short");
        }
        return super.checkedShortValue();
    }

    public int compareTo(Object object) {
        int n = ((IntegerValue)object).value();
        return this.value() - n;
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof IntegerValue) {
            return this.value == ((IntegerValue)object).value() && super.equals(object);
        }
        return false;
    }

    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return this.intValue();
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public Type type() {
        return this.vm.theIntegerType();
    }

    byte typeValueKey() {
        return 73;
    }

    public int value() {
        return this.value;
    }
}

