/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.Location;
import com.sun.tools.jdi.ArrayReferenceImpl;
import com.sun.tools.jdi.ArrayTypeImpl;
import com.sun.tools.jdi.ClassLoaderReferenceImpl;
import com.sun.tools.jdi.ClassObjectReferenceImpl;
import com.sun.tools.jdi.ClassTypeImpl;
import com.sun.tools.jdi.InterfaceTypeImpl;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.PacketStream;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.StringReferenceImpl;
import com.sun.tools.jdi.ThreadGroupReferenceImpl;
import com.sun.tools.jdi.ThreadReferenceImpl;
import com.sun.tools.jdi.ValueImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.List;

class JDWP {
    JDWP() {
    }

    static class VirtualMachine {
        static final int COMMAND_SET = 1;

        private VirtualMachine() {
        }

        static class Version {
            static final int COMMAND = 1;
            final String description;
            final int jdwpMajor;
            final int jdwpMinor;
            final String vmVersion;
            final String vmName;

            private Version(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Version" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.description = packetStream.readString();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "description(String): " + this.description);
                }
                this.jdwpMajor = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "jdwpMajor(int): " + this.jdwpMajor);
                }
                this.jdwpMinor = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "jdwpMinor(int): " + this.jdwpMinor);
                }
                this.vmVersion = packetStream.readString();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "vmVersion(String): " + this.vmVersion);
                }
                this.vmName = packetStream.readString();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "vmName(String): " + this.vmName);
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Version" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static Version process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = Version.enqueueCommand(virtualMachineImpl);
                return Version.waitForReply(virtualMachineImpl, packetStream);
            }

            static Version waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Version(virtualMachineImpl, packetStream);
            }
        }

        static class ClassesBySignature {
            static final int COMMAND = 2;
            final ClassInfo[] classes;

            private ClassesBySignature(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.ClassesBySignature" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "classes(ClassInfo[]): ");
                }
                int n = packetStream.readInt();
                this.classes = new ClassInfo[n];
                int n2 = 0;
                while (n2 < n) {
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "classes[i](ClassInfo): ");
                    }
                    class Com_sun_tools_jdi_JDWP$1 {
                        /* synthetic */ Com_sun_tools_jdi_JDWP$1() {
                        }
                    }
                    this.classes[n2] = new ClassInfo(null, virtualMachineImpl, packetStream);
                    ++n2;
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, String string) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 2);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.ClassesBySignature" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 signature(String): " + string);
                }
                packetStream.writeString(string);
                packetStream.send();
                return packetStream;
            }

            static ClassesBySignature process(VirtualMachineImpl virtualMachineImpl, String string) throws JDWPException {
                PacketStream packetStream = ClassesBySignature.enqueueCommand(virtualMachineImpl, string);
                return ClassesBySignature.waitForReply(virtualMachineImpl, packetStream);
            }

            static ClassesBySignature waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new ClassesBySignature(virtualMachineImpl, packetStream);
            }

            static class ClassInfo {
                final byte refTypeTag;
                final long typeID;
                final int status;

                /* synthetic */ ClassInfo(1 var1_1, VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this(virtualMachineImpl, packetStream);
                }

                private ClassInfo(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this.refTypeTag = packetStream.readByte();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "refTypeTag(byte): " + this.refTypeTag);
                    }
                    this.typeID = packetStream.readClassRef();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "typeID(long): ref=" + this.typeID);
                    }
                    this.status = packetStream.readInt();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "status(int): " + this.status);
                    }
                }
            }
        }

        static class AllClasses {
            static final int COMMAND = 3;
            final ClassInfo[] classes;

            private AllClasses(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.AllClasses" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "classes(ClassInfo[]): ");
                }
                int n = packetStream.readInt();
                this.classes = new ClassInfo[n];
                int n2 = 0;
                while (n2 < n) {
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "classes[i](ClassInfo): ");
                    }
                    this.classes[n2] = new ClassInfo(null, virtualMachineImpl, packetStream);
                    ++n2;
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 3);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.AllClasses" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static AllClasses process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = AllClasses.enqueueCommand(virtualMachineImpl);
                return AllClasses.waitForReply(virtualMachineImpl, packetStream);
            }

            static AllClasses waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new AllClasses(virtualMachineImpl, packetStream);
            }

            static class ClassInfo {
                final byte refTypeTag;
                final long typeID;
                final String signature;
                final int status;

                /* synthetic */ ClassInfo(1 var1_1, VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this(virtualMachineImpl, packetStream);
                }

                private ClassInfo(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this.refTypeTag = packetStream.readByte();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "refTypeTag(byte): " + this.refTypeTag);
                    }
                    this.typeID = packetStream.readClassRef();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "typeID(long): ref=" + this.typeID);
                    }
                    this.signature = packetStream.readString();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "signature(String): " + this.signature);
                    }
                    this.status = packetStream.readInt();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "status(int): " + this.status);
                    }
                }
            }
        }

        static class AllThreads {
            static final int COMMAND = 4;
            final ThreadReferenceImpl[] threads;

            private AllThreads(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.AllThreads" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "threads(ThreadReferenceImpl[]): ");
                }
                int n = packetStream.readInt();
                this.threads = new ThreadReferenceImpl[n];
                int n2 = 0;
                while (n2 < n) {
                    this.threads[n2] = packetStream.readThreadReference();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "threads[i](ThreadReferenceImpl): " + (this.threads[n2] == null ? "NULL" : "ref=" + this.threads[n2].ref()));
                    }
                    ++n2;
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 4);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.AllThreads" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static AllThreads process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = AllThreads.enqueueCommand(virtualMachineImpl);
                return AllThreads.waitForReply(virtualMachineImpl, packetStream);
            }

            static AllThreads waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new AllThreads(virtualMachineImpl, packetStream);
            }
        }

        static class TopLevelThreadGroups {
            static final int COMMAND = 5;
            final ThreadGroupReferenceImpl[] groups;

            private TopLevelThreadGroups(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.TopLevelThreadGroups" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "groups(ThreadGroupReferenceImpl[]): ");
                }
                int n = packetStream.readInt();
                this.groups = new ThreadGroupReferenceImpl[n];
                int n2 = 0;
                while (n2 < n) {
                    this.groups[n2] = packetStream.readThreadGroupReference();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "groups[i](ThreadGroupReferenceImpl): " + (this.groups[n2] == null ? "NULL" : "ref=" + this.groups[n2].ref()));
                    }
                    ++n2;
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 5);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.TopLevelThreadGroups" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static TopLevelThreadGroups process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = TopLevelThreadGroups.enqueueCommand(virtualMachineImpl);
                return TopLevelThreadGroups.waitForReply(virtualMachineImpl, packetStream);
            }

            static TopLevelThreadGroups waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new TopLevelThreadGroups(virtualMachineImpl, packetStream);
            }
        }

        static class Dispose {
            static final int COMMAND = 6;

            private Dispose(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Dispose" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 6);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Dispose" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static Dispose process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = Dispose.enqueueCommand(virtualMachineImpl);
                return Dispose.waitForReply(virtualMachineImpl, packetStream);
            }

            static Dispose waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Dispose(virtualMachineImpl, packetStream);
            }
        }

        static class IDSizes {
            static final int COMMAND = 7;
            final int fieldIDSize;
            final int methodIDSize;
            final int objectIDSize;
            final int referenceTypeIDSize;
            final int frameIDSize;

            private IDSizes(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.IDSizes" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.fieldIDSize = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "fieldIDSize(int): " + this.fieldIDSize);
                }
                this.methodIDSize = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "methodIDSize(int): " + this.methodIDSize);
                }
                this.objectIDSize = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "objectIDSize(int): " + this.objectIDSize);
                }
                this.referenceTypeIDSize = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "referenceTypeIDSize(int): " + this.referenceTypeIDSize);
                }
                this.frameIDSize = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "frameIDSize(int): " + this.frameIDSize);
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 7);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.IDSizes" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static IDSizes process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = IDSizes.enqueueCommand(virtualMachineImpl);
                return IDSizes.waitForReply(virtualMachineImpl, packetStream);
            }

            static IDSizes waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new IDSizes(virtualMachineImpl, packetStream);
            }
        }

        static class Suspend {
            static final int COMMAND = 8;

            private Suspend(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Suspend" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 8);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Suspend" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static Suspend process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = Suspend.enqueueCommand(virtualMachineImpl);
                return Suspend.waitForReply(virtualMachineImpl, packetStream);
            }

            static Suspend waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Suspend(virtualMachineImpl, packetStream);
            }
        }

        static class Resume {
            static final int COMMAND = 9;

            private Resume(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Resume" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 9);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Resume" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static Resume process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = Resume.enqueueCommand(virtualMachineImpl);
                return Resume.waitForReply(virtualMachineImpl, packetStream);
            }

            static Resume waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Resume(virtualMachineImpl, packetStream);
            }
        }

        static class Exit {
            static final int COMMAND = 10;

            private Exit(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Exit" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, int n) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 10);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Exit" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 exitCode(int): " + n);
                }
                packetStream.writeInt(n);
                packetStream.send();
                return packetStream;
            }

            static Exit process(VirtualMachineImpl virtualMachineImpl, int n) throws JDWPException {
                PacketStream packetStream = Exit.enqueueCommand(virtualMachineImpl, n);
                return Exit.waitForReply(virtualMachineImpl, packetStream);
            }

            static Exit waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Exit(virtualMachineImpl, packetStream);
            }
        }

        static class CreateString {
            static final int COMMAND = 11;
            final StringReferenceImpl stringObject;

            private CreateString(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.CreateString" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.stringObject = packetStream.readStringReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "stringObject(StringReferenceImpl): " + (this.stringObject == null ? "NULL" : "ref=" + this.stringObject.ref()));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, String string) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 11);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.CreateString" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 utf(String): " + string);
                }
                packetStream.writeString(string);
                packetStream.send();
                return packetStream;
            }

            static CreateString process(VirtualMachineImpl virtualMachineImpl, String string) throws JDWPException {
                PacketStream packetStream = CreateString.enqueueCommand(virtualMachineImpl, string);
                return CreateString.waitForReply(virtualMachineImpl, packetStream);
            }

            static CreateString waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new CreateString(virtualMachineImpl, packetStream);
            }
        }

        static class Capabilities {
            static final int COMMAND = 12;
            final boolean canWatchFieldModification;
            final boolean canWatchFieldAccess;
            final boolean canGetBytecodes;
            final boolean canGetSyntheticAttribute;
            final boolean canGetOwnedMonitorInfo;
            final boolean canGetCurrentContendedMonitor;
            final boolean canGetMonitorInfo;

            private Capabilities(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Capabilities" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.canWatchFieldModification = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canWatchFieldModification(boolean): " + this.canWatchFieldModification);
                }
                this.canWatchFieldAccess = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canWatchFieldAccess(boolean): " + this.canWatchFieldAccess);
                }
                this.canGetBytecodes = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canGetBytecodes(boolean): " + this.canGetBytecodes);
                }
                this.canGetSyntheticAttribute = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canGetSyntheticAttribute(boolean): " + this.canGetSyntheticAttribute);
                }
                this.canGetOwnedMonitorInfo = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canGetOwnedMonitorInfo(boolean): " + this.canGetOwnedMonitorInfo);
                }
                this.canGetCurrentContendedMonitor = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canGetCurrentContendedMonitor(boolean): " + this.canGetCurrentContendedMonitor);
                }
                this.canGetMonitorInfo = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canGetMonitorInfo(boolean): " + this.canGetMonitorInfo);
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 12);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Capabilities" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static Capabilities process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = Capabilities.enqueueCommand(virtualMachineImpl);
                return Capabilities.waitForReply(virtualMachineImpl, packetStream);
            }

            static Capabilities waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Capabilities(virtualMachineImpl, packetStream);
            }
        }

        static class ClassPaths {
            static final int COMMAND = 13;
            final String baseDir;
            final String[] classpaths;
            final String[] bootclasspaths;

            private ClassPaths(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.ClassPaths" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.baseDir = packetStream.readString();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "baseDir(String): " + this.baseDir);
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "classpaths(String[]): ");
                }
                int n = packetStream.readInt();
                this.classpaths = new String[n];
                int n2 = 0;
                while (n2 < n) {
                    this.classpaths[n2] = packetStream.readString();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "classpaths[i](String): " + this.classpaths[n2]);
                    }
                    ++n2;
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "bootclasspaths(String[]): ");
                }
                int n3 = packetStream.readInt();
                this.bootclasspaths = new String[n3];
                int n4 = 0;
                while (n4 < n3) {
                    this.bootclasspaths[n4] = packetStream.readString();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "bootclasspaths[i](String): " + this.bootclasspaths[n4]);
                    }
                    ++n4;
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 13);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.ClassPaths" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static ClassPaths process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = ClassPaths.enqueueCommand(virtualMachineImpl);
                return ClassPaths.waitForReply(virtualMachineImpl, packetStream);
            }

            static ClassPaths waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new ClassPaths(virtualMachineImpl, packetStream);
            }
        }

        static class DisposeObjects {
            static final int COMMAND = 14;

            private DisposeObjects(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.DisposeObjects" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, Request[] requestArray) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 14);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.DisposeObjects" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 requests(Request[]): ");
                }
                packetStream.writeInt(requestArray.length);
                int n = 0;
                while (n < requestArray.length) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     requests[i](Request): ");
                    }
                    requestArray[n].write(packetStream);
                    ++n;
                }
                packetStream.send();
                return packetStream;
            }

            static DisposeObjects process(VirtualMachineImpl virtualMachineImpl, Request[] requestArray) throws JDWPException {
                PacketStream packetStream = DisposeObjects.enqueueCommand(virtualMachineImpl, requestArray);
                return DisposeObjects.waitForReply(virtualMachineImpl, packetStream);
            }

            static DisposeObjects waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new DisposeObjects(virtualMachineImpl, packetStream);
            }

            static class Request {
                final ObjectReferenceImpl object;
                final int refCnt;

                Request(ObjectReferenceImpl objectReferenceImpl, int n) {
                    this.object = objectReferenceImpl;
                    this.refCnt = n;
                }

                private void write(PacketStream packetStream) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     object(ObjectReferenceImpl): " + (this.object == null ? "NULL" : "ref=" + this.object.ref()));
                    }
                    packetStream.writeObjectRef(this.object.ref());
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     refCnt(int): " + this.refCnt);
                    }
                    packetStream.writeInt(this.refCnt);
                }
            }
        }

        static class HoldEvents {
            static final int COMMAND = 15;

            private HoldEvents(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.HoldEvents" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 15);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.HoldEvents" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static HoldEvents process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = HoldEvents.enqueueCommand(virtualMachineImpl);
                return HoldEvents.waitForReply(virtualMachineImpl, packetStream);
            }

            static HoldEvents waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new HoldEvents(virtualMachineImpl, packetStream);
            }
        }

        static class ReleaseEvents {
            static final int COMMAND = 16;

            private ReleaseEvents(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.ReleaseEvents" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 16);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.ReleaseEvents" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static ReleaseEvents process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = ReleaseEvents.enqueueCommand(virtualMachineImpl);
                return ReleaseEvents.waitForReply(virtualMachineImpl, packetStream);
            }

            static ReleaseEvents waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new ReleaseEvents(virtualMachineImpl, packetStream);
            }
        }
    }

    static class ReferenceType {
        static final int COMMAND_SET = 2;

        private ReferenceType() {
        }

        static class Signature {
            static final int COMMAND = 1;
            final String signature;

            private Signature(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Signature" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.signature = packetStream.readString();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "signature(String): " + this.signature);
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Signature" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Signature process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) throws JDWPException {
                PacketStream packetStream = Signature.enqueueCommand(virtualMachineImpl, referenceTypeImpl);
                return Signature.waitForReply(virtualMachineImpl, packetStream);
            }

            static Signature waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Signature(virtualMachineImpl, packetStream);
            }
        }

        static class ClassLoader {
            static final int COMMAND = 2;
            final ClassLoaderReferenceImpl classLoader;

            private ClassLoader(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.ClassLoader" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.classLoader = packetStream.readClassLoaderReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "classLoader(ClassLoaderReferenceImpl): " + (this.classLoader == null ? "NULL" : "ref=" + this.classLoader.ref()));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 2);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.ClassLoader" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static ClassLoader process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) throws JDWPException {
                PacketStream packetStream = ClassLoader.enqueueCommand(virtualMachineImpl, referenceTypeImpl);
                return ClassLoader.waitForReply(virtualMachineImpl, packetStream);
            }

            static ClassLoader waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new ClassLoader(virtualMachineImpl, packetStream);
            }
        }

        static class Modifiers {
            static final int COMMAND = 3;
            final int modBits;

            private Modifiers(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Modifiers" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.modBits = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "modBits(int): " + this.modBits);
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 3);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Modifiers" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Modifiers process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) throws JDWPException {
                PacketStream packetStream = Modifiers.enqueueCommand(virtualMachineImpl, referenceTypeImpl);
                return Modifiers.waitForReply(virtualMachineImpl, packetStream);
            }

            static Modifiers waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Modifiers(virtualMachineImpl, packetStream);
            }
        }

        static class Fields {
            static final int COMMAND = 4;
            final FieldInfo[] declared;

            private Fields(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Fields" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "declared(FieldInfo[]): ");
                }
                int n = packetStream.readInt();
                this.declared = new FieldInfo[n];
                int n2 = 0;
                while (n2 < n) {
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "declared[i](FieldInfo): ");
                    }
                    this.declared[n2] = new FieldInfo(null, virtualMachineImpl, packetStream);
                    ++n2;
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 4);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Fields" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Fields process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) throws JDWPException {
                PacketStream packetStream = Fields.enqueueCommand(virtualMachineImpl, referenceTypeImpl);
                return Fields.waitForReply(virtualMachineImpl, packetStream);
            }

            static Fields waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Fields(virtualMachineImpl, packetStream);
            }

            static class FieldInfo {
                final long fieldID;
                final String name;
                final String signature;
                final int modBits;

                /* synthetic */ FieldInfo(1 var1_1, VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this(virtualMachineImpl, packetStream);
                }

                private FieldInfo(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this.fieldID = packetStream.readFieldRef();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "fieldID(long): " + this.fieldID);
                    }
                    this.name = packetStream.readString();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "name(String): " + this.name);
                    }
                    this.signature = packetStream.readString();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "signature(String): " + this.signature);
                    }
                    this.modBits = packetStream.readInt();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "modBits(int): " + this.modBits);
                    }
                }
            }
        }

        static class Methods {
            static final int COMMAND = 5;
            final MethodInfo[] declared;

            private Methods(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Methods" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "declared(MethodInfo[]): ");
                }
                int n = packetStream.readInt();
                this.declared = new MethodInfo[n];
                int n2 = 0;
                while (n2 < n) {
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "declared[i](MethodInfo): ");
                    }
                    this.declared[n2] = new MethodInfo(null, virtualMachineImpl, packetStream);
                    ++n2;
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 5);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Methods" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Methods process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) throws JDWPException {
                PacketStream packetStream = Methods.enqueueCommand(virtualMachineImpl, referenceTypeImpl);
                return Methods.waitForReply(virtualMachineImpl, packetStream);
            }

            static Methods waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Methods(virtualMachineImpl, packetStream);
            }

            static class MethodInfo {
                final long methodID;
                final String name;
                final String signature;
                final int modBits;

                /* synthetic */ MethodInfo(1 var1_1, VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this(virtualMachineImpl, packetStream);
                }

                private MethodInfo(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this.methodID = packetStream.readMethodRef();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "methodID(long): " + this.methodID);
                    }
                    this.name = packetStream.readString();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "name(String): " + this.name);
                    }
                    this.signature = packetStream.readString();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "signature(String): " + this.signature);
                    }
                    this.modBits = packetStream.readInt();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "modBits(int): " + this.modBits);
                    }
                }
            }
        }

        static class GetValues {
            static final int COMMAND = 6;
            final ValueImpl[] values;

            private GetValues(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.GetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "values(ValueImpl[]): ");
                }
                int n = packetStream.readInt();
                this.values = new ValueImpl[n];
                int n2 = 0;
                while (n2 < n) {
                    this.values[n2] = packetStream.readValue();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "values[i](ValueImpl): " + this.values[n2]);
                    }
                    ++n2;
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl, Field[] fieldArray) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 6);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.GetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 fields(Field[]): ");
                }
                packetStream.writeInt(fieldArray.length);
                int n = 0;
                while (n < fieldArray.length) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     fields[i](Field): ");
                    }
                    fieldArray[n].write(packetStream);
                    ++n;
                }
                packetStream.send();
                return packetStream;
            }

            static GetValues process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl, Field[] fieldArray) throws JDWPException {
                PacketStream packetStream = GetValues.enqueueCommand(virtualMachineImpl, referenceTypeImpl, fieldArray);
                return GetValues.waitForReply(virtualMachineImpl, packetStream);
            }

            static GetValues waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new GetValues(virtualMachineImpl, packetStream);
            }

            static class Field {
                final long fieldID;

                Field(long l) {
                    this.fieldID = l;
                }

                private void write(PacketStream packetStream) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     fieldID(long): " + this.fieldID);
                    }
                    packetStream.writeFieldRef(this.fieldID);
                }
            }
        }

        static class SourceFile {
            static final int COMMAND = 7;
            final String sourceFile;

            private SourceFile(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.SourceFile" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.sourceFile = packetStream.readString();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "sourceFile(String): " + this.sourceFile);
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 7);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.SourceFile" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static SourceFile process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) throws JDWPException {
                PacketStream packetStream = SourceFile.enqueueCommand(virtualMachineImpl, referenceTypeImpl);
                return SourceFile.waitForReply(virtualMachineImpl, packetStream);
            }

            static SourceFile waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new SourceFile(virtualMachineImpl, packetStream);
            }
        }

        static class NestedTypes {
            static final int COMMAND = 8;
            final TypeInfo[] classes;

            private NestedTypes(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.NestedTypes" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "classes(TypeInfo[]): ");
                }
                int n = packetStream.readInt();
                this.classes = new TypeInfo[n];
                int n2 = 0;
                while (n2 < n) {
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "classes[i](TypeInfo): ");
                    }
                    this.classes[n2] = new TypeInfo(null, virtualMachineImpl, packetStream);
                    ++n2;
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 8);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.NestedTypes" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static NestedTypes process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) throws JDWPException {
                PacketStream packetStream = NestedTypes.enqueueCommand(virtualMachineImpl, referenceTypeImpl);
                return NestedTypes.waitForReply(virtualMachineImpl, packetStream);
            }

            static NestedTypes waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new NestedTypes(virtualMachineImpl, packetStream);
            }

            static class TypeInfo {
                final byte refTypeTag;
                final long typeID;

                /* synthetic */ TypeInfo(1 var1_1, VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this(virtualMachineImpl, packetStream);
                }

                private TypeInfo(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this.refTypeTag = packetStream.readByte();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "refTypeTag(byte): " + this.refTypeTag);
                    }
                    this.typeID = packetStream.readClassRef();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "typeID(long): ref=" + this.typeID);
                    }
                }
            }
        }

        static class Status {
            static final int COMMAND = 9;
            final int status;

            private Status(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Status" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.status = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "status(int): " + this.status);
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 9);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Status" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Status process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) throws JDWPException {
                PacketStream packetStream = Status.enqueueCommand(virtualMachineImpl, referenceTypeImpl);
                return Status.waitForReply(virtualMachineImpl, packetStream);
            }

            static Status waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Status(virtualMachineImpl, packetStream);
            }
        }

        static class Interfaces {
            static final int COMMAND = 10;
            final InterfaceTypeImpl[] interfaces;

            private Interfaces(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Interfaces" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "interfaces(InterfaceTypeImpl[]): ");
                }
                int n = packetStream.readInt();
                this.interfaces = new InterfaceTypeImpl[n];
                int n2 = 0;
                while (n2 < n) {
                    this.interfaces[n2] = virtualMachineImpl.interfaceType(packetStream.readClassRef());
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "interfaces[i](InterfaceTypeImpl): " + (this.interfaces[n2] == null ? "NULL" : "ref=" + this.interfaces[n2].ref()));
                    }
                    ++n2;
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 10);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Interfaces" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Interfaces process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) throws JDWPException {
                PacketStream packetStream = Interfaces.enqueueCommand(virtualMachineImpl, referenceTypeImpl);
                return Interfaces.waitForReply(virtualMachineImpl, packetStream);
            }

            static Interfaces waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Interfaces(virtualMachineImpl, packetStream);
            }
        }

        static class ClassObject {
            static final int COMMAND = 11;
            final ClassObjectReferenceImpl classObject;

            private ClassObject(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.ClassObject" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.classObject = packetStream.readClassObjectReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "classObject(ClassObjectReferenceImpl): " + (this.classObject == null ? "NULL" : "ref=" + this.classObject.ref()));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 11);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.ClassObject" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static ClassObject process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) throws JDWPException {
                PacketStream packetStream = ClassObject.enqueueCommand(virtualMachineImpl, referenceTypeImpl);
                return ClassObject.waitForReply(virtualMachineImpl, packetStream);
            }

            static ClassObject waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new ClassObject(virtualMachineImpl, packetStream);
            }
        }
    }

    static class ClassType {
        static final int COMMAND_SET = 3;

        private ClassType() {
        }

        static class Superclass {
            static final int COMMAND = 1;
            final ClassTypeImpl superclass;

            private Superclass(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ClassType.Superclass" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.superclass = virtualMachineImpl.classType(packetStream.readClassRef());
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "superclass(ClassTypeImpl): " + (this.superclass == null ? "NULL" : "ref=" + this.superclass.ref()));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ClassTypeImpl classTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 3, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ClassType.Superclass" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 clazz(ClassTypeImpl): " + (classTypeImpl == null ? "NULL" : "ref=" + classTypeImpl.ref()));
                }
                packetStream.writeClassRef(classTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Superclass process(VirtualMachineImpl virtualMachineImpl, ClassTypeImpl classTypeImpl) throws JDWPException {
                PacketStream packetStream = Superclass.enqueueCommand(virtualMachineImpl, classTypeImpl);
                return Superclass.waitForReply(virtualMachineImpl, packetStream);
            }

            static Superclass waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Superclass(virtualMachineImpl, packetStream);
            }
        }

        static class SetValues {
            static final int COMMAND = 2;

            private SetValues(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ClassType.SetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ClassTypeImpl classTypeImpl, FieldValue[] fieldValueArray) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 3, 2);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ClassType.SetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 clazz(ClassTypeImpl): " + (classTypeImpl == null ? "NULL" : "ref=" + classTypeImpl.ref()));
                }
                packetStream.writeClassRef(classTypeImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 values(FieldValue[]): ");
                }
                packetStream.writeInt(fieldValueArray.length);
                int n = 0;
                while (n < fieldValueArray.length) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     values[i](FieldValue): ");
                    }
                    fieldValueArray[n].write(packetStream);
                    ++n;
                }
                packetStream.send();
                return packetStream;
            }

            static SetValues process(VirtualMachineImpl virtualMachineImpl, ClassTypeImpl classTypeImpl, FieldValue[] fieldValueArray) throws JDWPException {
                PacketStream packetStream = SetValues.enqueueCommand(virtualMachineImpl, classTypeImpl, fieldValueArray);
                return SetValues.waitForReply(virtualMachineImpl, packetStream);
            }

            static SetValues waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new SetValues(virtualMachineImpl, packetStream);
            }

            static class FieldValue {
                final long fieldID;
                final ValueImpl value;

                FieldValue(long l, ValueImpl valueImpl) {
                    this.fieldID = l;
                    this.value = valueImpl;
                }

                private void write(PacketStream packetStream) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     fieldID(long): " + this.fieldID);
                    }
                    packetStream.writeFieldRef(this.fieldID);
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     value(ValueImpl): " + this.value);
                    }
                    packetStream.writeUntaggedValue(this.value);
                }
            }
        }

        static class InvokeMethod {
            static final int COMMAND = 3;
            final ValueImpl returnValue;
            final ObjectReferenceImpl exception;

            private InvokeMethod(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ClassType.InvokeMethod" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.returnValue = packetStream.readValue();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "returnValue(ValueImpl): " + this.returnValue);
                }
                this.exception = packetStream.readTaggedObjectReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "exception(ObjectReferenceImpl): " + (this.exception == null ? "NULL" : "ref=" + this.exception.ref()));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ClassTypeImpl classTypeImpl, ThreadReferenceImpl threadReferenceImpl, long l, ValueImpl[] valueImplArray, int n) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 3, 3);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ClassType.InvokeMethod" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 clazz(ClassTypeImpl): " + (classTypeImpl == null ? "NULL" : "ref=" + classTypeImpl.ref()));
                }
                packetStream.writeClassRef(classTypeImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 method(long): " + l);
                }
                packetStream.writeMethodRef(l);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 arguments(ValueImpl[]): ");
                }
                packetStream.writeInt(valueImplArray.length);
                int n2 = 0;
                while (n2 < valueImplArray.length) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     arguments[i](ValueImpl): " + valueImplArray[n2]);
                    }
                    packetStream.writeValue(valueImplArray[n2]);
                    ++n2;
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 options(int): " + n);
                }
                packetStream.writeInt(n);
                packetStream.send();
                return packetStream;
            }

            static InvokeMethod process(VirtualMachineImpl virtualMachineImpl, ClassTypeImpl classTypeImpl, ThreadReferenceImpl threadReferenceImpl, long l, ValueImpl[] valueImplArray, int n) throws JDWPException {
                PacketStream packetStream = InvokeMethod.enqueueCommand(virtualMachineImpl, classTypeImpl, threadReferenceImpl, l, valueImplArray, n);
                return InvokeMethod.waitForReply(virtualMachineImpl, packetStream);
            }

            static InvokeMethod waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new InvokeMethod(virtualMachineImpl, packetStream);
            }
        }

        static class NewInstance {
            static final int COMMAND = 4;
            final ObjectReferenceImpl newObject;
            final ObjectReferenceImpl exception;

            private NewInstance(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ClassType.NewInstance" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.newObject = packetStream.readTaggedObjectReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "newObject(ObjectReferenceImpl): " + (this.newObject == null ? "NULL" : "ref=" + this.newObject.ref()));
                }
                this.exception = packetStream.readTaggedObjectReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "exception(ObjectReferenceImpl): " + (this.exception == null ? "NULL" : "ref=" + this.exception.ref()));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ClassTypeImpl classTypeImpl, ThreadReferenceImpl threadReferenceImpl, long l, ValueImpl[] valueImplArray, int n) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 3, 4);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ClassType.NewInstance" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 clazz(ClassTypeImpl): " + (classTypeImpl == null ? "NULL" : "ref=" + classTypeImpl.ref()));
                }
                packetStream.writeClassRef(classTypeImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 method(long): " + l);
                }
                packetStream.writeMethodRef(l);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 arguments(ValueImpl[]): ");
                }
                packetStream.writeInt(valueImplArray.length);
                int n2 = 0;
                while (n2 < valueImplArray.length) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     arguments[i](ValueImpl): " + valueImplArray[n2]);
                    }
                    packetStream.writeValue(valueImplArray[n2]);
                    ++n2;
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 options(int): " + n);
                }
                packetStream.writeInt(n);
                packetStream.send();
                return packetStream;
            }

            static NewInstance process(VirtualMachineImpl virtualMachineImpl, ClassTypeImpl classTypeImpl, ThreadReferenceImpl threadReferenceImpl, long l, ValueImpl[] valueImplArray, int n) throws JDWPException {
                PacketStream packetStream = NewInstance.enqueueCommand(virtualMachineImpl, classTypeImpl, threadReferenceImpl, l, valueImplArray, n);
                return NewInstance.waitForReply(virtualMachineImpl, packetStream);
            }

            static NewInstance waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new NewInstance(virtualMachineImpl, packetStream);
            }
        }
    }

    static class ArrayType {
        static final int COMMAND_SET = 4;

        private ArrayType() {
        }

        static class NewInstance {
            static final int COMMAND = 1;
            final ObjectReferenceImpl newArray;

            private NewInstance(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ArrayType.NewInstance" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.newArray = packetStream.readTaggedObjectReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "newArray(ObjectReferenceImpl): " + (this.newArray == null ? "NULL" : "ref=" + this.newArray.ref()));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ArrayTypeImpl arrayTypeImpl, int n) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 4, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ArrayType.NewInstance" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 arrType(ArrayTypeImpl): " + (arrayTypeImpl == null ? "NULL" : "ref=" + arrayTypeImpl.ref()));
                }
                packetStream.writeClassRef(arrayTypeImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 length(int): " + n);
                }
                packetStream.writeInt(n);
                packetStream.send();
                return packetStream;
            }

            static NewInstance process(VirtualMachineImpl virtualMachineImpl, ArrayTypeImpl arrayTypeImpl, int n) throws JDWPException {
                PacketStream packetStream = NewInstance.enqueueCommand(virtualMachineImpl, arrayTypeImpl, n);
                return NewInstance.waitForReply(virtualMachineImpl, packetStream);
            }

            static NewInstance waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new NewInstance(virtualMachineImpl, packetStream);
            }
        }
    }

    static class InterfaceType {
        static final int COMMAND_SET = 5;

        private InterfaceType() {
        }
    }

    static class Method {
        static final int COMMAND_SET = 6;

        private Method() {
        }

        static class LineTable {
            static final int COMMAND = 1;
            final long start;
            final long end;
            final LineInfo[] lines;

            private LineTable(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.Method.LineTable" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.start = packetStream.readLong();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "start(long): " + this.start);
                }
                this.end = packetStream.readLong();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "end(long): " + this.end);
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "lines(LineInfo[]): ");
                }
                int n = packetStream.readInt();
                this.lines = new LineInfo[n];
                int n2 = 0;
                while (n2 < n) {
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "lines[i](LineInfo): ");
                    }
                    this.lines[n2] = new LineInfo(null, virtualMachineImpl, packetStream);
                    ++n2;
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl, long l) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 6, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.Method.LineTable" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 classID(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 methodID(long): " + l);
                }
                packetStream.writeMethodRef(l);
                packetStream.send();
                return packetStream;
            }

            static LineTable process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl, long l) throws JDWPException {
                PacketStream packetStream = LineTable.enqueueCommand(virtualMachineImpl, referenceTypeImpl, l);
                return LineTable.waitForReply(virtualMachineImpl, packetStream);
            }

            static LineTable waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new LineTable(virtualMachineImpl, packetStream);
            }

            static class LineInfo {
                final long lineCodeIndex;
                final int lineNumber;

                /* synthetic */ LineInfo(1 var1_1, VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this(virtualMachineImpl, packetStream);
                }

                private LineInfo(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this.lineCodeIndex = packetStream.readLong();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "lineCodeIndex(long): " + this.lineCodeIndex);
                    }
                    this.lineNumber = packetStream.readInt();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "lineNumber(int): " + this.lineNumber);
                    }
                }
            }
        }

        static class VariableTable {
            static final int COMMAND = 2;
            final int argCnt;
            final SlotInfo[] slots;

            private VariableTable(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.Method.VariableTable" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.argCnt = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "argCnt(int): " + this.argCnt);
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "slots(SlotInfo[]): ");
                }
                int n = packetStream.readInt();
                this.slots = new SlotInfo[n];
                int n2 = 0;
                while (n2 < n) {
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "slots[i](SlotInfo): ");
                    }
                    this.slots[n2] = new SlotInfo(null, virtualMachineImpl, packetStream);
                    ++n2;
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl, long l) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 6, 2);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.Method.VariableTable" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 classID(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 methodID(long): " + l);
                }
                packetStream.writeMethodRef(l);
                packetStream.send();
                return packetStream;
            }

            static VariableTable process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl, long l) throws JDWPException {
                PacketStream packetStream = VariableTable.enqueueCommand(virtualMachineImpl, referenceTypeImpl, l);
                return VariableTable.waitForReply(virtualMachineImpl, packetStream);
            }

            static VariableTable waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new VariableTable(virtualMachineImpl, packetStream);
            }

            static class SlotInfo {
                final long codeIndex;
                final String name;
                final String signature;
                final int length;
                final int slot;

                /* synthetic */ SlotInfo(1 var1_1, VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this(virtualMachineImpl, packetStream);
                }

                private SlotInfo(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this.codeIndex = packetStream.readLong();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "codeIndex(long): " + this.codeIndex);
                    }
                    this.name = packetStream.readString();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "name(String): " + this.name);
                    }
                    this.signature = packetStream.readString();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "signature(String): " + this.signature);
                    }
                    this.length = packetStream.readInt();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "length(int): " + this.length);
                    }
                    this.slot = packetStream.readInt();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "slot(int): " + this.slot);
                    }
                }
            }
        }

        static class Bytecodes {
            static final int COMMAND = 3;
            final byte[] bytes;

            private Bytecodes(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.Method.Bytecodes" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "bytes(byte[]): ");
                }
                int n = packetStream.readInt();
                this.bytes = new byte[n];
                int n2 = 0;
                while (n2 < n) {
                    this.bytes[n2] = packetStream.readByte();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "bytes[i](byte): " + this.bytes[n2]);
                    }
                    ++n2;
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl, long l) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 6, 3);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.Method.Bytecodes" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 classID(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 methodID(long): " + l);
                }
                packetStream.writeMethodRef(l);
                packetStream.send();
                return packetStream;
            }

            static Bytecodes process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl, long l) throws JDWPException {
                PacketStream packetStream = Bytecodes.enqueueCommand(virtualMachineImpl, referenceTypeImpl, l);
                return Bytecodes.waitForReply(virtualMachineImpl, packetStream);
            }

            static Bytecodes waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Bytecodes(virtualMachineImpl, packetStream);
            }
        }
    }

    static class Field {
        static final int COMMAND_SET = 8;

        private Field() {
        }
    }

    static class ObjectReference {
        static final int COMMAND_SET = 9;

        private ObjectReference() {
        }

        static class ReferenceType {
            static final int COMMAND = 1;
            final byte refTypeTag;
            final long typeID;

            private ReferenceType(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.ReferenceType" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.refTypeTag = packetStream.readByte();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "refTypeTag(byte): " + this.refTypeTag);
                }
                this.typeID = packetStream.readClassRef();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "typeID(long): ref=" + this.typeID);
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 9, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.ReferenceType" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (objectReferenceImpl == null ? "NULL" : "ref=" + objectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(objectReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static ReferenceType process(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) throws JDWPException {
                PacketStream packetStream = ReferenceType.enqueueCommand(virtualMachineImpl, objectReferenceImpl);
                return ReferenceType.waitForReply(virtualMachineImpl, packetStream);
            }

            static ReferenceType waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new ReferenceType(virtualMachineImpl, packetStream);
            }
        }

        static class GetValues {
            static final int COMMAND = 2;
            final ValueImpl[] values;

            private GetValues(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.GetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "values(ValueImpl[]): ");
                }
                int n = packetStream.readInt();
                this.values = new ValueImpl[n];
                int n2 = 0;
                while (n2 < n) {
                    this.values[n2] = packetStream.readValue();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "values[i](ValueImpl): " + this.values[n2]);
                    }
                    ++n2;
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl, Field[] fieldArray) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 9, 2);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.GetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (objectReferenceImpl == null ? "NULL" : "ref=" + objectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(objectReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 fields(Field[]): ");
                }
                packetStream.writeInt(fieldArray.length);
                int n = 0;
                while (n < fieldArray.length) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     fields[i](Field): ");
                    }
                    fieldArray[n].write(packetStream);
                    ++n;
                }
                packetStream.send();
                return packetStream;
            }

            static GetValues process(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl, Field[] fieldArray) throws JDWPException {
                PacketStream packetStream = GetValues.enqueueCommand(virtualMachineImpl, objectReferenceImpl, fieldArray);
                return GetValues.waitForReply(virtualMachineImpl, packetStream);
            }

            static GetValues waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new GetValues(virtualMachineImpl, packetStream);
            }

            static class Field {
                final long fieldID;

                Field(long l) {
                    this.fieldID = l;
                }

                private void write(PacketStream packetStream) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     fieldID(long): " + this.fieldID);
                    }
                    packetStream.writeFieldRef(this.fieldID);
                }
            }
        }

        static class SetValues {
            static final int COMMAND = 3;

            private SetValues(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.SetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl, FieldValue[] fieldValueArray) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 9, 3);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.SetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (objectReferenceImpl == null ? "NULL" : "ref=" + objectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(objectReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 values(FieldValue[]): ");
                }
                packetStream.writeInt(fieldValueArray.length);
                int n = 0;
                while (n < fieldValueArray.length) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     values[i](FieldValue): ");
                    }
                    fieldValueArray[n].write(packetStream);
                    ++n;
                }
                packetStream.send();
                return packetStream;
            }

            static SetValues process(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl, FieldValue[] fieldValueArray) throws JDWPException {
                PacketStream packetStream = SetValues.enqueueCommand(virtualMachineImpl, objectReferenceImpl, fieldValueArray);
                return SetValues.waitForReply(virtualMachineImpl, packetStream);
            }

            static SetValues waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new SetValues(virtualMachineImpl, packetStream);
            }

            static class FieldValue {
                final long fieldID;
                final ValueImpl value;

                FieldValue(long l, ValueImpl valueImpl) {
                    this.fieldID = l;
                    this.value = valueImpl;
                }

                private void write(PacketStream packetStream) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     fieldID(long): " + this.fieldID);
                    }
                    packetStream.writeFieldRef(this.fieldID);
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     value(ValueImpl): " + this.value);
                    }
                    packetStream.writeUntaggedValue(this.value);
                }
            }
        }

        static class MonitorInfo {
            static final int COMMAND = 5;
            final ThreadReferenceImpl owner;
            final int entryCount;
            final ThreadReferenceImpl[] waiters;

            private MonitorInfo(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.MonitorInfo" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.owner = packetStream.readThreadReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "owner(ThreadReferenceImpl): " + (this.owner == null ? "NULL" : "ref=" + this.owner.ref()));
                }
                this.entryCount = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "entryCount(int): " + this.entryCount);
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "waiters(ThreadReferenceImpl[]): ");
                }
                int n = packetStream.readInt();
                this.waiters = new ThreadReferenceImpl[n];
                int n2 = 0;
                while (n2 < n) {
                    this.waiters[n2] = packetStream.readThreadReference();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "waiters[i](ThreadReferenceImpl): " + (this.waiters[n2] == null ? "NULL" : "ref=" + this.waiters[n2].ref()));
                    }
                    ++n2;
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 9, 5);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.MonitorInfo" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (objectReferenceImpl == null ? "NULL" : "ref=" + objectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(objectReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static MonitorInfo process(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) throws JDWPException {
                PacketStream packetStream = MonitorInfo.enqueueCommand(virtualMachineImpl, objectReferenceImpl);
                return MonitorInfo.waitForReply(virtualMachineImpl, packetStream);
            }

            static MonitorInfo waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new MonitorInfo(virtualMachineImpl, packetStream);
            }
        }

        static class InvokeMethod {
            static final int COMMAND = 6;
            final ValueImpl returnValue;
            final ObjectReferenceImpl exception;

            private InvokeMethod(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.InvokeMethod" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.returnValue = packetStream.readValue();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "returnValue(ValueImpl): " + this.returnValue);
                }
                this.exception = packetStream.readTaggedObjectReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "exception(ObjectReferenceImpl): " + (this.exception == null ? "NULL" : "ref=" + this.exception.ref()));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl, ThreadReferenceImpl threadReferenceImpl, ClassTypeImpl classTypeImpl, long l, ValueImpl[] valueImplArray, int n) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 9, 6);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.InvokeMethod" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (objectReferenceImpl == null ? "NULL" : "ref=" + objectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(objectReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 clazz(ClassTypeImpl): " + (classTypeImpl == null ? "NULL" : "ref=" + classTypeImpl.ref()));
                }
                packetStream.writeClassRef(classTypeImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 method(long): " + l);
                }
                packetStream.writeMethodRef(l);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 arguments(ValueImpl[]): ");
                }
                packetStream.writeInt(valueImplArray.length);
                int n2 = 0;
                while (n2 < valueImplArray.length) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     arguments[i](ValueImpl): " + valueImplArray[n2]);
                    }
                    packetStream.writeValue(valueImplArray[n2]);
                    ++n2;
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 options(int): " + n);
                }
                packetStream.writeInt(n);
                packetStream.send();
                return packetStream;
            }

            static InvokeMethod process(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl, ThreadReferenceImpl threadReferenceImpl, ClassTypeImpl classTypeImpl, long l, ValueImpl[] valueImplArray, int n) throws JDWPException {
                PacketStream packetStream = InvokeMethod.enqueueCommand(virtualMachineImpl, objectReferenceImpl, threadReferenceImpl, classTypeImpl, l, valueImplArray, n);
                return InvokeMethod.waitForReply(virtualMachineImpl, packetStream);
            }

            static InvokeMethod waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new InvokeMethod(virtualMachineImpl, packetStream);
            }
        }

        static class DisableCollection {
            static final int COMMAND = 7;

            private DisableCollection(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.DisableCollection" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 9, 7);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.DisableCollection" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (objectReferenceImpl == null ? "NULL" : "ref=" + objectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(objectReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static DisableCollection process(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) throws JDWPException {
                PacketStream packetStream = DisableCollection.enqueueCommand(virtualMachineImpl, objectReferenceImpl);
                return DisableCollection.waitForReply(virtualMachineImpl, packetStream);
            }

            static DisableCollection waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new DisableCollection(virtualMachineImpl, packetStream);
            }
        }

        static class EnableCollection {
            static final int COMMAND = 8;

            private EnableCollection(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.EnableCollection" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 9, 8);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.EnableCollection" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (objectReferenceImpl == null ? "NULL" : "ref=" + objectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(objectReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static EnableCollection process(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) throws JDWPException {
                PacketStream packetStream = EnableCollection.enqueueCommand(virtualMachineImpl, objectReferenceImpl);
                return EnableCollection.waitForReply(virtualMachineImpl, packetStream);
            }

            static EnableCollection waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new EnableCollection(virtualMachineImpl, packetStream);
            }
        }

        static class IsCollected {
            static final int COMMAND = 9;
            final boolean isCollected;

            private IsCollected(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.IsCollected" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.isCollected = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "isCollected(boolean): " + this.isCollected);
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 9, 9);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.IsCollected" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (objectReferenceImpl == null ? "NULL" : "ref=" + objectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(objectReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static IsCollected process(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) throws JDWPException {
                PacketStream packetStream = IsCollected.enqueueCommand(virtualMachineImpl, objectReferenceImpl);
                return IsCollected.waitForReply(virtualMachineImpl, packetStream);
            }

            static IsCollected waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new IsCollected(virtualMachineImpl, packetStream);
            }
        }
    }

    static class StringReference {
        static final int COMMAND_SET = 10;

        private StringReference() {
        }

        static class Value {
            static final int COMMAND = 1;
            final String stringValue;

            private Value(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.StringReference.Value" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.stringValue = packetStream.readString();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "stringValue(String): " + this.stringValue);
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 10, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.StringReference.Value" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 stringObject(ObjectReferenceImpl): " + (objectReferenceImpl == null ? "NULL" : "ref=" + objectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(objectReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Value process(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) throws JDWPException {
                PacketStream packetStream = Value.enqueueCommand(virtualMachineImpl, objectReferenceImpl);
                return Value.waitForReply(virtualMachineImpl, packetStream);
            }

            static Value waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Value(virtualMachineImpl, packetStream);
            }
        }
    }

    static class ThreadReference {
        static final int COMMAND_SET = 11;

        private ThreadReference() {
        }

        static class Name {
            static final int COMMAND = 1;
            final String threadName;

            private Name(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Name" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.threadName = packetStream.readString();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "threadName(String): " + this.threadName);
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Name" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 threadObject(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Name process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) throws JDWPException {
                PacketStream packetStream = Name.enqueueCommand(virtualMachineImpl, threadReferenceImpl);
                return Name.waitForReply(virtualMachineImpl, packetStream);
            }

            static Name waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Name(virtualMachineImpl, packetStream);
            }
        }

        static class Suspend {
            static final int COMMAND = 2;

            private Suspend(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Suspend" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 2);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Suspend" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 threadObject(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Suspend process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) throws JDWPException {
                PacketStream packetStream = Suspend.enqueueCommand(virtualMachineImpl, threadReferenceImpl);
                return Suspend.waitForReply(virtualMachineImpl, packetStream);
            }

            static Suspend waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Suspend(virtualMachineImpl, packetStream);
            }
        }

        static class Resume {
            static final int COMMAND = 3;

            private Resume(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Resume" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 3);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Resume" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 threadObject(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Resume process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) throws JDWPException {
                PacketStream packetStream = Resume.enqueueCommand(virtualMachineImpl, threadReferenceImpl);
                return Resume.waitForReply(virtualMachineImpl, packetStream);
            }

            static Resume waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Resume(virtualMachineImpl, packetStream);
            }
        }

        static class Status {
            static final int COMMAND = 4;
            final int threadStatus;
            final int suspendStatus;

            private Status(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Status" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.threadStatus = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "threadStatus(int): " + this.threadStatus);
                }
                this.suspendStatus = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "suspendStatus(int): " + this.suspendStatus);
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 4);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Status" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 threadObject(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Status process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) throws JDWPException {
                PacketStream packetStream = Status.enqueueCommand(virtualMachineImpl, threadReferenceImpl);
                return Status.waitForReply(virtualMachineImpl, packetStream);
            }

            static Status waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Status(virtualMachineImpl, packetStream);
            }
        }

        static class ThreadGroup {
            static final int COMMAND = 5;
            final ThreadGroupReferenceImpl group;

            private ThreadGroup(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.ThreadGroup" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.group = packetStream.readThreadGroupReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "group(ThreadGroupReferenceImpl): " + (this.group == null ? "NULL" : "ref=" + this.group.ref()));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 5);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.ThreadGroup" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 threadObject(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static ThreadGroup process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) throws JDWPException {
                PacketStream packetStream = ThreadGroup.enqueueCommand(virtualMachineImpl, threadReferenceImpl);
                return ThreadGroup.waitForReply(virtualMachineImpl, packetStream);
            }

            static ThreadGroup waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new ThreadGroup(virtualMachineImpl, packetStream);
            }
        }

        static class Frames {
            static final int COMMAND = 6;
            final Frame[] frames;

            private Frames(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Frames" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "frames(Frame[]): ");
                }
                int n = packetStream.readInt();
                this.frames = new Frame[n];
                int n2 = 0;
                while (n2 < n) {
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "frames[i](Frame): ");
                    }
                    this.frames[n2] = new Frame(null, virtualMachineImpl, packetStream);
                    ++n2;
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, int n, int n2) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 6);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Frames" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 threadObject(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 startFrame(int): " + n);
                }
                packetStream.writeInt(n);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 length(int): " + n2);
                }
                packetStream.writeInt(n2);
                packetStream.send();
                return packetStream;
            }

            static Frames process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, int n, int n2) throws JDWPException {
                PacketStream packetStream = Frames.enqueueCommand(virtualMachineImpl, threadReferenceImpl, n, n2);
                return Frames.waitForReply(virtualMachineImpl, packetStream);
            }

            static Frames waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Frames(virtualMachineImpl, packetStream);
            }

            static class Frame {
                final long frameID;
                final Location location;

                /* synthetic */ Frame(1 var1_1, VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this(virtualMachineImpl, packetStream);
                }

                private Frame(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this.frameID = packetStream.readFrameRef();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "frameID(long): " + this.frameID);
                    }
                    this.location = packetStream.readLocation();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "location(Location): " + this.location);
                    }
                }
            }
        }

        static class FrameCount {
            static final int COMMAND = 7;
            final int frameCount;

            private FrameCount(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.FrameCount" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.frameCount = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "frameCount(int): " + this.frameCount);
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 7);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.FrameCount" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 threadObject(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static FrameCount process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) throws JDWPException {
                PacketStream packetStream = FrameCount.enqueueCommand(virtualMachineImpl, threadReferenceImpl);
                return FrameCount.waitForReply(virtualMachineImpl, packetStream);
            }

            static FrameCount waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new FrameCount(virtualMachineImpl, packetStream);
            }
        }

        static class OwnedMonitors {
            static final int COMMAND = 8;
            final ObjectReferenceImpl[] owned;

            private OwnedMonitors(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.OwnedMonitors" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "owned(ObjectReferenceImpl[]): ");
                }
                int n = packetStream.readInt();
                this.owned = new ObjectReferenceImpl[n];
                int n2 = 0;
                while (n2 < n) {
                    this.owned[n2] = packetStream.readTaggedObjectReference();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "owned[i](ObjectReferenceImpl): " + (this.owned[n2] == null ? "NULL" : "ref=" + this.owned[n2].ref()));
                    }
                    ++n2;
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 8);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.OwnedMonitors" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 threadObject(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static OwnedMonitors process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) throws JDWPException {
                PacketStream packetStream = OwnedMonitors.enqueueCommand(virtualMachineImpl, threadReferenceImpl);
                return OwnedMonitors.waitForReply(virtualMachineImpl, packetStream);
            }

            static OwnedMonitors waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new OwnedMonitors(virtualMachineImpl, packetStream);
            }
        }

        static class CurrentContendedMonitor {
            static final int COMMAND = 9;
            final ObjectReferenceImpl monitor;

            private CurrentContendedMonitor(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.CurrentContendedMonitor" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.monitor = packetStream.readTaggedObjectReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "monitor(ObjectReferenceImpl): " + (this.monitor == null ? "NULL" : "ref=" + this.monitor.ref()));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 9);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.CurrentContendedMonitor" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 threadObject(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static CurrentContendedMonitor process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) throws JDWPException {
                PacketStream packetStream = CurrentContendedMonitor.enqueueCommand(virtualMachineImpl, threadReferenceImpl);
                return CurrentContendedMonitor.waitForReply(virtualMachineImpl, packetStream);
            }

            static CurrentContendedMonitor waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new CurrentContendedMonitor(virtualMachineImpl, packetStream);
            }
        }

        static class Stop {
            static final int COMMAND = 10;

            private Stop(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Stop" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, ObjectReferenceImpl objectReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 10);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Stop" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 threadObject(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 throwable(ObjectReferenceImpl): " + (objectReferenceImpl == null ? "NULL" : "ref=" + objectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(objectReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Stop process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, ObjectReferenceImpl objectReferenceImpl) throws JDWPException {
                PacketStream packetStream = Stop.enqueueCommand(virtualMachineImpl, threadReferenceImpl, objectReferenceImpl);
                return Stop.waitForReply(virtualMachineImpl, packetStream);
            }

            static Stop waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Stop(virtualMachineImpl, packetStream);
            }
        }

        static class Interrupt {
            static final int COMMAND = 11;

            private Interrupt(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Interrupt" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 11);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Interrupt" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 threadObject(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Interrupt process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) throws JDWPException {
                PacketStream packetStream = Interrupt.enqueueCommand(virtualMachineImpl, threadReferenceImpl);
                return Interrupt.waitForReply(virtualMachineImpl, packetStream);
            }

            static Interrupt waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Interrupt(virtualMachineImpl, packetStream);
            }
        }

        static class SuspendCount {
            static final int COMMAND = 12;
            final int suspendCount;

            private SuspendCount(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.SuspendCount" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.suspendCount = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "suspendCount(int): " + this.suspendCount);
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 12);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.SuspendCount" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 threadObject(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static SuspendCount process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) throws JDWPException {
                PacketStream packetStream = SuspendCount.enqueueCommand(virtualMachineImpl, threadReferenceImpl);
                return SuspendCount.waitForReply(virtualMachineImpl, packetStream);
            }

            static SuspendCount waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new SuspendCount(virtualMachineImpl, packetStream);
            }
        }
    }

    static class ThreadGroupReference {
        static final int COMMAND_SET = 12;

        private ThreadGroupReference() {
        }

        static class Name {
            static final int COMMAND = 1;
            final String groupName;

            private Name(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadGroupReference.Name" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.groupName = packetStream.readString();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "groupName(String): " + this.groupName);
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadGroupReferenceImpl threadGroupReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 12, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadGroupReference.Name" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 group(ThreadGroupReferenceImpl): " + (threadGroupReferenceImpl == null ? "NULL" : "ref=" + threadGroupReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadGroupReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Name process(VirtualMachineImpl virtualMachineImpl, ThreadGroupReferenceImpl threadGroupReferenceImpl) throws JDWPException {
                PacketStream packetStream = Name.enqueueCommand(virtualMachineImpl, threadGroupReferenceImpl);
                return Name.waitForReply(virtualMachineImpl, packetStream);
            }

            static Name waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Name(virtualMachineImpl, packetStream);
            }
        }

        static class Parent {
            static final int COMMAND = 2;
            final ThreadGroupReferenceImpl parentGroup;

            private Parent(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadGroupReference.Parent" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.parentGroup = packetStream.readThreadGroupReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "parentGroup(ThreadGroupReferenceImpl): " + (this.parentGroup == null ? "NULL" : "ref=" + this.parentGroup.ref()));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadGroupReferenceImpl threadGroupReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 12, 2);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadGroupReference.Parent" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 group(ThreadGroupReferenceImpl): " + (threadGroupReferenceImpl == null ? "NULL" : "ref=" + threadGroupReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadGroupReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Parent process(VirtualMachineImpl virtualMachineImpl, ThreadGroupReferenceImpl threadGroupReferenceImpl) throws JDWPException {
                PacketStream packetStream = Parent.enqueueCommand(virtualMachineImpl, threadGroupReferenceImpl);
                return Parent.waitForReply(virtualMachineImpl, packetStream);
            }

            static Parent waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Parent(virtualMachineImpl, packetStream);
            }
        }

        static class Children {
            static final int COMMAND = 3;
            final ThreadReferenceImpl[] childThreads;
            final ThreadGroupReferenceImpl[] childGroups;

            private Children(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadGroupReference.Children" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "childThreads(ThreadReferenceImpl[]): ");
                }
                int n = packetStream.readInt();
                this.childThreads = new ThreadReferenceImpl[n];
                int n2 = 0;
                while (n2 < n) {
                    this.childThreads[n2] = packetStream.readThreadReference();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "childThreads[i](ThreadReferenceImpl): " + (this.childThreads[n2] == null ? "NULL" : "ref=" + this.childThreads[n2].ref()));
                    }
                    ++n2;
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "childGroups(ThreadGroupReferenceImpl[]): ");
                }
                int n3 = packetStream.readInt();
                this.childGroups = new ThreadGroupReferenceImpl[n3];
                int n4 = 0;
                while (n4 < n3) {
                    this.childGroups[n4] = packetStream.readThreadGroupReference();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "childGroups[i](ThreadGroupReferenceImpl): " + (this.childGroups[n4] == null ? "NULL" : "ref=" + this.childGroups[n4].ref()));
                    }
                    ++n4;
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadGroupReferenceImpl threadGroupReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 12, 3);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadGroupReference.Children" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 group(ThreadGroupReferenceImpl): " + (threadGroupReferenceImpl == null ? "NULL" : "ref=" + threadGroupReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadGroupReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Children process(VirtualMachineImpl virtualMachineImpl, ThreadGroupReferenceImpl threadGroupReferenceImpl) throws JDWPException {
                PacketStream packetStream = Children.enqueueCommand(virtualMachineImpl, threadGroupReferenceImpl);
                return Children.waitForReply(virtualMachineImpl, packetStream);
            }

            static Children waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Children(virtualMachineImpl, packetStream);
            }
        }
    }

    static class ArrayReference {
        static final int COMMAND_SET = 13;

        private ArrayReference() {
        }

        static class Length {
            static final int COMMAND = 1;
            final int arrayLength;

            private Length(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ArrayReference.Length" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.arrayLength = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "arrayLength(int): " + this.arrayLength);
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ArrayReferenceImpl arrayReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 13, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ArrayReference.Length" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 arrayObject(ArrayReferenceImpl): " + (arrayReferenceImpl == null ? "NULL" : "ref=" + arrayReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(arrayReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Length process(VirtualMachineImpl virtualMachineImpl, ArrayReferenceImpl arrayReferenceImpl) throws JDWPException {
                PacketStream packetStream = Length.enqueueCommand(virtualMachineImpl, arrayReferenceImpl);
                return Length.waitForReply(virtualMachineImpl, packetStream);
            }

            static Length waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Length(virtualMachineImpl, packetStream);
            }
        }

        static class GetValues {
            static final int COMMAND = 2;
            final List values;

            private GetValues(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ArrayReference.GetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.values = packetStream.readArrayRegion();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "values(List): " + this.values);
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ArrayReferenceImpl arrayReferenceImpl, int n, int n2) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 13, 2);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ArrayReference.GetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 arrayObject(ArrayReferenceImpl): " + (arrayReferenceImpl == null ? "NULL" : "ref=" + arrayReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(arrayReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 firstIndex(int): " + n);
                }
                packetStream.writeInt(n);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 length(int): " + n2);
                }
                packetStream.writeInt(n2);
                packetStream.send();
                return packetStream;
            }

            static GetValues process(VirtualMachineImpl virtualMachineImpl, ArrayReferenceImpl arrayReferenceImpl, int n, int n2) throws JDWPException {
                PacketStream packetStream = GetValues.enqueueCommand(virtualMachineImpl, arrayReferenceImpl, n, n2);
                return GetValues.waitForReply(virtualMachineImpl, packetStream);
            }

            static GetValues waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new GetValues(virtualMachineImpl, packetStream);
            }
        }

        static class SetValues {
            static final int COMMAND = 3;

            private SetValues(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ArrayReference.SetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ArrayReferenceImpl arrayReferenceImpl, int n, ValueImpl[] valueImplArray) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 13, 3);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ArrayReference.SetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 arrayObject(ArrayReferenceImpl): " + (arrayReferenceImpl == null ? "NULL" : "ref=" + arrayReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(arrayReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 firstIndex(int): " + n);
                }
                packetStream.writeInt(n);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 values(ValueImpl[]): ");
                }
                packetStream.writeInt(valueImplArray.length);
                int n2 = 0;
                while (n2 < valueImplArray.length) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     values[i](ValueImpl): " + valueImplArray[n2]);
                    }
                    packetStream.writeUntaggedValue(valueImplArray[n2]);
                    ++n2;
                }
                packetStream.send();
                return packetStream;
            }

            static SetValues process(VirtualMachineImpl virtualMachineImpl, ArrayReferenceImpl arrayReferenceImpl, int n, ValueImpl[] valueImplArray) throws JDWPException {
                PacketStream packetStream = SetValues.enqueueCommand(virtualMachineImpl, arrayReferenceImpl, n, valueImplArray);
                return SetValues.waitForReply(virtualMachineImpl, packetStream);
            }

            static SetValues waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new SetValues(virtualMachineImpl, packetStream);
            }
        }
    }

    static class ClassLoaderReference {
        static final int COMMAND_SET = 14;

        private ClassLoaderReference() {
        }

        static class VisibleClasses {
            static final int COMMAND = 1;
            final ClassInfo[] classes;

            private VisibleClasses(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ClassLoaderReference.VisibleClasses" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "classes(ClassInfo[]): ");
                }
                int n = packetStream.readInt();
                this.classes = new ClassInfo[n];
                int n2 = 0;
                while (n2 < n) {
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "classes[i](ClassInfo): ");
                    }
                    this.classes[n2] = new ClassInfo(null, virtualMachineImpl, packetStream);
                    ++n2;
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ClassLoaderReferenceImpl classLoaderReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 14, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ClassLoaderReference.VisibleClasses" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 classLoaderObject(ClassLoaderReferenceImpl): " + (classLoaderReferenceImpl == null ? "NULL" : "ref=" + classLoaderReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(classLoaderReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static VisibleClasses process(VirtualMachineImpl virtualMachineImpl, ClassLoaderReferenceImpl classLoaderReferenceImpl) throws JDWPException {
                PacketStream packetStream = VisibleClasses.enqueueCommand(virtualMachineImpl, classLoaderReferenceImpl);
                return VisibleClasses.waitForReply(virtualMachineImpl, packetStream);
            }

            static VisibleClasses waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new VisibleClasses(virtualMachineImpl, packetStream);
            }

            static class ClassInfo {
                final byte refTypeTag;
                final long typeID;

                /* synthetic */ ClassInfo(1 var1_1, VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this(virtualMachineImpl, packetStream);
                }

                private ClassInfo(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this.refTypeTag = packetStream.readByte();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "refTypeTag(byte): " + this.refTypeTag);
                    }
                    this.typeID = packetStream.readClassRef();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "typeID(long): ref=" + this.typeID);
                    }
                }
            }
        }
    }

    static class EventRequest {
        static final int COMMAND_SET = 15;

        private EventRequest() {
        }

        static class Set {
            static final int COMMAND = 1;
            final int requestID;

            private Set(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.EventRequest.Set" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.requestID = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "requestID(int): " + this.requestID);
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, byte by, byte by2, Modifier[] modifierArray) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 15, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.EventRequest.Set" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 eventKind(byte): " + by);
                }
                packetStream.writeByte(by);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 suspendPolicy(byte): " + by2);
                }
                packetStream.writeByte(by2);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 modifiers(Modifier[]): ");
                }
                packetStream.writeInt(modifierArray.length);
                int n = 0;
                while (n < modifierArray.length) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     modifiers[i](Modifier): ");
                    }
                    modifierArray[n].write(packetStream);
                    ++n;
                }
                packetStream.send();
                return packetStream;
            }

            static Set process(VirtualMachineImpl virtualMachineImpl, byte by, byte by2, Modifier[] modifierArray) throws JDWPException {
                PacketStream packetStream = Set.enqueueCommand(virtualMachineImpl, by, by2, modifierArray);
                return Set.waitForReply(virtualMachineImpl, packetStream);
            }

            static Set waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Set(virtualMachineImpl, packetStream);
            }

            static class Modifier {
                final byte modKind;
                ModifierCommon aModifierCommon;

                Modifier(byte by, ModifierCommon modifierCommon) {
                    this.modKind = by;
                    this.aModifierCommon = modifierCommon;
                }

                private void write(PacketStream packetStream) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     modKind(byte): " + this.modKind);
                    }
                    packetStream.writeByte(this.modKind);
                    this.aModifierCommon.write(packetStream);
                }

                static abstract class ModifierCommon {
                    ModifierCommon() {
                    }

                    abstract void write(PacketStream var1);
                }

                static class Count
                extends ModifierCommon {
                    static final byte ALT_ID = 1;
                    final int count;

                    Count(int n) {
                        this.count = n;
                    }

                    static Modifier create(int n) {
                        return new Modifier(1, new Count(n));
                    }

                    void write(PacketStream packetStream) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         count(int): " + this.count);
                        }
                        packetStream.writeInt(this.count);
                    }
                }

                static class Conditional
                extends ModifierCommon {
                    static final byte ALT_ID = 2;
                    final int exprID;

                    Conditional(int n) {
                        this.exprID = n;
                    }

                    static Modifier create(int n) {
                        return new Modifier(2, new Conditional(n));
                    }

                    void write(PacketStream packetStream) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         exprID(int): " + this.exprID);
                        }
                        packetStream.writeInt(this.exprID);
                    }
                }

                static class ThreadOnly
                extends ModifierCommon {
                    static final byte ALT_ID = 3;
                    final ThreadReferenceImpl thread;

                    ThreadOnly(ThreadReferenceImpl threadReferenceImpl) {
                        this.thread = threadReferenceImpl;
                    }

                    static Modifier create(ThreadReferenceImpl threadReferenceImpl) {
                        return new Modifier(3, new ThreadOnly(threadReferenceImpl));
                    }

                    void write(PacketStream packetStream) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        packetStream.writeObjectRef(this.thread.ref());
                    }
                }

                static class ClassOnly
                extends ModifierCommon {
                    static final byte ALT_ID = 4;
                    final ReferenceTypeImpl clazz;

                    ClassOnly(ReferenceTypeImpl referenceTypeImpl) {
                        this.clazz = referenceTypeImpl;
                    }

                    static Modifier create(ReferenceTypeImpl referenceTypeImpl) {
                        return new Modifier(4, new ClassOnly(referenceTypeImpl));
                    }

                    void write(PacketStream packetStream) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         clazz(ReferenceTypeImpl): " + (this.clazz == null ? "NULL" : "ref=" + this.clazz.ref()));
                        }
                        packetStream.writeClassRef(this.clazz.ref());
                    }
                }

                static class ClassMatch
                extends ModifierCommon {
                    static final byte ALT_ID = 5;
                    final String classPattern;

                    ClassMatch(String string) {
                        this.classPattern = string;
                    }

                    static Modifier create(String string) {
                        return new Modifier(5, new ClassMatch(string));
                    }

                    void write(PacketStream packetStream) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         classPattern(String): " + this.classPattern);
                        }
                        packetStream.writeString(this.classPattern);
                    }
                }

                static class ClassExclude
                extends ModifierCommon {
                    static final byte ALT_ID = 6;
                    final String classPattern;

                    ClassExclude(String string) {
                        this.classPattern = string;
                    }

                    static Modifier create(String string) {
                        return new Modifier(6, new ClassExclude(string));
                    }

                    void write(PacketStream packetStream) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         classPattern(String): " + this.classPattern);
                        }
                        packetStream.writeString(this.classPattern);
                    }
                }

                static class LocationOnly
                extends ModifierCommon {
                    static final byte ALT_ID = 7;
                    final Location loc;

                    LocationOnly(Location location) {
                        this.loc = location;
                    }

                    static Modifier create(Location location) {
                        return new Modifier(7, new LocationOnly(location));
                    }

                    void write(PacketStream packetStream) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         loc(Location): " + this.loc);
                        }
                        packetStream.writeLocation(this.loc);
                    }
                }

                static class ExceptionOnly
                extends ModifierCommon {
                    static final byte ALT_ID = 8;
                    final ReferenceTypeImpl exceptionOrNull;
                    final boolean caught;
                    final boolean uncaught;

                    ExceptionOnly(ReferenceTypeImpl referenceTypeImpl, boolean bl, boolean bl2) {
                        this.exceptionOrNull = referenceTypeImpl;
                        this.caught = bl;
                        this.uncaught = bl2;
                    }

                    static Modifier create(ReferenceTypeImpl referenceTypeImpl, boolean bl, boolean bl2) {
                        return new Modifier(8, new ExceptionOnly(referenceTypeImpl, bl, bl2));
                    }

                    void write(PacketStream packetStream) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         exceptionOrNull(ReferenceTypeImpl): " + (this.exceptionOrNull == null ? "NULL" : "ref=" + this.exceptionOrNull.ref()));
                        }
                        packetStream.writeClassRef(this.exceptionOrNull.ref());
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         caught(boolean): " + this.caught);
                        }
                        packetStream.writeBoolean(this.caught);
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         uncaught(boolean): " + this.uncaught);
                        }
                        packetStream.writeBoolean(this.uncaught);
                    }
                }

                static class FieldOnly
                extends ModifierCommon {
                    static final byte ALT_ID = 9;
                    final ReferenceTypeImpl declaring;
                    final long fieldID;

                    FieldOnly(ReferenceTypeImpl referenceTypeImpl, long l) {
                        this.declaring = referenceTypeImpl;
                        this.fieldID = l;
                    }

                    static Modifier create(ReferenceTypeImpl referenceTypeImpl, long l) {
                        return new Modifier(9, new FieldOnly(referenceTypeImpl, l));
                    }

                    void write(PacketStream packetStream) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         declaring(ReferenceTypeImpl): " + (this.declaring == null ? "NULL" : "ref=" + this.declaring.ref()));
                        }
                        packetStream.writeClassRef(this.declaring.ref());
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         fieldID(long): " + this.fieldID);
                        }
                        packetStream.writeFieldRef(this.fieldID);
                    }
                }

                static class Step
                extends ModifierCommon {
                    static final byte ALT_ID = 10;
                    final ThreadReferenceImpl thread;
                    final int size;
                    final int depth;

                    Step(ThreadReferenceImpl threadReferenceImpl, int n, int n2) {
                        this.thread = threadReferenceImpl;
                        this.size = n;
                        this.depth = n2;
                    }

                    static Modifier create(ThreadReferenceImpl threadReferenceImpl, int n, int n2) {
                        return new Modifier(10, new Step(threadReferenceImpl, n, n2));
                    }

                    void write(PacketStream packetStream) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        packetStream.writeObjectRef(this.thread.ref());
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         size(int): " + this.size);
                        }
                        packetStream.writeInt(this.size);
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         depth(int): " + this.depth);
                        }
                        packetStream.writeInt(this.depth);
                    }
                }
            }
        }

        static class Clear {
            static final int COMMAND = 2;

            private Clear(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.EventRequest.Clear" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, byte by, int n) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 15, 2);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.EventRequest.Clear" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 event(byte): " + by);
                }
                packetStream.writeByte(by);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 requestID(int): " + n);
                }
                packetStream.writeInt(n);
                packetStream.send();
                return packetStream;
            }

            static Clear process(VirtualMachineImpl virtualMachineImpl, byte by, int n) throws JDWPException {
                PacketStream packetStream = Clear.enqueueCommand(virtualMachineImpl, by, n);
                return Clear.waitForReply(virtualMachineImpl, packetStream);
            }

            static Clear waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Clear(virtualMachineImpl, packetStream);
            }
        }

        static class ClearAllBreakpoints {
            static final int COMMAND = 3;

            private ClearAllBreakpoints(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.EventRequest.ClearAllBreakpoints" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 15, 3);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.EventRequest.ClearAllBreakpoints" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static ClearAllBreakpoints process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = ClearAllBreakpoints.enqueueCommand(virtualMachineImpl);
                return ClearAllBreakpoints.waitForReply(virtualMachineImpl, packetStream);
            }

            static ClearAllBreakpoints waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new ClearAllBreakpoints(virtualMachineImpl, packetStream);
            }
        }
    }

    static class StackFrame {
        static final int COMMAND_SET = 16;

        private StackFrame() {
        }

        static class GetValues {
            static final int COMMAND = 1;
            final ValueImpl[] values;

            private GetValues(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.StackFrame.GetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "values(ValueImpl[]): ");
                }
                int n = packetStream.readInt();
                this.values = new ValueImpl[n];
                int n2 = 0;
                while (n2 < n) {
                    this.values[n2] = packetStream.readValue();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "values[i](ValueImpl): " + this.values[n2]);
                    }
                    ++n2;
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, long l, SlotInfo[] slotInfoArray) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 16, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.StackFrame.GetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 threadObject(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 frame(long): " + l);
                }
                packetStream.writeFrameRef(l);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 slots(SlotInfo[]): ");
                }
                packetStream.writeInt(slotInfoArray.length);
                int n = 0;
                while (n < slotInfoArray.length) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     slots[i](SlotInfo): ");
                    }
                    slotInfoArray[n].write(packetStream);
                    ++n;
                }
                packetStream.send();
                return packetStream;
            }

            static GetValues process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, long l, SlotInfo[] slotInfoArray) throws JDWPException {
                PacketStream packetStream = GetValues.enqueueCommand(virtualMachineImpl, threadReferenceImpl, l, slotInfoArray);
                return GetValues.waitForReply(virtualMachineImpl, packetStream);
            }

            static GetValues waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new GetValues(virtualMachineImpl, packetStream);
            }

            static class SlotInfo {
                final int slot;
                final byte sigbyte;

                SlotInfo(int n, byte by) {
                    this.slot = n;
                    this.sigbyte = by;
                }

                private void write(PacketStream packetStream) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     slot(int): " + this.slot);
                    }
                    packetStream.writeInt(this.slot);
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     sigbyte(byte): " + this.sigbyte);
                    }
                    packetStream.writeByte(this.sigbyte);
                }
            }
        }

        static class SetValues {
            static final int COMMAND = 2;

            private SetValues(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.StackFrame.SetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, long l, SlotInfo[] slotInfoArray) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 16, 2);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.StackFrame.SetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 threadObject(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 frame(long): " + l);
                }
                packetStream.writeFrameRef(l);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 slotValues(SlotInfo[]): ");
                }
                packetStream.writeInt(slotInfoArray.length);
                int n = 0;
                while (n < slotInfoArray.length) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     slotValues[i](SlotInfo): ");
                    }
                    slotInfoArray[n].write(packetStream);
                    ++n;
                }
                packetStream.send();
                return packetStream;
            }

            static SetValues process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, long l, SlotInfo[] slotInfoArray) throws JDWPException {
                PacketStream packetStream = SetValues.enqueueCommand(virtualMachineImpl, threadReferenceImpl, l, slotInfoArray);
                return SetValues.waitForReply(virtualMachineImpl, packetStream);
            }

            static SetValues waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new SetValues(virtualMachineImpl, packetStream);
            }

            static class SlotInfo {
                final int slot;
                final ValueImpl slotValue;

                SlotInfo(int n, ValueImpl valueImpl) {
                    this.slot = n;
                    this.slotValue = valueImpl;
                }

                private void write(PacketStream packetStream) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     slot(int): " + this.slot);
                    }
                    packetStream.writeInt(this.slot);
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     slotValue(ValueImpl): " + this.slotValue);
                    }
                    packetStream.writeValue(this.slotValue);
                }
            }
        }

        static class ThisObject {
            static final int COMMAND = 3;
            final ObjectReferenceImpl objectThis;

            private ThisObject(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.StackFrame.ThisObject" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.objectThis = packetStream.readTaggedObjectReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "objectThis(ObjectReferenceImpl): " + (this.objectThis == null ? "NULL" : "ref=" + this.objectThis.ref()));
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, long l) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 16, 3);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.StackFrame.ThisObject" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 threadObject(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 frame(long): " + l);
                }
                packetStream.writeFrameRef(l);
                packetStream.send();
                return packetStream;
            }

            static ThisObject process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, long l) throws JDWPException {
                PacketStream packetStream = ThisObject.enqueueCommand(virtualMachineImpl, threadReferenceImpl, l);
                return ThisObject.waitForReply(virtualMachineImpl, packetStream);
            }

            static ThisObject waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new ThisObject(virtualMachineImpl, packetStream);
            }
        }
    }

    static class ClassObjectReference {
        static final int COMMAND_SET = 17;

        private ClassObjectReference() {
        }

        static class ReflectedType {
            static final int COMMAND = 1;
            final byte refTypeTag;
            final long typeID;

            private ReflectedType(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ClassObjectReference.ReflectedType" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.refTypeTag = packetStream.readByte();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "refTypeTag(byte): " + this.refTypeTag);
                }
                this.typeID = packetStream.readClassRef();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "typeID(long): ref=" + this.typeID);
                }
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ClassObjectReferenceImpl classObjectReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 17, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ClassObjectReference.ReflectedType" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 classObject(ClassObjectReferenceImpl): " + (classObjectReferenceImpl == null ? "NULL" : "ref=" + classObjectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(classObjectReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static ReflectedType process(VirtualMachineImpl virtualMachineImpl, ClassObjectReferenceImpl classObjectReferenceImpl) throws JDWPException {
                PacketStream packetStream = ReflectedType.enqueueCommand(virtualMachineImpl, classObjectReferenceImpl);
                return ReflectedType.waitForReply(virtualMachineImpl, packetStream);
            }

            static ReflectedType waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new ReflectedType(virtualMachineImpl, packetStream);
            }
        }
    }

    static class Event {
        static final int COMMAND_SET = 64;

        private Event() {
        }

        static class Composite {
            static final int COMMAND = 100;
            final byte suspendPolicy;
            final Events[] events;

            Composite(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.Event.Composite" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.suspendPolicy = packetStream.readByte();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "suspendPolicy(byte): " + this.suspendPolicy);
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "events(Events[]): ");
                }
                int n = packetStream.readInt();
                this.events = new Events[n];
                int n2 = 0;
                while (n2 < n) {
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "events[i](Events): ");
                    }
                    this.events[n2] = new Events(virtualMachineImpl, packetStream);
                    ++n2;
                }
            }

            static class Events {
                final byte eventKind;
                EventsCommon aEventsCommon;

                Events(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this.eventKind = packetStream.readByte();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "eventKind(byte): " + this.eventKind);
                    }
                    switch (this.eventKind) {
                        case 90: {
                            this.aEventsCommon = new VMStart(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 1: {
                            this.aEventsCommon = new SingleStep(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 2: {
                            this.aEventsCommon = new Breakpoint(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 40: {
                            this.aEventsCommon = new MethodEntry(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 41: {
                            this.aEventsCommon = new MethodExit(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 4: {
                            this.aEventsCommon = new Exception(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 6: {
                            this.aEventsCommon = new ThreadStart(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 7: {
                            this.aEventsCommon = new ThreadDeath(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 8: {
                            this.aEventsCommon = new ClassPrepare(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 9: {
                            this.aEventsCommon = new ClassUnload(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 20: {
                            this.aEventsCommon = new FieldAccess(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 21: {
                            this.aEventsCommon = new FieldModification(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 99: {
                            this.aEventsCommon = new VMDeath(virtualMachineImpl, packetStream);
                            break;
                        }
                    }
                }

                static abstract class EventsCommon {
                    EventsCommon() {
                    }

                    abstract byte eventKind();
                }

                static class VMStart
                extends EventsCommon {
                    static final byte ALT_ID = 90;
                    final int requestID;
                    final ThreadReferenceImpl thread;

                    VMStart(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                    }

                    byte eventKind() {
                        return 90;
                    }
                }

                static class SingleStep
                extends EventsCommon {
                    static final byte ALT_ID = 1;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;

                    SingleStep(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = packetStream.readLocation();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                    }

                    byte eventKind() {
                        return 1;
                    }
                }

                static class Breakpoint
                extends EventsCommon {
                    static final byte ALT_ID = 2;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;

                    Breakpoint(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = packetStream.readLocation();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                    }

                    byte eventKind() {
                        return 2;
                    }
                }

                static class MethodEntry
                extends EventsCommon {
                    static final byte ALT_ID = 40;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;

                    MethodEntry(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = packetStream.readLocation();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                    }

                    byte eventKind() {
                        return 40;
                    }
                }

                static class MethodExit
                extends EventsCommon {
                    static final byte ALT_ID = 41;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;

                    MethodExit(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = packetStream.readLocation();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                    }

                    byte eventKind() {
                        return 41;
                    }
                }

                static class Exception
                extends EventsCommon {
                    static final byte ALT_ID = 4;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;
                    final ObjectReferenceImpl exception;
                    final Location catchLocation;

                    Exception(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = packetStream.readLocation();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                        this.exception = packetStream.readTaggedObjectReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "exception(ObjectReferenceImpl): " + (this.exception == null ? "NULL" : "ref=" + this.exception.ref()));
                        }
                        this.catchLocation = packetStream.readLocation();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "catchLocation(Location): " + this.catchLocation);
                        }
                    }

                    byte eventKind() {
                        return 4;
                    }
                }

                static class ThreadStart
                extends EventsCommon {
                    static final byte ALT_ID = 6;
                    final int requestID;
                    final ThreadReferenceImpl thread;

                    ThreadStart(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                    }

                    byte eventKind() {
                        return 6;
                    }
                }

                static class ThreadDeath
                extends EventsCommon {
                    static final byte ALT_ID = 7;
                    final int requestID;
                    final ThreadReferenceImpl thread;

                    ThreadDeath(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                    }

                    byte eventKind() {
                        return 7;
                    }
                }

                static class ClassPrepare
                extends EventsCommon {
                    static final byte ALT_ID = 8;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final byte refTypeTag;
                    final long typeID;
                    final String signature;
                    final int status;

                    ClassPrepare(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.refTypeTag = packetStream.readByte();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "refTypeTag(byte): " + this.refTypeTag);
                        }
                        this.typeID = packetStream.readClassRef();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "typeID(long): ref=" + this.typeID);
                        }
                        this.signature = packetStream.readString();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "signature(String): " + this.signature);
                        }
                        this.status = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "status(int): " + this.status);
                        }
                    }

                    byte eventKind() {
                        return 8;
                    }
                }

                static class ClassUnload
                extends EventsCommon {
                    static final byte ALT_ID = 9;
                    final int requestID;
                    final String signature;

                    ClassUnload(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.signature = packetStream.readString();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "signature(String): " + this.signature);
                        }
                    }

                    byte eventKind() {
                        return 9;
                    }
                }

                static class FieldAccess
                extends EventsCommon {
                    static final byte ALT_ID = 20;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;
                    final byte refTypeTag;
                    final long typeID;
                    final long fieldID;
                    final ObjectReferenceImpl object;

                    FieldAccess(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = packetStream.readLocation();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                        this.refTypeTag = packetStream.readByte();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "refTypeTag(byte): " + this.refTypeTag);
                        }
                        this.typeID = packetStream.readClassRef();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "typeID(long): ref=" + this.typeID);
                        }
                        this.fieldID = packetStream.readFieldRef();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "fieldID(long): " + this.fieldID);
                        }
                        this.object = packetStream.readTaggedObjectReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "object(ObjectReferenceImpl): " + (this.object == null ? "NULL" : "ref=" + this.object.ref()));
                        }
                    }

                    byte eventKind() {
                        return 20;
                    }
                }

                static class FieldModification
                extends EventsCommon {
                    static final byte ALT_ID = 21;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;
                    final byte refTypeTag;
                    final long typeID;
                    final long fieldID;
                    final ObjectReferenceImpl object;
                    final ValueImpl valueToBe;

                    FieldModification(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = packetStream.readLocation();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                        this.refTypeTag = packetStream.readByte();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "refTypeTag(byte): " + this.refTypeTag);
                        }
                        this.typeID = packetStream.readClassRef();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "typeID(long): ref=" + this.typeID);
                        }
                        this.fieldID = packetStream.readFieldRef();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "fieldID(long): " + this.fieldID);
                        }
                        this.object = packetStream.readTaggedObjectReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "object(ObjectReferenceImpl): " + (this.object == null ? "NULL" : "ref=" + this.object.ref()));
                        }
                        this.valueToBe = packetStream.readValue();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "valueToBe(ValueImpl): " + this.valueToBe);
                        }
                    }

                    byte eventKind() {
                        return 21;
                    }
                }

                static class VMDeath
                extends EventsCommon {
                    static final byte ALT_ID = 99;
                    final int requestID;

                    VMDeath(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                    }

                    byte eventKind() {
                        return 99;
                    }
                }
            }
        }
    }

    static class Error {
        static final int INVALID_TAG = 500;
        static final int ALREADY_INVOKING = 502;
        static final int INVALID_INDEX = 503;
        static final int INVALID_LENGTH = 504;
        static final int INVALID_STRING = 506;
        static final int INVALID_CLASS_LOADER = 507;
        static final int INVALID_ARRAY = 508;
        static final int TRANSPORT_LOAD = 509;
        static final int TRANSPORT_INIT = 510;
        static final int NATIVE_METHOD = 511;
        static final int INVALID_COUNT = 512;
        static final int VM_DEAD = 112;
        static final int INVALID_MONITOR = 50;
        static final int OUT_OF_MEMORY = 110;
        static final int INVALID_SLOT = 35;
        static final int INVALID_CLASS_FORMAT = 60;
        static final int INVALID_THREAD = 10;
        static final int INTERRUPT = 52;
        static final int NOT_MONITOR_OWNER = 51;
        static final int CIRCULAR_CLASS_DEFINITION = 61;
        static final int ACCESS_DENIED = 111;
        static final int INVALID_FIELDID = 25;
        static final int TYPE_MISMATCH = 34;
        static final int OPAQUE_FRAME = 32;
        static final int CLASS_NOT_PREPARED = 22;
        static final int FAILS_VERIFICATION = 62;
        static final int INVALID_METHODID = 23;
        static final int INVALID_CLASS = 21;
        static final int INVALID_OBJECT = 20;
        static final int ADD_METHOD_NOT_IMPLEMENTED = 63;
        static final int NULL_POINTER = 100;
        static final int DUPLICATE = 40;
        static final int INVALID_FRAMEID = 30;
        static final int UNATTACHED_THREAD = 115;
        static final int THREAD_NOT_SUSPENDED = 13;
        static final int INVALID_LOCATION = 24;
        static final int INVALID_TYPESTATE = 65;
        static final int THREAD_SUSPENDED = 14;
        static final int ABSENT_INFORMATION = 101;
        static final int INVALID_THREAD_GROUP = 11;
        static final int INTERNAL = 113;
        static final int NONE = 0;
        static final int INVALID_PRIORITY = 12;
        static final int ILLEGAL_ARGUMENT = 103;
        static final int SCHEMA_CHANGE_NOT_IMPLEMENTED = 64;
        static final int INVALID_EVENT_TYPE = 102;
        static final int NOT_CURRENT_FRAME = 33;
        static final int NOT_IMPLEMENTED = 99;
        static final int NO_MORE_FRAMES = 31;
        static final int NOT_FOUND = 41;

        Error() {
        }
    }

    static class EventKind {
        static final int VM_DISCONNECTED = 100;
        static final int VM_START = 90;
        static final int THREAD_DEATH = 7;
        static final int METHOD_EXIT = 41;
        static final int EXCEPTION_CATCH = 30;
        static final int USER_DEFINED = 5;
        static final int METHOD_ENTRY = 40;
        static final int VM_DEATH = 99;
        static final int CLASS_UNLOAD = 9;
        static final int CLASS_PREPARE = 8;
        static final int SINGLE_STEP = 1;
        static final int FIELD_MODIFICATION = 21;
        static final int CLASS_LOAD = 10;
        static final int THREAD_START = 6;
        static final int FRAME_POP = 3;
        static final int VM_INIT = 90;
        static final int BREAKPOINT = 2;
        static final int THREAD_END = 7;
        static final int FIELD_ACCESS = 20;
        static final int EXCEPTION = 4;

        EventKind() {
        }
    }

    static class ThreadStatus {
        static final int RUNNING = 1;
        static final int WAIT = 4;
        static final int SLEEPING = 2;
        static final int ZOMBIE = 0;
        static final int MONITOR = 3;

        ThreadStatus() {
        }
    }

    static class SuspendStatus {
        static final int SUSPEND_STATUS_SUSPENDED = 1;

        SuspendStatus() {
        }
    }

    static class ClassStatus {
        static final int PREPARED = 2;
        static final int VERIFIED = 1;
        static final int INITIALIZED = 4;
        static final int ERROR = 8;

        ClassStatus() {
        }
    }

    static class TypeTag {
        static final int CLASS = 1;
        static final int INTERFACE = 2;
        static final int ARRAY = 3;

        TypeTag() {
        }
    }

    static class Tag {
        static final int ARRAY = 91;
        static final int BYTE = 66;
        static final int CHAR = 67;
        static final int OBJECT = 76;
        static final int FLOAT = 70;
        static final int DOUBLE = 68;
        static final int INT = 73;
        static final int LONG = 74;
        static final int SHORT = 83;
        static final int VOID = 86;
        static final int BOOLEAN = 90;
        static final int STRING = 115;
        static final int THREAD = 116;
        static final int THREAD_GROUP = 103;
        static final int CLASS_LOADER = 108;
        static final int CLASS_OBJECT = 99;

        Tag() {
        }
    }

    static class StepDepth {
        static final int INTO = 0;
        static final int OVER = 1;
        static final int OUT = 2;

        StepDepth() {
        }
    }

    static class StepSize {
        static final int MIN = 0;
        static final int LINE = 1;

        StepSize() {
        }
    }

    static class SuspendPolicy {
        static final int NONE = 0;
        static final int EVENT_THREAD = 1;
        static final int ALL = 2;

        SuspendPolicy() {
        }
    }

    static class InvokeOptions {
        static final int INVOKE_SINGLE_THREADED = 1;
        static final int INVOKE_NONVIRTUAL = 2;

        InvokeOptions() {
        }
    }
}

